const pg = require("../General/Model");
const cron = require('node-cron');

// Utility to get current date in 'YYYY-MM-DD' format
const getCurrentDate = () => {
  const today = new Date();
  return today.toISOString().slice(0, 10);
};

// 2. Income Date Update Job - Runs every day at 11:00 PM IST
cron.schedule('30 17 * * *', async () => {
  console.log('Running Income Date Update Job at 11:00 PM IST');

  const client = await pg.connect();
  try {
    const currentDate = getCurrentDate();

    // Fetch all records where incomeDate matches the current date
    const vaultDataQuery = await client.query(`
      SELECT userid, coin, incomeDate
      FROM vault_pro
      WHERE incomeDate::date = $1
    `, [currentDate]);

    const vaults = vaultDataQuery.rows;

    for (let vault of vaults) {
      const { userid, coin } = vault;
      const newIncomeDate = new Date();
      newIncomeDate.setDate(newIncomeDate.getDate() + 30);  // Add 30 days to incomeDate

      // Update the incomeDate in the vault_pro table
      await client.query(`
        UPDATE vault_pro
        SET incomeDate = $1, updatedAt = NOW()
        WHERE userid = $2 AND coin = $3
      `, [newIncomeDate, userid, coin]);

      console.log(`Updated income date for user ${userid}, coin ${coin} to ${newIncomeDate}`);
    }
  } catch (error) {
    console.error('Error running Income Date Update Job:', error.message);
  } finally {
    client.release();
  }
});
