require('dotenv').config();
const { Worker } = require('bullmq')
const sportsQueue   = require('../sportsapi/queues/sportsQues');
const controllers   = require('../sportsapi/wrapper');

const connection = sportsQueue.client;


 new Worker(
       'sports',
  async job => {
     const { controller, payload } = job.data;
     console.log('Available controllers:', Object.keys(controllers));
     if (!controllers[controller]) throw new Error(`Unknown controller: ${controller}`);

     // adaptExpress gives us { statusCode, data }
     return await controllers[controller](payload);
   },
   { connection, concurrency: 20, limiter: { max: 15, duration: 1000 } }
 );

console.log('✅ Sports worker up and running');
