// import { useState, useEffect, useRef } from "react";
// import { ChevronLeft, ChevronRight } from "lucide-react";
// import styled from "styled-components";
// import { getUID(), sendNotfication } from "../../../Helper";
// import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
// import { faArrowLeft, faSpinner } from '@fortawesome/free-solid-svg-icons';
// import { gamesService } from "../../../utils/Services";

// const Container = styled.div`
//   width: 100%;
//   margin-top: 24px;
//   border-radius: 16px;
// `;

// const HeaderContainer = styled.div`
//   width: 100%;
//   display: flex;
//   justify-content: space-between;
//   align-items: center;
// `;

// const Title = styled.div`
//   color: white;
//   font-size: 16px;
//   font-weight: bold;
//   margin-left: 4px;
// `;

// const NavigationButton = styled.div`
//   padding: 6px 8px;
//    background-color: #03030F;
//   border-radius: 10px;
//   cursor: pointer;
//   display: flex;
//   align-items: center;
//   &:hover {
//     background-color: #4a5354;
//   }
// `;

// const CarouselContainer = styled.div`
//   position: relative;
//   width: 100%;
//   overflow: hidden;
// `;

// const ScrollContainer = styled.div`
//   display: flex;
//   gap: 20px;
//   overflow-x: auto;
//   scroll-behavior: smooth;
//   scrollbar-width: none;
//   -ms-overflow-style: none;
//   padding: 8px 4px;
  
//   &::-webkit-scrollbar {
//     display: none;
//   }
// `;

// const Card = styled.div`
//   flex: 0 0 calc(33.333% - 14px);
//   @media (max-width: 1024px) {
//     flex: 0 0 calc(50% - 10px);
//   }
//   @media (max-width: 768px) {
//     flex: 2 0 calc(100% - 5px);
//   }
// `;

// const FrameContainer = styled.div`
//   width: 100%;
//   display: block;
//   min-height: 169px;
//   border: 10px solid linear-gradient(135deg, #2A5B5A, #1C3D3C);
//   border-radius: 12px;
//   overflow: hidden;
//   margin-bottom: 16px;
// `;

// const GameImage = styled.img`
//   width: 100%;
//   height: 169px;
//   object-fit: cover;
// `;

// const FullScreenContainer = styled.div`
//     position: fixed;
//     top: 0;
//     left: 0;
//     width: 100%;
//     height: 100%;
//     z-index: 999;
//     background-color: #1b2336;
// `;

// const FullScreenIframe = styled.iframe`
//     width: 100%;
//     height: 100%;
//     border: none;
//     display: ${(props) => (props.loading ? 'none' : 'block')};
// `;

// const BackButton = styled.button`
//     position: absolute;
//     top: 10px;
//     left: 10px;
//     z-index: 1000;
//     background: none;
//     border: none;
//     color: #000;
//     font-size: 24px;
//     cursor: pointer;

//     @media (max-width: 768px) {
//         font-size: 20px; /* Reduced font size for mobile */
//     }
// `;

// const LoadingSpinner = () => (
//     <div style={{ display: 'inline-block', width: '16px', height: '16px', border: '2px solid #fff', borderTop: '2px solid transparent', borderRadius: '50%', animation: 'spin 1s linear infinite' }} />
// );

// const LobbySection = () => {
//   const scrollContainerRef = useRef(null);
//   const [windowWidth, setWindowWidth] = useState(window.innerWidth);
//   const [games, setGames] = useState([]);
//   const [showIframe, setShowIframe] = useState(false);
//   const [iframeUrl, setIframeUrl] = useState('');
//   const [iframeLoading, setIframeLoading] = useState(false);
 

//   // Gaming providers data mapped to fetched games
//   const gamingProviders = [
//     { id: 1, name: 'Playtech', imageUrl: '/assets/images/lobby/first.png' },
//     { id: 2, name: 'A Star', imageUrl: '/assets/images/lobby/second.png' },
//     { id: 3, name: 'Pragmatic Live', imageUrl: '/assets/images/lobby/third.png' },
//     { id: 4, name: 'Evolution', imageUrl: '/assets/images/lobby/fourth.png' },
//   ];

//   // Fetch games on mount
//   useEffect(() => {
//     const fetchGames = async () => {
//       const result = await fetchJSGamesByVendor('lobby', 1, 20); // Fetch 4 games
//       setGames(result.games); // Ensure only 4 games
//     };
//     fetchGames();
//   }, []);

//   // Handle window resize
//   useEffect(() => {
//     const handleResize = () => setWindowWidth(window.innerWidth);
//     window.addEventListener('resize', handleResize);
//     return () => window.removeEventListener('resize', handleResize);
//   }, []);

//   // Scroll handlers
//   const handleScrollLeft = () => {
//     if (scrollContainerRef.current) {
//       scrollContainerRef.current.scrollBy({
//         left: -scrollContainerRef.current.offsetWidth,
//         behavior: 'smooth',
//       });
//     }
//   };

//   const handleScrollRight = () => {
//     if (scrollContainerRef.current) {
//       scrollContainerRef.current.scrollBy({
//         left: scrollContainerRef.current.offsetWidth,
//         behavior: 'smooth',
//       });
//     }
//   };



//   // Fetch games by vendor
//   const fetchJSGamesByVendor = async (vendorName, page = 1, perPage = 4) => {
//     try {
//       const response = await fetch(`https://api.boss707.com/jsGames/games?vendor=${vendorName}&page=${page}&per_page=${perPage}`);
//       if (!response.ok) throw new Error('Network response was not ok');
//       const result = await response.json();
//       if (result.success && result.payload && result.payload.games) {
//         return {
//           games: result.payload.games,
//           pagination: result.payload.pagination || {
//             current_page: page,
//             per_page: perPage,
//             total: result.payload.games.length,
//             total_pages: Math.ceil(result.payload.games.length / perPage),
//           },
//         };
//       } else {
//         throw new Error('No games found or invalid response');
//       }
//     } catch (error) {
//       console.error(`Error fetching ${vendorName} games:`, error.message);
//       return { games: [], pagination: { current_page: 1, per_page: perPage, total: 0, total_pages: 0 } };
//     }
//   };

//   // Handle game launch
//   const handleGameLaunchJSGames = async (game) => {
//     const isLogged = localStorage.getItem('logged') === 'true';
//     if (!isLogged) {
//       sendNotfication('Please login to play', 'error');
//       return;
//     }

//     setIframeLoading(true);


//     try {
//       const credits = localStorage.getItem('credit');
//       const coins = localStorage.getItem('coin');
//       if (game.id === 2301 && coins !== 'INR') {
//         sendNotfication('Please use INR currency for this game', 'error');
//         setIframeLoading(false);
//         return;
//       }
//       if (game.id !== 2301 && coins !== 'USDT' && coins !== 'INR') {
//         sendNotfication('Please Swap Into USDT or INR To Play', 'error');
//         setIframeLoading(false);
//         return;
//       }

//       const requestPayload = {
//         game_uid: game.game_uid,
//         user_id: getUID(), // Assuming getUID() is user_id in localStorage
//         credit_amount: credits,
//         currency_code: coins,
//         language: 'en',
//       };

//       const response = await fetch('https://api.boss707.com/jsGamesv2/launch', {
//         method: 'POST',
//         headers: { 'Content-Type': 'application/json' },
//         body: JSON.stringify(requestPayload),
//       });

//       if (!response.ok) {
//         sendNotfication('Error Launching Game', 'error');
//         throw new Error('Network response was not ok');
//       }

//       const result = await response.json();
//       if (result.success && result.data.game_launch_url) {
//         setIframeUrl(result.data.game_launch_url);
//         setShowIframe(true);
//         setIframeLoading(true);
//       } else {
//         throw new Error('Failed to launch game: ' + (result.message || 'Unknown error'));
//       }
//     } catch (error) {
//       sendNotfication(error.message, 'error');
//       setIframeLoading(false);
//     }
//   };

//   // Handle iframe load
//   const handleIframeLoad = () => {
//     setIframeLoading(false);
//   };

//   // Handle back button
//   const handleBackButton = () => {
//     setShowIframe(false);
//     setIframeUrl('');
//     setIframeLoading(false);
//     window.location.reload(true);
//   };

//   // Handle game card click
//   const handleMatchClick = (provider, index) => {
//     console.log(index);
//     const game = games[index];
//     console.log(game);
//     if (game) {
//       handleGameLaunchJSGames(game);
//     } else {
//       sendNotfication('Game data not available', 'error');
//     }
//   };

 
//   const imageStyle = {
//     position: 'absolute',
//     top: '50%',
//     left: '50%',
//     transform: 'translate(-50%, -50%)',
//     width: '200px', /* Reduced width for mobile */
//     animation: 'fadeinout 2s infinite',
// };
// const animationStyle = `
//     @keyframes fadeinout {
//         0%, 100% { opacity: 0; }
//         50% { opacity: 1; }
//     }
// `;
//   // Render iframe when showIframe is true
//   if (showIframe) {
//     return (
//       <FullScreenContainer>
//         <style>{animationStyle}</style>
//         {iframeLoading && (
//           <img src="./assets/boss707.png" alt="Loading" style={imageStyle} />
//         )}
//         <FullScreenIframe
//           src={iframeUrl}
//           title="Game Iframe"
//           onLoad={handleIframeLoad}
//         />
//         <BackButton onClick={handleBackButton}>
//           <FontAwesomeIcon icon={faArrowLeft} />
//         </BackButton>
//       </FullScreenContainer>
//     );
//   }

//   return (
//     <Container>
   
//       <HeaderContainer>
//         <Title>Lobby</Title>
//         <div style={{ display: 'flex', gap: '10px', alignItems: 'center' }}>
//           <div style={{ display: 'flex', gap: '8px' }}>
//             <NavigationButton onClick={handleScrollLeft}>
//               <ChevronLeft size={16} />
//             </NavigationButton>
//             <NavigationButton onClick={handleScrollRight}>
//               <ChevronRight size={16} />
//             </NavigationButton>
//           </div>
//         </div>
//       </HeaderContainer>
//       <CarouselContainer>
//         <ScrollContainer ref={scrollContainerRef}>
//           {gamingProviders.map((provider, index) => (
//             <Card key={provider.id} onClick={() => handleMatchClick(provider, index)}>
//               <FrameContainer>
//                 <GameImage
//                   src={provider.imageUrl}
//                   alt={`${provider.name} gaming`}
//                 />
//               </FrameContainer>
//             </Card>
//           ))}
//         </ScrollContainer>
//       </CarouselContainer>
//     </Container>
//   );
// };

// export default LobbySection;


import { useState, useEffect, useRef } from "react";
import { ChevronLeft, ChevronRight, Play } from "lucide-react";
import styled from "styled-components";
import { getUID, sendNotfication } from "../../../Helper";
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowLeft } from '@fortawesome/free-solid-svg-icons';
import { gamesService } from "../../../utils/Services";

const Container = styled.div`
  width: 100%;
  margin-top: 24px;
  border-radius: 16px;
`;
const GameOverlay = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.4);
  backdrop-filter: blur(5px);
  border-radius: 12px;
  display: flex;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.2s ease;
`;

const HeaderContainer = styled.div`
  width: 100%;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const Title = styled.div`
  color: white;
  font-size: 16px;
  font-weight: bold;
  margin-left: 4px;
`;

const NavigationButton = styled.div`
  padding: 6px 8px;
  background-color: #03030F;
  border-radius: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  &:hover {
    background-color: #4a5354;
  }
`;

const CarouselContainer = styled.div`
  position: relative;
  width: 100%;
  overflow: hidden;
`;

const ScrollContainer = styled.div`
  display: flex;
  gap: 20px;
  overflow-x: auto;
  scroll-behavior: smooth;
  scrollbar-width: none;
  -ms-overflow-style: none;
  padding: 8px 4px;
  
  &::-webkit-scrollbar {
    display: none;
  }
`;

const Card = styled.div`
  flex: 0 0 calc(33.333% - 14px);
  position: relative;
  cursor: pointer;
  transition: transform 0.2s ease;
  
  &:hover {
    transform: translateY(-5px);
    
    ${GameOverlay} {
      opacity: 1;
    }
  }

  @media (max-width: 1024px) {
    flex: 0 0 calc(50% - 10px);
  }
  @media (max-width: 768px) {
    flex: 0 0 calc(100% - 5px);
  }
`;



const PlayIconContainer = styled.div`
  width: 50px;
  height: 50px;
  border-radius: 50%;
  background-color: rgba(255, 255, 255, 0.3);
  display: flex;
  justify-content: center;
  align-items: center;
`;

const PlayIcon = styled(Play)`
  color: #fff;
  font-size: 24px;
`;

const FrameContainer = styled.div`
  width: 100%;
  display: block;
  min-height: 169px;
  border: 10px solid linear-gradient(135deg, #2A5B5A, #1C3D3C);
  border-radius: 12px;
  overflow: hidden;
  margin-bottom: 16px;
`;

const GameImage = styled.img`
  width: 100%;
  height: 169px;
  object-fit: cover;
`;

const FullScreenContainer = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 999;
  background-color: #1b2336;
`;

const FullScreenIframe = styled.iframe`
  width: 100%;
  height: 100%;
  border: none;
  display: ${(props) => (props.loading ? 'none' : 'block')};
`;

const BackButton = styled.button`
  position: absolute;
  top: 10px;
  left: 10px;
  z-index: 1000;
  background: none;
  border: none;
  color: #000;
  font-size: 24px;
  cursor: pointer;

  @media (max-width: 768px) {
    font-size: 20px;
  }
`;

const LobbySection = () => {
  const scrollContainerRef = useRef(null);
  const [windowWidth, setWindowWidth] = useState(window.innerWidth);
  const [games, setGames] = useState([]);
  const [showIframe, setShowIframe] = useState(false);
  const [iframeUrl, setIframeUrl] = useState('');
  const [iframeLoading, setIframeLoading] = useState(false);

  const gamingProviders = [
    { id: 1, name: 'Playtech', imageUrl: '/assets/images/lobby/first.png' },
    { id: 2, name: 'A Star', imageUrl: '/assets/images/lobby/second.png' },
    { id: 3, name: 'Pragmatic Live', imageUrl: '/assets/images/lobby/fourth.png' },
    { id: 4, name: 'Evolution', imageUrl: '/assets/images/lobby/third.png' },
  ];

  useEffect(() => {
    const fetchGames = async () => {
      const result = await fetchJSGamesByVendor('lobby', 1, 4);
      setGames(result.games);
    };
    fetchGames();
  }, []);

  useEffect(() => {
    const handleResize = () => setWindowWidth(window.innerWidth);
    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize);
  }, []);

  const handleScrollLeft = () => {
    if (scrollContainerRef.current) {
      scrollContainerRef.current.scrollBy({
        left: -scrollContainerRef.current.offsetWidth,
        behavior: 'smooth',
      });
    }
  };

  const handleScrollRight = () => {
    if (scrollContainerRef.current) {
      scrollContainerRef.current.scrollBy({
        left: scrollContainerRef.current.offsetWidth,
        behavior: 'smooth',
      });
    }
  };

  const fetchJSGamesByVendor = async (vendorName, page = 1, perPage = 4) => {
    try {
      const result = await gamesService.getGamesByVendor(vendorName, page, perPage);
      if (result.success && result.payload && result.payload.games) {
        return {
          games: result.payload.games,
          pagination: result.payload.pagination || {
            current_page: page,
            per_page: perPage,
            total: result.payload.games.length,
            total_pages: Math.ceil(result.payload.games.length / perPage),
          },
        };
      } else {
        throw new Error('No games found or invalid response');
      }
    } catch (error) {
      console.error(`Error fetching ${vendorName} games:`, error.message);
      return { games: [], pagination: { current_page: 1, per_page: perPage, total: 0, total_pages: 0 } };
    }
  };

  const handleGameLaunchJSGames = async (game) => {
    const isLogged = localStorage.getItem('logged') === 'true';
    if (!isLogged) {
      sendNotfication('Please login to play', 'error');
      return;
    }

    setIframeLoading(true);

    try {
      const credits = localStorage.getItem('credit');
      const coins = localStorage.getItem('coin');
      if (game.id === 2301 && coins !== 'INR') {
        sendNotfication('Please use INR currency for this game', 'error');
        setIframeLoading(false);
        return;
      }
      if (game.id !== 2301 && coins !== 'USDT' && coins !== 'INR') {
        sendNotfication('Please Swap Into USDT or INR To Play', 'error');
        setIframeLoading(false);
        return;
      }

      const requestPayload = {
        game_uid: game.game_uid,
        user_id: getUID(),
        credit_amount: credits,
        currency_code: coins,
        language: 'en',
      };

      const result = await gamesService.launchGame(requestPayload);
      if (result.success && result.data.game_launch_url) {
        setIframeUrl(result.data.game_launch_url);
        setShowIframe(true);
        setIframeLoading(true);
      } else {
        throw new Error('Failed to launch game: ' + (result.message || 'Unknown error'));
      }
    } catch (error) {
      sendNotfication(error.message, 'error');
      setIframeLoading(false);
    }
  };

  const handleIframeLoad = () => {
    setIframeLoading(false);
  };

  const handleBackButton = () => {
    setShowIframe(false);
    setIframeUrl('');
    setIframeLoading(false);
    window.location.reload(true);
  };

  const handleMatchClick = (provider, index) => {
    const game = games[index];
    if (game) {
      handleGameLaunchJSGames(game);
    } else {
      sendNotfication('Game data not available', 'error');
    }
  };

  const imageStyle = {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    width: '200px',
    animation: 'fadeinout 2s infinite',
  };
  const animationStyle = `
    @keyframes fadeinout {
      0%, 100% { opacity: 0; }
      50% { opacity: 1; }
    }
  `;

  if (showIframe) {
    return (
      <FullScreenContainer>
        <style>{animationStyle}</style>
        {iframeLoading && (
          <img src="./assets/boss707.png" alt="Loading" style={imageStyle} />
        )}
        <FullScreenIframe
          src={iframeUrl}
          title="Game Iframe"
          onLoad={handleIframeLoad}
        />
        <BackButton onClick={handleBackButton}>
          <FontAwesomeIcon icon={faArrowLeft} />
        </BackButton>
      </FullScreenContainer>
    );
  }

  return (
    <Container>
      <HeaderContainer>
        <Title>Lobby</Title>
        <div style={{ display: 'flex', gap: '10px', alignItems: 'center' }}>
          <div style={{ display: 'flex', gap: '8px' }}>
            <NavigationButton onClick={handleScrollLeft}>
              <ChevronLeft size={16} />
            </NavigationButton>
            <NavigationButton onClick={handleScrollRight}>
              <ChevronRight size={16} />
            </NavigationButton>
          </div>
        </div>
      </HeaderContainer>
      <CarouselContainer>
        <ScrollContainer ref={scrollContainerRef}>
          {gamingProviders.map((provider, index) => (
            <Card key={provider.id} onClick={() => handleMatchClick(provider, index)}>
              <FrameContainer>
                <GameImage
                  src={provider.imageUrl}
                  alt={`${provider.name} gaming`}
                />
                <GameOverlay>
                  <PlayIconContainer>
                    <PlayIcon />
                  </PlayIconContainer>
                </GameOverlay>
              </FrameContainer>
            </Card>
          ))}
        </ScrollContainer>
      </CarouselContainer>
    </Container>
  );
};

export default LobbySection;