
import React, { useState, useLayoutEffect } from 'react';
import styled, { keyframes } from 'styled-components';
import { CheckCircle } from 'lucide-react';
import { useHistory } from 'react-router-dom';

const fadeIn = keyframes`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;

const slideIn = keyframes`
  from {
    transform: translate(-50%, -40%);
    opacity: 0;
  }
  to {
    transform: translate(-50%, -50%);
    opacity: 1;
  }
`;

const ModalOverlay = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.7);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 9999;
  animation: ${fadeIn} 0.3s ease-out;
`;
const CloseButton = styled.button`
  position: absolute;
  top: 10px;
  left: 10px; // Changed from right to left
  background: rgba(0, 0, 0, 0.5);
  border: none;
  color: white;
  width: 30px;
  height: 30px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  z-index: 2;
  transition: all 0.2s ease;


  

`;

const JoinButton = styled.div`
  position: absolute;
  bottom: 10%;
  left: 50%; // Center horizontally
  transform: translateX(-50%); // Offset by half its width to truly center
  background: #DDBA5E;
  border: none;
  color: black;
  padding:10px;
  font-weight:bold;
  border-radius: 10%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  z-index: 2;
  transition: all 0.2s ease;
`;
const ModalContent = styled.div`
  position: fixed;
  top: 48%;
  left: 50%;
  transform: translate(-50%, -50%);
//   background: #03030F;
background:#D8AB59;
//   padding: 2rem;
// border:1px solid #D8AB59;
//   border-radius: 16px;
  width: 90%;
  max-width: 750px;
  text-align: center;
  animation: ${slideIn} 0.3s ease-out;
  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);

  @media (max-width: 768px) {
    width: 97%;
    top:52%;
    // padding: 1.5rem;
  }
`;

const IconWrapper = styled.div`
  margin-bottom: 1.5rem;
  display: flex;
  justify-content: center;
  
  svg {
    width: 64px;
    height: 64px;
    color: #4AE54A;
  }

  @media (max-width: 768px) {
    svg {
      width: 48px;
      height: 48px;
    }
  }
`;

const Title = styled.h2`
  color: white;
  font-size: 1.875rem;
  font-weight: 600;
  margin-bottom: 1rem;

  @media (max-width: 768px) {
    font-size: 1.5rem;
  }
`;

const Message = styled.p`
  color: rgba(255, 255, 255, 0.9);
  font-size: 1rem;
  margin-bottom: 1.5rem;
  line-height: 1.5;

  @media (max-width: 768px) {
    font-size: 0.875rem;
  }
`;

const Button = styled.button`
  background: linear-gradient(to right, #4AE54A, #94E874);
  color: #000;
  border: none;
  padding: 0.75rem 2rem;
  border-radius: 8px;
  font-weight: 600;
  font-size: 1rem;
  cursor: pointer;
  transition: transform 0.2s;
  width: 100%;

  &:hover {
    transform: translateY(-2px);
  }

  &:active {
    transform: translateY(0);
  }

  @media (max-width: 768px) {
    font-size: 0.875rem;
    padding: 0.625rem 1.5rem;
  }
`;

const LoginSuccessModal = () => {
    const [isVisible, setIsVisible] = useState(false);
    const [showAfterDelay, setShowAfterDelay] = useState(false);
    const [imageLoaded, setImageLoaded] = useState(false);
    const [promoImage, setPromoImage] = useState('');
    const history=useHistory()

    useLayoutEffect(() => {
        const checkCountryAndLogin = () => {
            const loginSuccess = localStorage.getItem('showLoginSuccessModal');
            const country = localStorage.getItem('country');

            if (loginSuccess === 'true') {
                setIsVisible(true);
                localStorage.removeItem('showLoginSuccessModal');
                
                // Set image based on country
                setPromoImage(country === 'MV' 
                    ? '/assets/images/promoMvr.jpg'
                    : '/assets/images/promo-banner.jpg'
                );
            }
        };

        checkCountryAndLogin();

        // Listen for storage changes
        const handleStorageChange = (e) => {
            if (e.key === 'country' || e.key === 'showLoginSuccessModal') {
                checkCountryAndLogin();
            }
        };

        window.addEventListener('storage', handleStorageChange);
        return () => window.removeEventListener('storage', handleStorageChange);
    }, []);

    const handleClose = () => {
        setIsVisible(false);
        setImageLoaded(false);
    };

    const handleImageLoad = () => {
        setImageLoaded(true);
    };

    useLayoutEffect(() => {
        if (imageLoaded) {
            setShowAfterDelay(true);
        }
    }, [imageLoaded]);

    if (!isVisible) return null;

    return (
        <ModalOverlay style={{ opacity: imageLoaded ? 1 : 0, transition: 'opacity 0.3s ease-in-out' }}>
            <ModalContent>
                <CloseButton 
                    style={{ display: imageLoaded ? 'block' : 'none'}} 
                    onClick={handleClose} 
                    aria-label="Close modal"
                >
                    X
                </CloseButton>
                <img 
                    style={{ 
                        width: '100%', 
                        height: '100%',
                        display: imageLoaded ? 'block' : 'none'
                    }} 
                    src={promoImage}
                    onLoad={handleImageLoad}
                    alt="Login success"
                />
                <JoinButton style={{ display: imageLoaded ? 'block' : 'none'}} onClick={()=>{
                  handleClose()
                  setTimeout(()=>{
                    history.push("/club-membership")
                  },1000)
                }}>Join Now</JoinButton>
            </ModalContent>
        </ModalOverlay>
    );
};

export default LoginSuccessModal;