import React, { useEffect, useState } from 'react';
import { getToken, onMessageListener } from '../../services/firebase';
import { notificationService } from '../../utils/Services';

const NotificationManager = ({ userId }) => {
    const [notification, setNotification] = useState(null);

    useEffect(() => {
        const setupNotifications = async () => {
            try {
                const token = await getToken();
                
                await notificationService.registerFirebase({
                    userId,
                    token,
                    deviceType: navigator.userAgent,
                    platform: 'web'
                });

                onMessageListener((payload) => {
                    setNotification(payload.notification);
                    new Notification(payload.notification.title, {
                        body: payload.notification.body
                    });
                });
            } catch (error) {
                console.error('Notification setup failed:', error);
            }
        };

        if (userId) {
            setupNotifications();
        }
    }, [userId]);

    return notification ? (
        <div className="notification-toast">
            <h4>{notification.title}</h4>
            <p>{notification.body}</p>
        </div>
    ) : null;
};

export default NotificationManager;