import React, { useState, useLayoutEffect } from 'react';
import styled from 'styled-components';

const Grid = styled.div`
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 20px;
  margin:12px 0px;
  
  @media (max-width: 768px) {
    grid-template-columns: 1fr;
  }
`;

const Card = styled.div`
  background-image: ${props => props.background || '#2A2A2A'};
  border-radius: 12px;
  padding: 24px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  min-height: 160px;
  background-color: rgba(50, 55, 56, 1); /* Correctly applied RGBA background color */
`;

const Card1 = styled.div`
  background-image: ${props => `url(${props.bgUrl})`};
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  border-radius: 12px;
  padding: 24px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  min-height: 160px;
  position: relative;

  &::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border-radius: 12px;
    z-index: 1;
  }

  > * {
    position: relative;
    z-index: 2;
  }
`;


const ContentWrapper = styled.div`
  display: flex;
  flex-direction: column;
  gap: 12px;
`;

const BonusText = styled.h2`
  color: #00FF9D;
  font-size: 24px;
  margin: 0;
  font-weight: 600;
`;

const SubText = styled.p`
  color: white;
  font-size: 18px;
  margin: 0;
`;

const Status = styled.div`
  background: #1A1A1A;
  padding: 8px 16px;
  border-radius: 20px;
  color: #00FF9D;
  font-size: 14px;
  display: inline-block;
  margin-top: 8px;
`;

const Image = styled.img`
  width: 80px;
  height: 80px;
  object-fit: contain;
`;

const BonusCards = () => {
    const [country, setCountry] = useState('');
    const [currentBanners, setCurrentBanners] = useState([]);
    const [promotionCards, setPromotionCards] = useState([]);

    useLayoutEffect(() => {
        const checkCountry = () => {
            const userCountry = localStorage.getItem('country') || '';
            setCountry(userCountry);

            const cards = [
                {
                    bonusText: "100% Bonus +",
                    subText: "100 Free Bet In Casino",
                    status: "In Progress",
                    image: userCountry === "MV" 
                        ? "/assets/images/bcgames/promotionpage/wheel.webp"
                        : "/assets/images/bcgames/promotionpage/wheel.webp",
                    background: "linear-gradient(240deg, rgba(255, 168, 37, 0.4) -16.41%, rgba(255, 220, 37, 0) 71.96%);"
                },
                {
                    bonusText: "100% Bonus +",
                    subText: "5 Free Bet In Sports",
                    status: "In Progress",
                    image: userCountry === "MV" 
                        ? "/assets/images/bcgames/promotionpage/cup-1.webp"
                        : "/assets/images/bcgames/promotionpage/cup-1.webp",
                    background: "linear-gradient(240deg, rgba(64, 163, 106, 0.8) -16.41%, rgba(36, 220, 114, 0) 71.96%);"
                }
            ];

            const bannerImages = {
                default: [
                    "/assets/images/bcgames/promotionpage/b1.png",
                    "/assets/images/bcgames/promotionpage/b2.png",
                    "/assets/images/bcgames/promotionpage/b3.png",
                    "/assets/images/bcgames/promotionpage/b4.png"
                ],
                MV: [
                    "/assets/images/promo/mvr2.png",
                    "/assets/images/promo/mvr1.png",
                    "/assets/images/promo/sportsMV2.avif",
                    "/assets/images/promo/mvr3.png",
                ]
            };

            setPromotionCards(cards);
            setCurrentBanners(userCountry === "MV" ? bannerImages.MV : bannerImages.default);
        };

        checkCountry();

        // Listen for changes in localStorage
        const handleStorageChange = (e) => {
            if (e.key === 'country') {
                checkCountry();
            }
        };

        window.addEventListener('storage', handleStorageChange);

        return () => {
            window.removeEventListener('storage', handleStorageChange);
        };
    }, []);

    return (
        <Grid>
            {promotionCards.map((card, index) => (
                <Card key={index} background={card.background}>
                    <ContentWrapper>
                        <BonusText>{card.bonusText}</BonusText>
                        <SubText>{card.subText}</SubText>
                    </ContentWrapper>
                    <Image src={card.image} alt={`${card.subText} icon`} />
                </Card>
            ))}
            
            {currentBanners.map((bannerUrl, index) => (
                <Card1 
                    key={`banner-${index}`} 
                    bgUrl={bannerUrl}
                >
                    <ContentWrapper>
                        {/* Content remains the same */}
                    </ContentWrapper>
                </Card1>
            ))}
        </Grid>
    );
};

export default BonusCards;