import React from 'react';
import styled from 'styled-components';

const Header = styled.header`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  background-color: #ffffff;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
  z-index: 1000;
`;

const HeaderContainer = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 1rem 2rem;
  max-width: 1200px;
  margin: 0 auto;
`;

const Logo = styled.div`
  font-size: 1.5rem;
  font-weight: bold;
  
  a {
    color: #333;
    text-decoration: none;
  }
`;

const Nav = styled.nav`
  ul {
    display: flex;
    list-style-type: none;
    padding: 0;
    margin: 0;
  }

  li {
    margin-left: 1rem;
  }

  a {
    color: #333;
    text-decoration: none;
    &:hover {
      color: #007bff;
    }
  }
`;

const GuestHeaderNew = ({ t, location }) => {
  return (
    <Header>
      <HeaderContainer>
        <Logo>
          <a href="/">{t('YourLogo')}</a>
        </Logo>
        <Nav>
          <ul>
            <li><a href="/login">{t('Login')}</a></li>
            <li><a href="/register">{t('Register')}</a></li>
          </ul>
        </Nav>
      </HeaderContainer>
    </Header>
  );
};

export default GuestHeaderNew;