import React, { useState, useLayoutEffect, useEffect, useContext } from 'react';
import styled, { css } from 'styled-components';
import { Link, useLocation } from 'react-router-dom';
import MenuPlayIcon from '../../../Icons/Menu';
import SearchStarIcon from '../../../Icons/Search';
import ClaudeIcon from '../../../Icons/Casino';
import GameIcon from '../../../Icons/Game';
import MessageIcon from '../../../Icons/Chat';
import { addNewStyle, CRISTP_ID, getUID, wait } from '../../../Helper';
import LotteryIcon from '../../../Icons/Lottery';
import storage from '../../../Storage';
import { useGameLaunch } from '../../../context/gameLaunchContext';
import { launchGame } from '../../../services/gameLaunchService';
import { cleanupNotifications, onMessageListener ,getToken,} from '../../../services/firebase';
import { NotificationContext } from '../../../context/notificationcontext';
import NotificationsSkyla from '../../../Icons/Notifications';
import { notificationService } from '../../../utils/Services';
import axios from 'axios';
// Animation keyframes
const clickAnimation = css`
  @keyframes clickEffect {
    0% {
      transform: scale(1);
      opacity: 0.8;
    }
    50% {
      transform: scale(1.1);
      opacity: 1;
    }
    100% {
      transform: scale(1);
      opacity: 1;
    }
  }
`;

const BottomNavWrapper = styled.nav`
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: #03030F;
  border-top: 1px solid #2C2F36;
  border-top-left-radius: 10px;
  border-top-right-radius: 10px;
  display: none;
  z-index: 666;
  @media (max-width: 768px) {
    display: block;
  }
`;

const NavContainer = styled.div`
  display: flex;
  justify-content: space-around;
  align-items: center;
  height: 60px;
`;

const NavItem = styled(Link)`
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-decoration: none;
  padding: 8px;
  transition: all 0.2s ease;
  color: ${props => props.$active === 'true' ? '#f09c06' : '#9CA3AF'};
  ${clickAnimation}
  
  &:hover {
    color: #f09c06;
  }
  
  ${props => props.$active === 'true' && css`
    animation: clickEffect 0.3s ease-out;
  `}
`;

const NavIconWrapper = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  margin-bottom: 4px;
  & svg {
    color: ${props => props.$active ? '#f09c06' : '#9CA3AF'};
    stroke: ${props => props.$active ? '#f09c06' : '#9CA3AF'};
    transition: all 0.2s ease;
  }
`;

const NavLabel = styled.span`
  font-size: 10px;
  font-weight: 500;
  transition: all 0.2s ease;
`;

const BottomNavigation = () => {
  // Get token from localStorage - define this first
  function getAuthToken() {
    return localStorage.getItem('token');
  }
  
  const location = useLocation();
  const [loaded, setLoaded] = useState(false);
  const [navItems, setNavItems] = useState([]);
  const [isLoggedIn, setIsLoggedIn] = useState(false);
  const [activeTab, setActiveTab] = useState('');
  const { showNotification } = useContext(NotificationContext);
  const [notifications, setNotifications] = useState({ unread: [], read: [] });
  const [isLoading, setIsLoading] = useState(false);
  const [isOpenSearch, setIsOpenSearch] = useState(false);
  const [unreadCount, setUnreadCount] = useState(0);
  const { setGameUrl, setIsGameOpen } = useGameLaunch();

  // const handleSportsClick = async () => {
  //   try {
  //     const credits = localStorage.getItem('credit') || '0';
  //     const coins = localStorage.getItem('coin') || 'INR';
      
  //     const id = getUID();
  //          const gameUrl = await launchGame(
  //            '92b24e4c25107367a80e0fe1a97c24e4', 
  //            id, 
  //            coins,
  //            credits
  //          );
      
  //     if (gameUrl) {
  //       setGameUrl(gameUrl);
  //       setIsGameOpen(true);
  //       setActiveTab('Sports');
  //     }
  //   } catch (error) {
  //     console.error('Failed to launch sports game:', error);
  //   }
  // };



   const handleSportsClick = async () => {
      try {
        const credits = localStorage.getItem('credit') || '0';
        const coins = localStorage.getItem('coin') || 'INR';  
        const id = getUID();
        const gameUrl = await launchGame(
          '92b24e4c25107367a80e0fe1a97c24e4', 
          id, 
          coins,
          credits
        );
        if (gameUrl) {
          setGameUrl(gameUrl);
          setIsGameOpen(true);
        } else {
          console.error('Failed to get game URL');
        }
      } catch (error) {
        console.error('Failed to launch sports game:', error);
      }
    };
  

  const loggedInNavItems = [
    { path: '/menu', icon: <MenuPlayIcon />, label: 'Menu' },
    { path: '/explore', icon: <SearchStarIcon />, label: 'Explore' },
    { path: '/', icon: <ClaudeIcon />, label: 'Casino' },
    { path: '/', icon: <GameIcon />, label: 'Sports', onClick: handleSportsClick },
    // { path: '/chat', icon: <MessageIcon />, label: 'Chat' }
    // { path: '/sports/markets/in-play', icon: <GameIcon />, label: 'Sports', },
    { path: '/notification', icon: <NotificationsSkyla/>, label: 'Notification' }
  ];

  const withoutLoginNavItems = [
    { path: '/menu', icon: <MenuPlayIcon />, label: 'Menu' },
    { path: '/explore', icon: <SearchStarIcon />, label: 'Explore' },
    // { path: '/lottery', icon: <LotteryIcon />, label: 'Lottery' },
    { path: '/', icon: <ClaudeIcon />, label: 'Casino' },
     { path: '/sports/markets/in-play', icon: <GameIcon />, label: 'Sports', },
    // { path: '/chat', icon: <MessageIcon />, label: 'Chat' },
    // { path: '/chat', icon: <NotificationsSkyla/>, label: 'Notification' }
    

  ];

  useLayoutEffect(() => {
    const checkAuthStatus = () => {
      const token = localStorage.getItem('token');
      setIsLoggedIn(!!token);
      setNavItems(!!token ? loggedInNavItems : withoutLoginNavItems);
      const currentItem = (!!token ? loggedInNavItems : withoutLoginNavItems)
        .find(item => item.path === location.pathname);
      setActiveTab(currentItem?.label || '');
    };

    checkAuthStatus();
    window.addEventListener('storage', checkAuthStatus);
    return () => window.removeEventListener('storage', checkAuthStatus);
  }, [location.pathname]);

  const support = () => {
    window.$crisp = [];
    window.CRISP_WEBSITE_ID = CRISTP_ID;
    
    window.$crisp.push(["config", "container:fullpage", true]);
    window.$crisp.push(["config", "position:reverse", true]);
    window.$crisp.push(["config", "hide:on:mobile", false]);
    window.$crisp.push(["config", "button:hide", true]);
    
    if (!loaded) {
      setLoaded(true);
      const script = document.createElement('script');
      script.src = "https://client.crisp.chat/l.js";
      script.id = "chtt";
      script.async = true;
      
      script.onload = function() {
        setTimeout(() => {
          window.$crisp.push(["do", "chat:open"]);
          const crispStyles = `
            .crisp-client .cc-1xry { display: none !important; }
            .crisp-client .cc-kv6t { visibility: visible !important; opacity: 1 !important; display: block !important; }
            .crisp-client .cc-k5k0 { visibility: visible !important; opacity: 1 !important; display: block !important; }
            @media screen and (max-width: 768px) {
              #crisp-chatbox { display: block !important; z-index: 1000000 !important; }
              .crisp-client .cc-kv6t { max-height: 100% !important; height: 100% !important; }
            }
          `;
          const styleSheet = document.createElement("style");
          styleSheet.id = "crisp-custom-styles";
          styleSheet.innerText = crispStyles;
          document.head.appendChild(styleSheet);
        }, 1000);
      };
      
      document.head.appendChild(script);
    } else {
      window.$crisp.push(["do", "chat:open"]);
    }
    
    addNewStyle("#crisp-chatbox { display: block !important; }");
    addNewStyle(".crisp-client .cc-1xry { display: none !important; }");
    
    wait(2000).then(() => {
      const close = document.querySelector(".cc-wdhl");
      if (close) {
        close.addEventListener("click", function () {
          addNewStyle("#crisp-chatbox { display: none !important; }");
          addNewStyle(".crisp-client { display: none !important; visibility: hidden !important; }");
          window.$crisp.push(["do", "chat:hide"]);
          window.$crisp.push(["do", "session:reset"]);
          const crispScript = document.getElementById("chtt");
          if (crispScript) crispScript.remove();
          const customStyles = document.getElementById("crisp-custom-styles");
          if (customStyles) customStyles.remove();
          setLoaded(false);
        });
      }
    });
  };

  const manageClick = (label, itemOnClick) => {
    setActiveTab(label);
    if (label === 'Chat') {
      support();
   
    } else if (itemOnClick) {
      itemOnClick();
    }
  };



  const fetchUnreadCount = async () => {
    try {
      const uid = getUID();
      const data = await notificationService.getUnreadCount(uid);
      if (data.success && typeof setUnreadCount === 'function') {
        setUnreadCount(data.unreadCount);
      }
    } catch (error) {
      console.error('Failed to fetch unread count:', error);
    }
  };

  const fetchNotifications = async () => {
    setIsLoading(true);
    try {
       const uid = getUID();
      const data = await notificationService.getNotificationHistory(uid);
      if (data.success) {
        setNotifications({
          unread: data.notifications.unread || [],
          read: data.notifications.read || []
        });
      }
      await fetchUnreadCount();
    } catch (error) {
      console.error('Failed to fetch notifications:', error);
    } finally {
      setIsLoading(false);
    }
  };

  const markAsRead = async (notificationId) => {
    try {
      const response = await notificationService.markAsRead({
        userId: getUID(),
        notificationIds: [notificationId]
      });

      if (response.success) {
        setNotifications(prev => {
          const updatedUnread = prev.unread.filter(n => n.id !== notificationId);
          const movedNotification = prev.unread.find(n => n.id === notificationId);
          return {
            unread: updatedUnread,
            read: movedNotification ? [...prev.read, { ...movedNotification, is_read: true }] : prev.read
          };
        });
        await fetchNotifications();
      }
    } catch (error) {
      console.error('Failed to mark notification as read:', error);
    }
  };

  const markAllAsRead = async () => {
    try {
      const unreadIds = notifications.unread.map(notification => notification.id);
      const response = await notificationService.markMultipleAsRead({
        userId: getUID(),
        notificationIds: unreadIds
      });

      if (response.success) {
        setNotifications(prev => ({
          unread: [],
          read: [...prev.read, ...prev.unread.map(n => ({ ...n, is_read: true }))]
        }));
        await fetchNotifications();
      }
    } catch (error) {
      console.error('Failed to mark all notifications as read:', error);
    }
  };

useEffect(() => {
  try {
    const token = getAuthToken();
    if (!token) return; // Exit early if token is not present

    fetchNotifications();
    fetchUnreadCount();
  } catch (error) {
    console.error('Error in useEffect:', error);
  }
}, []);


let notificationCounter = 0;
  const generateUniqueId = () => {
    notificationCounter += 1;
    return `${Date.now()}-${notificationCounter}`;
  };

  const setupNotifications = async () => {
    let unsubscribeFromMessages = null;

    try {
      if (!('Notification' in window)) {
        console.error('This browser does not support notifications');
        return () => {};
      }

      if ('serviceWorker' in navigator) {
        try {
          const registration = await navigator.serviceWorker.register('/firebase-messaging-sw.js');
   
        } catch (error) {
          console.error('Service Worker registration failed:', error);
        }
      }

      const token = await getToken();
      console.log('fcm', token);
      await axios.post('https://api.boss707.com/firebase/register', {
        userId: getUID(),
        token,
        deviceType: navigator.userAgent,
        platform: 'web'
      });

      unsubscribeFromMessages = onMessageListener((payload) => {
   

        try {
          if (Notification.permission === 'granted') {
            const browserNotification = new Notification(payload.notification.title, {
              body: payload.notification.body,
              icon: './assets/boss707.png"',
              tag: 'notification-' + generateUniqueId(),


            });

            browserNotification.onclick = (event) => {
              event.preventDefault();
              window.focus();
              browserNotification.close();
            };
          }

          showNotification({
            title: payload.notification.title || 'New Notification',
            body: payload.notification.body || '',
          });
        } catch (error) {
          console.error('Notification creation failed:', error);
        }
      });

    } catch (error) {
      console.error('Notification setup failed:', error);
      console.error('Error details:', error.message);
    }

    return () => {
      if (unsubscribeFromMessages) {
        unsubscribeFromMessages();
      }
    };
  };

useEffect(() => {
  let unsubscribe;

  const token = getAuthToken(); // Use the getAuthToken function

  if (!token) return; // Exit early if token is null or undefined

  const setup = async () => {
    unsubscribe = await setupNotifications();
  };

  setup();

  return () => {
    if (unsubscribe) unsubscribe();
    cleanupNotifications();
  };
}, []);


  return (
    <BottomNavWrapper>
     <NavContainer>
        {navItems.map((item) => {
          const isActive = activeTab === item.label;
          return (
            <NavItem
              key={item.path}
              to={item.path}
              onClick={(e) => {
                if (item.label === 'Chat') {
                  e.preventDefault();
                }
                manageClick(item.label, item.onClick);
              }}
              $active={isActive.toString()}
            >
              <NavIconWrapper $active={isActive}>
                {item.label === 'Notification' && unreadCount > 0 ? (
                  <div style={{ position: 'relative' }}>
                    {item.icon}
                    <span 
                      style={{
                        position: 'absolute',
                        top: '-5px',
                        right: '-5px',
                        background: '#f09c06',
                        color: 'white',
                        borderRadius: '50%',
                        width: '15px',
                        height: '15px',
                        fontSize: '10px',
                        display: 'flex',
                        alignItems: 'center',
                        justifyContent: 'center'
                      }}
                    >
                      {unreadCount}
                    </span>
                  </div>
                ) : (
                  item.icon
                )}
              </NavIconWrapper>
              <NavLabel>{item.label}</NavLabel>
            </NavItem>
          );
        })}
      </NavContainer>
    </BottomNavWrapper>
  );
};

export default BottomNavigation;