import React, { useState } from 'react';
import styled from 'styled-components';
import { ChevronDown, ChevronRight ,Gift, Users, Trophy, Newspaper, MessageSquare, Handshake, Shield, Headphones, Globe } from 'lucide-react';

const SidebarContainer = styled.div`
  background-color: #1A2C38;
  color: #ffffff;
  width: 100%;
  border-radius: 10px;
  font-family: Arial, sans-serif;
`;
const MainWrapper = styled.div`
  display: flex;
  flex-direction: column;
  gap: 2px; 
  padding: 10px;
`;

const MenuItemWrapper = styled.div`
  display: flex;
  align-items: center;
  padding: 10px;
  cursor: pointer;
  background-color: ${({ active }) => (active ? '#213743' : 'transparent')};
  &:first-child {
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
  }

  &:last-child {
    border-bottom-left-radius: 10px;
    border-bottom-right-radius: 10px;
  }
     &:hover {
    background-color: #2F4553;
  }
    
`;

const MenuItemText = styled.span`
  margin-left: 10px;
`;

const SubMenu = styled.div`
  background-color: #213743;
`;

const ExpandIconWrapper = styled(ChevronDown)`
height: 20px;
width:20px;
display: flex;
align-items: center;
justify-content: center;
margin-left: auto;
background-color: ${({ open }) => (open ? 'white' : 'blue')};
  margin-left: auto;
//   transform: ${({ open }) => (open ? 'rotate(360deg)' : 'rotate(272deg)')};
  transition: transform 0.3s ease;
`;

const ExpandIcon = styled( ChevronRight )`
`;

const AccordionMenu = () => {
    const [promotionsOpen, setPromotionsOpen] = useState(false);
    const [sponsorshipsOpen, setSponsorshipsOpen] = useState(false);
    const [languageOpen, setLanguageOpen] = useState(false);
    const [activeTab, setActiveTab] = useState(null);

    const handleMenuItemClick = (tabName) => {
        setActiveTab(tabName);
        if (tabName === 'Promotions') {
            setPromotionsOpen(!promotionsOpen);
        } else if (tabName === 'Sponsorships') {
            setSponsorshipsOpen(!sponsorshipsOpen);
        } else if (tabName === 'Language') {
            setLanguageOpen(!languageOpen);
        }
    };

    return (
        <MainWrapper>
            <SidebarContainer>
                <MenuItemWrapper active={activeTab === 'Promotions'} onClick={() => handleMenuItemClick('Promotions')}>
                    <Gift size={20} />
                    <MenuItemText>Promotions</MenuItemText>
                    <ExpandIconWrapper open={promotionsOpen} >
                        <ExpandIcon size={15} />
                    </ExpandIconWrapper>
                </MenuItemWrapper>
                {promotionsOpen && (
                    <SubMenu>
                        <MenuItemWrapper>
                            <MenuItemText>$75k Weekly Raffle</MenuItemText>
                        </MenuItemWrapper>
                        <MenuItemWrapper>
                            <MenuItemText>$100k Race - 24 Hours</MenuItemText>
                        </MenuItemWrapper>
                        <MenuItemWrapper>
                            <MenuItemText>Pragmatic Drops & Wins</MenuItemText>
                        </MenuItemWrapper>
                        <MenuItemWrapper>
                            <MenuItemText>View All</MenuItemText>
                        </MenuItemWrapper>
                    </SubMenu>
                )}
                <MenuItemWrapper active={activeTab === 'Affiliate'} onClick={() => handleMenuItemClick('Affiliate')}>
                    <Users size={20} />
                    <MenuItemText>Affiliate</MenuItemText>
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'VIP Club'} onClick={() => handleMenuItemClick('VIP Club')}>
                    <Trophy size={20} />
                    <MenuItemText>VIP Club</MenuItemText>
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'Blog'} onClick={() => handleMenuItemClick('Blog')}>
                    <Newspaper size={20} />
                    <MenuItemText>Blog</MenuItemText>
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'Forum'} onClick={() => handleMenuItemClick('Forum')}>
                    <MessageSquare size={20} />
                    <MenuItemText>Forum</MenuItemText>
                </MenuItemWrapper>
            </SidebarContainer>
            <SidebarContainer>
                <MenuItemWrapper active={activeTab === 'Sponsorships'} onClick={() => handleMenuItemClick('Sponsorships')}>
                    <Handshake size={20} />
                    <MenuItemText>Sponsorships</MenuItemText>
                    <ExpandIconWrapper open={sponsorshipsOpen} >
                        <ExpandIcon  size={20} />
                    </ExpandIconWrapper>
                   
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'Responsible Gambling'} onClick={() => handleMenuItemClick('Responsible Gambling')}>
                    <Shield size={20} />
                    <MenuItemText>Responsible Gambling</MenuItemText>
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'Live Support'} onClick={() => handleMenuItemClick('Live Support')}>
                    <Headphones size={20} />
                    <MenuItemText>Live Support</MenuItemText>
                </MenuItemWrapper>
                <MenuItemWrapper active={activeTab === 'Language'} onClick={() => handleMenuItemClick('Language')}>
                    <Globe size={20} />
                    <MenuItemText>Language: English</MenuItemText>
                    <ExpandIconWrapper open={languageOpen} >
                    <ExpandIcon size={20} />
                    </ExpandIconWrapper>
      
                </MenuItemWrapper>
            </SidebarContainer>
        </MainWrapper>
    );
};

export default AccordionMenu;
