import React, { useState, useEffect, useLayoutEffect } from 'react';


import styled, { keyframes } from 'styled-components';
import SportsBanner from './sportbanner';
import SportsBannerMain from './sportMain';



// Loader animation
const spin = keyframes`
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
`;


const Sports = () => {

  const [isMobile, setIsMobile] = useState(false);

  

  useEffect(() => {
    const checkScreenSize = () => {
      setIsMobile(window.innerWidth <= 768);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => {
      window.removeEventListener('resize', checkScreenSize);
    };
  }, []);




  
  
  

  return (
    <>
     
     {(isMobile ? <SportsBanner/> : <SportsBannerMain/>)}
    </>
  );
};

export default Sports;