import React, { Component } from 'react';
import { Modal, Box } from '@mui/material';
import styled from 'styled-components';

const ModalWrapper = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.5);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 9999;
`;

const ModalContent = styled.div`
  width: 450px;
 box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
  background-color: #17181b;
  border-radius: 12px;
  padding: 24px;
 
  position: relative;
`;

const ModalTitle = styled.div`
  font-size: 20px;
  font-weight: 700;
  color: #ffffff;
  margin-bottom: 20px;
`;

const ModalBody = styled.div`
  display: flex;
  flex-direction: column;
  gap: 16px;
`;

const TextField = styled.input`
   width: 100%;
  padding: 12px 16px;
  background-color: #02030E;
  border: 1px solid #ffffff15;
  border-radius: 8px;
  color: #ffffff;
  font-size: 14px;
  transition: border 0.3s ease;
  
  &::placeholder {
    color: rgba(255, 255, 255, 0.5);
  }

  &:focus {
    outline: none;
    border-color: #f09c06;
  }

  &:hover {
    background-color: rgba(255, 255, 255, 0.15);
  }
`;

const InputLabel = styled.label`
  color: #ffffff;
  font-size: 14px;
  margin-bottom: 2px;
  display: block;
`;

const InputField = styled.div`
  display: flex;
  flex-direction: column;
  gap: 8px;
  width: 100%;
`;

const ModalFooter = styled.div`
  display: flex;
  justify-content: flex-end;
  gap: 12px;
  margin-top: 20px;
`;

const Button = styled.button`
  background: ${(props) => (props.disabled ? '#f09c0680' : '#f09c06')};
  color: #000;
  border: none;
  border-radius: 12px;
  font-size: 14px;
  font-weight: 700;
  padding: 12px 24px;
  cursor: ${(props) => (props.disabled ? 'not-allowed' : 'pointer')};
  transition: background 0.3s ease;

  // &:hover {
  //   background: ${(props) => (props.disabled ? '#f09c0680' : '#4AE54A')};
  // }
`;

const CancelButton = styled(Button)`
  background: #ffffff15;
  color: #ffffff;

  &:hover {
    background: #ffffff30;
  }
`;

const CloseButton = styled.button`
  position: absolute;
  top: 16px;
  right: 16px;
  background: transparent;
  border: none;
  font-size: 1.5rem;
  cursor: pointer;
  color: #ffffff;
  transition: color 0.3s ease;

  &:hover {
    color: #ff0000;
  }
`;

const InputWrapper = styled.div`
  position: relative;
  width: 100%;
`;

const EyeIcon = styled.button`
  position: absolute;
  right: 16px;
  top: 50%;
  transform: translateY(-50%);
  background: transparent;
  border: none;
  cursor: pointer;
  padding: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  color: #ffffff80;
  
  &:hover {
    color: #ffffff;
  }

  svg {
    width: 20px;
    height: 20px;
  }
`;

const EyeOpenIcon = () => (
  <svg viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
  </svg>
);

const EyeClosedIcon = () => (
  <svg viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"/>
  </svg>
);

class ChangePasswordModal extends Component {
  state = {
    showPassword: false,
    showNewPassword: false,
    showConfirmPassword: false
  };

  componentDidMount() {
    // Clear password fields when modal opens
    if (this.props.open) {
      this.clearPasswordFields();
    }
  }

  componentDidUpdate(prevProps) {
    // Clear password fields when modal opens
    if (this.props.open && !prevProps.open) {
      this.clearPasswordFields();
      // Force focus on first field to prevent autofill
      setTimeout(() => {
        const firstInput = document.querySelector('input[name="current-password-field"]');
        if (firstInput) {
          firstInput.focus();
          firstInput.blur();
        }
      }, 50);
    }
  }

  clearPasswordFields = () => {
    // Clear password fields by calling handleInputChange with empty values
    this.props.handleInputChange({ target: { name: 'password', value: '' } });
    this.props.handleInputChange({ target: { name: 'newPassword', value: '' } });
    this.props.handleInputChange({ target: { name: 'confirmPassword', value: '' } });
    
    // Force clear after a short delay to handle autofill
    setTimeout(() => {
      this.props.handleInputChange({ target: { name: 'password', value: '' } });
      this.props.handleInputChange({ target: { name: 'newPassword', value: '' } });
      this.props.handleInputChange({ target: { name: 'confirmPassword', value: '' } });
    }, 100);
  };

  togglePasswordVisibility = (field) => {
    this.setState(prevState => ({
      [field]: !prevState[field]
    }));
  };

  render() {
    const { 
      open, 
      onClose, 
      password, 
      newPassword, 
      confirmPassword, 
      handleInputChange, 
      changePassword, 
      disabled ,
      oldPassword,
    } = this.props;

    console.log(password, newPassword, confirmPassword);

    const {
      showPassword,
      showNewPassword,
      showConfirmPassword
    } = this.state;

    if (!open) return null;

    return (
      <ModalWrapper>
        <ModalContent>
          <CloseButton onClick={onClose}>×</CloseButton>
          <ModalTitle>Change Password</ModalTitle>
          <ModalBody>
            {/* Hidden inputs to prevent autofill */}
            <input type="text" style={{ display: 'none' }} autoComplete="username" />
            <input type="password" style={{ display: 'none' }} autoComplete="current-password" />
            <input type="email" style={{ display: 'none' }} autoComplete="email" />
            <input type="text" style={{ display: 'none' }} autoComplete="name" />
            <InputField>
              <InputLabel>Current Password</InputLabel>
              <InputWrapper>
                <TextField
                  type={showPassword ? "text" : "password"}
                  name="password"
                  placeholder="Enter your current password"
                  value={password}
                  onChange={handleInputChange}
                  autoComplete="current-password"
                  autoFill="off"
                />
                <EyeIcon
                  type="button"
                  onClick={() => this.togglePasswordVisibility('showPassword')}
                >
                  {showPassword ? <EyeClosedIcon /> : <EyeOpenIcon />}
                </EyeIcon>
              </InputWrapper>
            </InputField>

            <InputField>
              <InputLabel>New Password</InputLabel>
              <InputWrapper>
                <TextField
                  type={showNewPassword ? "text" : "password"}
                  name="newPassword"
                  placeholder="Enter your new password"
                  value={newPassword}
                  onChange={handleInputChange}
                  autoComplete="new-password"
                  autoFill="off"
                />
                <EyeIcon
                  type="button"
                  onClick={() => this.togglePasswordVisibility('showNewPassword')}
                >
                  {showNewPassword ? <EyeClosedIcon /> : <EyeOpenIcon />}
                </EyeIcon>
              </InputWrapper>
            </InputField>

            <InputField>
              <InputLabel>Confirm New Password</InputLabel>
              <InputWrapper>
                <TextField
                  type={showConfirmPassword ? "text" : "password"}
                  name="confirmPassword"
                  placeholder="Confirm your new password"
                  value={confirmPassword}
                  onChange={handleInputChange}
                  autoComplete="new-password"
                  autoFill="off"
                />
                <EyeIcon
                  type="button"
                  onClick={() => this.togglePasswordVisibility('showConfirmPassword')}
                >
                  {showConfirmPassword ? <EyeClosedIcon /> : <EyeOpenIcon />}
                </EyeIcon>
              </InputWrapper>
            </InputField>
          </ModalBody>
          <ModalFooter>
            <CancelButton
              type="button"
              onClick={onClose}
            >
              Cancel
            </CancelButton>
            <Button
              type="button"
              onClick={changePassword}
              disabled={disabled}
            >
              {disabled ? 'Changing...' : 'Change Password'}
            </Button>
          </ModalFooter>
        </ModalContent>
      </ModalWrapper>
    );
  }
}

export default ChangePasswordModal;