import React from 'react'
import { Row, Col } from "react-bootstrap";
import GameModal from "../../Components/Game/Stat/Modal";
import { __, isMobile, wait, Event } from "../../../Helper";
import C from "../../../Constant";

class History extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            gameRow: [],
            show: false
        };
        this.handleShow = this.handleShow.bind(this);
        this.handleClose = this.handleClose.bind(this);
    }

    handleShow() {
        this.setState({ show: true, effect: 'zoomIn' });
    }

    handleClose() {
        this.setState({ show: false, effect: 'zoomOut' });
    }

    render() {
        return <Parent tab={true} engine={this.props.engine} clicked={this.handleClose} />;
    }
}

class Parent extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            players: [],
            game_id: '',
            numbers: '',
            hash: '',
            md5: ''
        };
    }

    onChange(event, players, hash, md5, game_id, numbers) {
        this.setState({
            md5: md5,
            hash: hash,
            numbers: numbers,
            game_id: game_id,
            players: players,
            color: (numbers >= 1.9 ? 'success' : 'danger')
        });
    }

    render() {
        const { players, hash, md5, game_id, busted } = this.state;
        return <Child tab={this.props.tab} engine={this.props.engine} clicked={this.props.clicked.bind(this)} onChange={this.onChange.bind(this, players, hash, md5, game_id, busted)} />
    }
}

class Child extends React.Component {
    _isMounted = false;
    constructor(props) {
        super(props);
        this.state = {
            loading: false,
            padding: 'p-3',
            historyRow: [],
            players: [],
            posts: [],
            postsLength: 0,
            current_page: 1,
            page: 1,
            perPage: 10,
            ndisabled: false,
            pdisabled: false
        };

        this.prevRef = React.createRef();
        this.nextRef = React.createRef();
    }

    componentDidMount() {
        this._isMounted = true;
        let { engine } = this.props;
        engine.getHistory();
        engine.on(C.HISTORY_CRASH, (data) => this.gameSync(data));

        if (isMobile()) {
            this.setState({ padding: 'p-1' })
        }
    }

    componentWillUnmount() {
        this._isMounted = false;
    }

    gameSync(list) {
        if (this._isMounted) {

            wait(1000).then(() => {
                this.setState({ loading: false });
            })
console.log(("ereeee", this.props.engine.history))
            let data = this.props.engine.history;
            data = __.xor(data);

            this.setState({ posts: data });
            this.setState({ postsLength: data.length });

            this.changePage(1);
        }
    }

    numPages = () => {
        return Math.ceil(this.state.postsLength / this.state.perPage);
    }

    prevPage = (e) => {
        e.preventDefault();
        var current_page = this.state.current_page;
        if (current_page > 1) {
            let p = current_page - 1;
            this.setState({ current_page: p })
            this.changePage(p);
        }
    }

    nextPage = (e) => {
        e.preventDefault();
        var current_page = this.state.current_page;
        if (current_page < this.numPages()) {
            let p = current_page + 1;
            this.setState({ current_page: p })
            this.changePage(p);
        }
    }

    changePage = (page) => {
        // Validate page
        if (page < 1) page = 1;
        if (page > this.numPages()) page = this.numPages();

        this.setState({ historyRow: [] });

        for (var i = (page - 1) * this.state.perPage; i < (page * this.state.perPage); i++) {
            let array = this.state.posts[i];
            if (!__.isUndefined(array)) {
                let row = <Block key={__.toString(array.gid)} tab={true} clicked={this.props.clicked} array={array} />;
                this.setState(state => ({ historyRow: [row, ...state.historyRow] }));
            }
        }

        this.setState({ page: page })

        if (page == 1) {
            this.setState({ pdisabled: true });
        } else {
            this.setState({ pdisabled: false });
        }

        if (page == this.numPages()) {
            this.setState({ ndisabled: true });
        } else {
            this.setState({ ndisabled: false });
        }
    }

    render() {

        console.log("history toew", this.state.historyRow);
        console.log("posts",this.state.posts)
        console.log("posts",this.state.postsLength)
        return (
            <>
                {this.state.loading ?
                    <div className="text-center">
                        <div className="spinner-grow text-white my-3" role="status" />
                    </div>
                    :
                    <>
                        <Row className="px-2 pt-2 mt-4">
                            <Col xs="2" className="text-">Game ID</Col>
                            <Col xs="" className="text-">Result</Col>
                            <Col xs="6" className="text-center">Hash</Col>
                        </Row>
                        <div className={this.state.padding + ' history-tab-list'}>
                            {this.state.historyRow}
                            <ul className="pagination oncenter">
                                <li className="page-item">
                                    <button className="btn bg-cs2 mr-1 btn-xs" role="button" disabled={this.state.pdisabled} onClick={this.prevPage}>Prev</button>
                                </li>
                                <li className="page-item">
                                    <button className="btn bg-cs2 btn-xs" role="button" disabled={this.state.ndisabled} onClick={this.nextPage}>Next</button>
                                </li>
                            </ul>
                            <span className="font-12">
                                Page: <span>{this.state.page}</span>
                            </span>
                        </div>
                    </>
                }
            </>
        );
    }
}

class Block extends React.Component {
    verifyHash(hash) {
        Event.emit('game_verify', hash)
    }
    render() {
        let { clicked, tab } = this.props;
        let { gid, busted, hash } = this.props.array;

        busted = __.toNumber(busted).toFixed(2);

        let color = (busted >= 1.9 ? 'success' : 'danger');

        return (
            <Row className="mt-1 pt-0">
                <Col xs="3" className="mt-2 text-left">
                    <GameModal clicked={clicked} game_id={gid} title={(gid)} color={color} />
                </Col>
                <Col xs="3" className="mt-2 text-left">
                    <GameModal clicked={clicked} game_id={gid} title={(busted + 'x')} color={color} />
                </Col>
                <Col xs="6" className="mt-1 cpt" onClick={() => { this.verifyHash(hash) }}>
                    <input
                        type="text"
                        className={"form-control font-10 text-center h-100 no-radius cpt"}
                        value={hash.substr(0, 60) + '...'}
                        readOnly={true}
                    />
                </Col>
            </Row>
        );
    }
}

export default History;







// import React from 'react'
// import { Row, Col } from "react-bootstrap";
// import GameModal from "../../Components/Game/Stat/Modal";
// import { __, isMobile, wait, Event } from "../../../Helper";
// import C from "../../../Constant";

// class History extends React.Component {
//     constructor(props) {
//         super(props);
//         this.state = {
//             gameRow: [],
//             show: false
//         };
//         this.handleShow = this.handleShow.bind(this);
//         this.handleClose = this.handleClose.bind(this);
//     }

//     handleShow() {
//         this.setState({ show: true, effect: 'zoomIn' });
//     }

//     handleClose() {
//         this.setState({ show: false, effect: 'zoomOut' });
//     }

//     render() {
//         return <Parent tab={true} engine={this.props.engine} clicked={this.handleClose} />;
//     }
// }

// class Parent extends React.Component {
//     constructor(props) {
//         super(props);
//         this.state = {
//             players: [],
//             game_id: '',
//             numbers: '',
//             hash: '',
//             md5: ''
//         };
//     }

//     onChange(event, players, hash, md5, game_id, numbers) {
//         this.setState({
//             md5: md5,
//             hash: hash,
//             numbers: numbers,
//             game_id: game_id,
//             players: players,
//             color: (numbers >= 1.9 ? 'success' : 'danger')
//         });
//     }

//     render() {
//         const { players, hash, md5, game_id, busted } = this.state;
//         return <Child tab={this.props.tab} engine={this.props.engine} clicked={this.props.clicked.bind(this)} onChange={this.onChange.bind(this, players, hash, md5, game_id, busted)} />
//     }
// }

// class Child extends React.Component {
//     _isMounted = false;
//     constructor(props) {
//         super(props);
//         this.state = {
//             loading: false,
//             padding: 'p-3',
//             historyRow: [],
//             players: [],
//             posts: [],
//             postsLength: 0,
//             current_page: 1,
//             page: 1,
//             perPage: 10,
//             ndisabled: false,
//             pdisabled: false
//         };

//         this.prevRef = React.createRef();
//         this.nextRef = React.createRef();
//     }

//     componentDidMount() {
 
//         this._isMounted = true;
//         let { engine } = this.props;

//         console.log("enginee data", engine.history)
//         engine.getHistory();
//         engine.on(C.HISTORY_CRASH, (data) => this.gameSync(data));

//         if (isMobile()) {
//             this.setState({ padding: 'p-1' })
//         }
//     }

//     componentWillUnmount() {
//         this._isMounted = false;
//     }

//     gameSync(list) {
//         if (this._isMounted) {
//             wait(1000).then(() => {
//                 this.setState({ loading: false });
//             });

//             let data = this.props.engine.history;
//             data = __.xor(data);

//             this.setState({ posts: data, postsLength: data.length }, () => {
//                 this.changePage(1);
//             });
//         }
//     }

//     numPages = () => {
//         return Math.ceil(this.state.postsLength / this.state.perPage);
//     }

//     prevPage = (e) => {
//         e.preventDefault();
//         var current_page = this.state.current_page;
//         if (current_page > 1) {
//             let p = current_page - 1;
//             this.setState({ current_page: p })
//             this.changePage(p);
//         }
//     }

//     nextPage = (e) => {
//         e.preventDefault();
//         var current_page = this.state.current_page;
//         if (current_page < this.numPages()) {
//             let p = current_page + 1;
//             this.setState({ current_page: p })
//             this.changePage(p);
//         }
//     }

//     changePage = (page) => {
//         // Validate page
//         if (page < 1) page = 1;
//         if (page > this.numPages()) page = this.numPages();

//         this.setState({ historyRow: [] }, () => {
//             for (let i = (page - 1) * this.state.perPage; i < (page * this.state.perPage); i++) {
//                 let array = this.state.posts[i];
//                 if (!__.isUndefined(array)) {
//                     let row = <Block key={__.toString(array.gid)} tab={true} clicked={this.props.clicked} array={array} />;
//                     this.setState(state => ({ historyRow: [...state.historyRow, row] }));
//                 }
//             }

//             this.setState({ page: page });

//             if (page === 1) {
//                 this.setState({ pdisabled: true });
//             } else {
//                 this.setState({ pdisabled: false });
//             }

//             if (page === this.numPages()) {
//                 this.setState({ ndisabled: true });
//             } else {
//                 this.setState({ ndisabled: false });
//             }
//         });
//     }

//     render() {
//         console.log("history row", this.state.historyRow);
//         console.log("posts", this.state.posts);
//         console.log("posts length", this.state.postsLength);

//         return (
//             <>
//                 {this.state.loading ?
//                     <div className="text-center">
//                         <div className="spinner-grow text-white my-3" role="status" />
//                     </div>
//                     :
//                     <>
//                         <Row className="px-2 pt-2 mt-4">
//                             <Col xs="3" className="text-">Game ID</Col>
//                             <Col xs="3" className="text-">Result</Col>
//                             <Col xs="4" className="text-center">Hash</Col>
//                         </Row>
//                         <div className={this.state.padding + ' history-tab-list'}>
//                             {this.state.historyRow}
//                             <ul className="pagination oncenter">
//                                 <li className="page-item">
//                                     <button className="btn bg-cs2 mr-1 btn-xs" role="button" disabled={this.state.pdisabled} onClick={this.prevPage}>Prev</button>
//                                 </li>
//                                 <li className="page-item">
//                                     <button className="btn bg-cs2 btn-xs" role="button" disabled={this.state.ndisabled} onClick={this.nextPage}>Next</button>
//                                 </li>
//                             </ul>
//                             <span className="font-12">
//                                 Page: <span>{this.state.page}</span>
//                             </span>
//                         </div>
//                     </>
//                 }
//             </>
//         );
//     }
// }

// class Block extends React.Component {
//     verifyHash(hash) {
//         Event.emit('game_verify', hash)
//     }
//     render() {
//         let { clicked, tab } = this.props;
//         let { gid, busted, hash } = this.props.array;

//         busted = __.toNumber(busted).toFixed(2);

//         let color = (busted >= 1.9 ? 'success' : 'danger');

//         return (
//             <Row className="mt-1 pt-0">
//                 <Col xs="3" className="mt-2 text-left">
//                     <GameModal clicked={clicked} game_id={gid} title={(gid)} color={color} />
//                 </Col>
//                 <Col xs="3" className="mt-2 text-left">
//                     <GameModal clicked={clicked} game_id={gid} title={(busted + 'x')} color={color} />
//                 </Col>
//                 <Col xs="4" className="mt-1 cpt" onClick={() => { this.verifyHash(hash) }}>
//                     <input
//                         type="text"
//                         className={"form-control font-10 text-center h-100 no-radius cpt"}
//                         value={hash.substr(0, 60) + '...'}
//                         readOnly={true}
//                     />
//                 </Col>
//             </Row>
//         );
//     }
// }

// export default History;






// import React, { useState, useEffect } from 'react';
// import styled from 'styled-components';
// import { Event } from '../../../Helper';
// import { isMobile } from '../../../Helper';
// import C from '../../../Constant';

// const HistoryContainer = styled.div`
//   padding: ${props => props.isMobileView ? '0.5rem' : '1rem'};
//   background-color: #1E2024;
//   border-radius: 8px;
//   color: #fff;
//   overflow-x: auto;
//   width: 100%;
// `;

// const Table = styled.div`
//   min-width: 100%;
//   margin-top: 1rem;
//   @media (max-width: 768px) {
//     font-size: 0.875rem;
//   }
// `;

// const TableHeader = styled.div`
//   display: grid;
//   grid-template-columns: repeat(2, minmax(200px, 1fr));
//   padding: 1rem;
//   background-color: #23262B;
//   border-radius: 8px 8px 0 0;
//   font-weight: bold;
//   position: sticky;
//   top: 0;
  
//   @media (max-width: 768px) {
//     padding: 0.75rem;
//     grid-template-columns: repeat(2, minmax(180px, 1fr));
//   }
// `;

// const TableRow = styled.div`
//   display: grid;
//   grid-template-columns: repeat(2, minmax(200px, 1fr));
//   padding: 0.75rem 1rem;
//   border-bottom: 1px solid #333;
//   transition: background-color 0.2s;
//   align-items: center;
  
//   &:hover {
//     background-color: #23262B;
//   }
  
//   @media (max-width: 768px) {
//     padding: 0.5rem;
//     grid-template-columns: repeat(2, minmax(180px, 1fr));
//   }
// `;

// const Cell = styled.div`
//   overflow: hidden;
//   text-overflow: ellipsis;
//   white-space: nowrap;
//   padding: 0 0.5rem;
// `;

// const ResultCell = styled(Cell)`
//   color: ${props => (props.value < 2 ? '#ff4d4d' : '#4caf50')};
// `;

// const PaginationContainer = styled.div`
//   display: flex;
//   justify-content: center;
//   align-items: center;
//   gap: 1rem;
//   margin-top: 1rem;
//   flex-wrap: wrap;
//   padding: 0.5rem;
// `;

// const Button = styled.button`
//   padding: ${props => props.isMobileView ? '0.375rem 0.75rem' : '0.5rem 1rem'};
//   background-color: ${props => props.disabled ? '#444' : '#23262B'};
//   color: white;
//   border: none;
//   border-radius: 4px;
//   cursor: ${props => props.disabled ? 'not-allowed' : 'pointer'};
//   font-size: ${props => props.isMobileView ? '0.875rem' : '1rem'};
  
//   &:hover:not(:disabled) {
//     background-color: #2c2f35;
//   }
// `;

// const PageInfo = styled.span`
//   color: #888;
//   font-size: ${props => props.isMobileView ? '0.75rem' : '0.875rem'};
// `;

// const LoadingSpinner = styled.div`
//   display: flex;
//   justify-content: center;
//   align-items: center;
//   min-height: 200px;
// `;

// const History = ({ engine }) => {
//   const [historyData, setHistoryData] = useState([]);
//   const [currentPage, setCurrentPage] = useState(1);
//   const [loading, setLoading] = useState(true);
//   const [isMobileView, setIsMobileView] = useState(isMobile());
//   const itemsPerPage = isMobileView ? 5 : 8;

//   useEffect(() => {
//     const handleResize = () => {
//       setIsMobileView(isMobile());
//     };

//     window.addEventListener('resize', handleResize);
//     return () => window.removeEventListener('resize', handleResize);
//   }, []);

//   useEffect(() => {
//     let mounted = true;

//     const handleGameSync = (data) => {
//       if (mounted) {
//         setTimeout(() => {
//           setLoading(false);
//         }, 1000);

//         if (engine.history) {
//           setHistoryData(engine.history);
//         }
//       }
//     };

//     if (engine.history) {
//       setHistoryData(engine.history);
//       setLoading(false);
//     }

//     engine.getHistory();
//     engine.on(C.HISTORY_CRASH, handleGameSync);

//     return () => {
//       mounted = false;
//       engine.off(C.HISTORY_CRASH, handleGameSync);
//     };
//   }, [engine]);

//   const calculateResult = (amount) => {
//     return (amount / 100).toFixed(2);
//   };

//   const totalPages = Math.ceil(historyData.length / itemsPerPage);
//   const startIndex = (currentPage - 1) * itemsPerPage;
//   const endIndex = startIndex + itemsPerPage;
//   const currentItems = historyData.slice(startIndex, endIndex);

//   const handlePrevPage = () => {
//     setCurrentPage(prev => Math.max(prev - 1, 1));
//   };

//   const handleNextPage = () => {
//     setCurrentPage(prev => Math.min(prev + 1, totalPages));
//   };

//   if (loading) {
//     return (
//       <HistoryContainer isMobileView={isMobileView}>
//         <LoadingSpinner>
//           <div className="spinner-border text-primary" role="status">
//             <span className="visually-hidden">Loading...</span>
//           </div>
//         </LoadingSpinner>
//       </HistoryContainer>
//     );
//   }

//   return (
//     <HistoryContainer isMobileView={isMobileView}>
//       <Table>
//         <TableHeader>
//           <Cell>Game ID</Cell>
//           <Cell>Result</Cell>
//         </TableHeader>
        
//         {currentItems.map((item) => {
//           const result = calculateResult(item.amount);
//           return (
//             <TableRow key={item.game_id}>
//               <Cell>{item.game_id}</Cell>
//               <ResultCell value={parseFloat(result)}>{result}x</ResultCell>
//             </TableRow>
//           );
//         })}
//       </Table>

//       <PaginationContainer>
//         <Button 
//           isMobileView={isMobileView}
//           onClick={handlePrevPage} 
//           disabled={currentPage === 1}
//         >
//           Previous
//         </Button>
        
//         <PageInfo isMobileView={isMobileView}>
//           Page {currentPage} of {totalPages}
//         </PageInfo>
        
//         <Button 
//           isMobileView={isMobileView}
//           onClick={handleNextPage} 
//           disabled={currentPage === totalPages}
//         >
//           Next
//         </Button>
//       </PaginationContainer>
//     </HistoryContainer>
//   );
// };

// export default History;