import React from 'react';
import C from "../../../Constant";
import Canvas from "./Canvas";
import { __ } from "../../../Helper";

class Game extends React.Component {
    _isMounted = false;
    constructor(props) {
        super(props);
        this.state = {
            engine: this.props.engine,
            canvas: null,
            interval: []
        }
    }

    componentDidMount() {
        this._isMounted = true;
        let { engine } = this.state;

        engine.on(C.PLAY_DIAMOND, (data) => this.play(data));

        var canvas = new Canvas();
        this.setState({ canvas: canvas })
        canvas.init();

        let c = document.getElementById('game');
        c.style.width = '100%'
        c.style.height = '100%'
    }

    componentWillUnmount() {
        this._isMounted = false;

        if (this.state.canvas !== null)
            this.state.canvas.destroy();
    }

    play(data) {
        if (this._isMounted) {
            this.state.canvas.setStart();
            this.state.canvas.start(data.target);
        }
    }

    render() {
        return <>
            <div className="text-center animated fadeIn">
                <div id="loading" className="ycenter" />
                <canvas id="game" />
            </div>
        </>;
    }
}

export default Game;
