import MyEmitter from "events";
import storage from "../../../Storage";
import socket from "../../../Socket";
import C from "../../../Constant";
import {Event, encode, decode, forceSatoshiFormat} from "../../../Helper";

/**
 * Game Engine
 */
function Engine(){

    var self = this;

    /**
     * Game Name
     */
    self.game = 'SNAKEANDLADDERS';

    /**
     * Socket Connection
     */
    self.ws = socket;

    /**
     * Itialize Game
     */
    self.trigger = new MyEmitter();

    /**
     * Itialize Game
     */
    self.init = false;

    /**
     * Round Amount
     */
    self.amount = null;

    /**
     * Round Profit
     */
    self.profit = null;

    /**
     * Player Coin
     */
    self.coin = null;

    /**
     * Selected Land
     */
    self.land = null;

    /**
     * Current Land
     */
    self.currentLand = 89;

    /**
     * Player lost or win
     */
    self.lost = false;

    /*
     * Start Engine
    */
    self.started = true;

    if(self.started)
    {
        self.ws.on(C.PLAY_SNAKEANDLADDERS, (data) => {
            console.log('SnakeAndLadders Engine: Received data from server:', data);
            data = decode(data);
            console.log('SnakeAndLadders Engine: Decoded data:', data);

            switch(data.command)
            {
                case 'play':
                    console.log('SnakeAndLadders Engine: Emitting PLAY_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.PLAY_SNAKEANDLADDERS, data);
                case 'next':
                    console.log('SnakeAndLadders Engine: Emitting NEXT_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.NEXT_SNAKEANDLADDERS, data);
                case 'busted':
                    console.log('SnakeAndLadders Engine: Emitting BUSTED_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.BUSTED_SNAKEANDLADDERS, data);
                case 'clicked':
                    console.log('SnakeAndLadders Engine: Emitting CLICKED_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.CLICKED_SNAKEANDLADDERS, data);
                case 'cashout':
                    console.log('SnakeAndLadders Engine: Emitting CASHOUT_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.CASHOUT_SNAKEANDLADDERS, data);
                case 'error':
                    console.log('SnakeAndLadders Engine: Emitting ERROR_SNAKEANDLADDERS event');
                    return self.trigger.emit(C.ERORR_SNAKEANDLADDERS, data);
            }
        });
    }
}

Engine.prototype.off = function (){
    let self = this;
    self.ws.off(C.PLAY_SNAKEANDLADDERS);
}

Engine.prototype.on = function (name, callback){
    let self = this;
    if(!self.started) return;
    if(self.trigger === null) return;
        return self.trigger.on(name, (data) => callback(data));
}

Engine.prototype.emit = function (name, data = []){
    let self = this;
    if(!self.started) return;
    if(self.trigger === null) return;
        return self.trigger.emit(name, data);
}

/**
 * Start Game
 */
Engine.prototype.start = function () {
    let self = this;

    console.log('SnakeAndLadders Engine: start() called, init:', self.init, 'amount:', self.amount, 'coin:', self.coin);

    if(!self.init)
        return;

    if(self.amount < 0.00000010){
        self.amount = forceSatoshiFormat(0.00000010)
    }
    
    const payload = {
        command: 'play',
        amount: self.amount,
        coin: self.coin
    };
    
    console.log('SnakeAndLadders Engine: Sending play command to server:', payload);
    self.ws.emit(C.PLAY_SNAKEANDLADDERS, encode(payload));
};

/**
 * Clicked On the Land
 */
Engine.prototype.clicked = function () {
    let self = this;
    const payload = {
        command: 'clicked',
        land: self.land,
        lost: self.lost
    };
    console.log('SnakeAndLadders Engine: Sending clicked command to server:', payload);
    self.ws.emit(C.PLAY_SNAKEANDLADDERS, encode(payload));
};

/**
 * Next roll
 */
Engine.prototype.next = function () {
    let self = this;
    const payload = {
        command: 'next',
        currentLand: self.currentLand,
        profit: self.profit
    };
    console.log('SnakeAndLadders Engine: Sending next command to server:', payload);
    self.ws.emit(C.PLAY_SNAKEANDLADDERS, encode(payload));
};

/**
 * CashOut
 */
Engine.prototype.cashout = function () {
    let self = this;
    const payload = {
        command: 'cashout',
        profit: self.profit
    };
    console.log('SnakeAndLadders Engine: Sending cashout command to server:', payload);
    self.ws.emit(C.PLAY_SNAKEANDLADDERS, encode(payload));
};

/** Start Game Engine **/
export default Engine
