import * as PIXI from "pixi.js";
import { wait } from "../Helper/index.js";

function Dice(obj) {
    this.game = obj
    this.started = false;
	this.result = null
    this.texture = PIXI.Texture.from('/assets/images/snake/1.png');
    this.sprite = PIXI.Sprite.from(this.texture);
}

Dice.prototype.Roll = function(result) {
    console.log('SnakeAndLadders Dice: Roll called with result:', result);
    if(this.started) {
        console.log('SnakeAndLadders Dice: Already rolling, returning');
        return;
    }
    this.started = true;
	
	this.result = result
    console.log('SnakeAndLadders Dice: Starting dice animation, final result will be:', result);

    let ticker = new PIXI.Ticker();

	let done = false;
    ticker.add((delta) => {
        let rand = Math.floor(Math.random() * (6 - 1 + 1)) + 1;
        this.texture = PIXI.Texture.from(`/assets/images/snake/${rand}.png`);
		this.sprite.texture = this.texture;
		
        wait(2000).then(() => {
			if(!done){
				console.log('SnakeAndLadders Dice: Animation complete, showing final result:', result);
				this.texture = PIXI.Texture.from(`/assets/images/snake/${result}.png`);
				this.sprite.texture = this.texture;
				done = true;
				this.started = false;
				console.log('SnakeAndLadders Dice: Emitting start event');
				this.game.event.emit('start')
				ticker.stop();
			}
        })
    })

    ticker.start();

}

export default Dice;
