import React, { Component } from 'react';
import io from 'socket.io-client';

const namespaces = ['30s', '1m', '2m'];
const socket = io('https://api.boss707.com'); // Replace with your server URL

class BettingComponent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      timers: { '30s': 0, '1m': 0, '2m': 0 },
      results: { '30s': {}, '1m': {}, '2m': {} },
      currentNamespace: '30s',
      betData: { value: '', amount: '', cointype: 'usdt' },
      balance: 0, // State to store user's balance
      betOutcome: null, // State to store bet outcome
      sessionData: { '30s': [], '1m': [], '2m': [] }, // State to store session data
    };

    this.placeBet = this.placeBet.bind(this);
    this.handleInputChange = this.handleInputChange.bind(this);
    this.setCurrentNamespace = this.setCurrentNamespace.bind(this);
  }

  componentDidMount() {
    namespaces.forEach(namespace => {
      const nsp = io(`https://api.boss707.com/${namespace}`); // Replace with your server URL

      nsp.on('sessionTimer', data => {
        this.setState(prevState => ({
          timers: { ...prevState.timers, [namespace]: data.timeLeft }
        }));
      });

      nsp.on('winningNumber', data => {
        this.setState(prevState => ({
          results: { ...prevState.results, [namespace]: data }
        }));
        // Check if the betting period has ended
        if (data.timeLeft <= 0) {
          nsp.emit('getBetOutcome', this.state.currentNamespace);
        }
      });

      nsp.on('betOutcome', data => {
        this.setState(prevState => ({
          betOutcome: data,
          balance: prevState.balance + data.winAmount // Update user's balance
        }));
      });

      nsp.on('balanceUpdate', data => {
        this.setState({ balance: data.newBalance });
      });

      nsp.on('bettingClosed', () => {
        alert('Betting is closed for this session.');
      });

      nsp.on('sessionData', data => {
        this.setState(prevState => ({
          sessionData: { ...prevState.sessionData, [namespace]: data }
        }));
      });

      this.nsp = nsp;
    });
  }

  componentWillUnmount() {
    if (this.nsp) {
      this.nsp.disconnect();
    }
  }

  placeBet(e) {
    e.preventDefault();
    const { currentNamespace, betData } = this.state;
    socket.emit('placeBet', { ...betData, namespace: currentNamespace });
  }

  handleInputChange(e) {
    const { name, value } = e.target;
    this.setState(prevState => ({
      betData: { ...prevState.betData, [name]: value }
    }));
  }

  setCurrentNamespace(ns) {
    this.setState({ currentNamespace: ns });
  }

  render() {
    const { timers, results, currentNamespace, betData, balance, betOutcome, sessionData } = this.state;

    return (
      <div>
        <div>
          {namespaces.map(ns => (
            <button key={ns} onClick={() => this.setCurrentNamespace(ns)}>
              {ns} - Time Left: {timers[ns]}
            </button>
          ))}
        </div>
        <div>
          <h2>Current Namespace: {currentNamespace}</h2>
          <form onSubmit={this.placeBet}>
            <input
              type="text"
              placeholder="Value"
              name="value"
              value={betData.value}
              onChange={this.handleInputChange}
            />
            <input
              type="number"
              placeholder="Amount"
              name="amount"
              value={betData.amount}
              onChange={this.handleInputChange}
            />
            <button type="submit">Place Bet</button>
          </form>
        </div>
        <div>
          <h3>Results</h3>
          {namespaces.map(ns => (
            <div key={ns}>
              <h4>{ns} Results:</h4>
              <p>Number: {results[ns].number}</p>
              <p>Color: {results[ns].color}</p>
            </div>
          ))}
        </div>
        {betOutcome && (
          <div>
            <h3>Bet Outcome</h3>
            <p>{betOutcome.message}</p>
            <p>Win Amount: {betOutcome.winAmount}</p>
          </div>
        )}
        <div>
          <h3>Balance: {balance}</h3>
        </div>
        <div>
          <h3>Session Data</h3>
          {namespaces.map(ns => (
            <div key={ns}>
              <h4>{ns} Session Data:</h4>
              <table>
                <thead>
                  <tr>
                    <th>Session ID</th>
                    <th>Status</th>
                    <th>Bet Number</th>
                    <th>Bet Color</th>
                  </tr>
                </thead>
                <tbody>
                  {sessionData[ns].map(session => (
                    <tr key={session.sessionId}>
                      <td>{session.sessionId}</td>
                      <td>{session.status}</td>
                      <td>{session.betNumber}</td>
                      <td>{session.betColour}</td>
                    </tr>
                  ))}
                </tbody>
              </table>
            </div>
          ))}
        </div>
      </div>
    );
  }
}

export default BettingComponent;
