


import React, { Component } from 'react';
import { Modal } from 'react-bootstrap';
import styled from 'styled-components';
import socket from "../../../Socket";
import storage from "../../../Storage";
import { decode, encode, isEmail, Event, wait, sendNotfication } from "../../../Helper";
import { CountryDropdown, RegionDropdown } from 'react-country-region-selector';
import C from "../../../Constant";
import axios from 'axios';

const StyledModal = styled(Modal)`
  .modal-content {
    background: #03030F !important;
    color: white;
    border-radius: 12px;
    overflow: hidden;
    max-width: 800px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    z-index: 999;
    min-height: auto;
    
    @media (min-width: 768px) {
      flex-direction: row;
      max-height: 90vh;
    }
    
    @media (max-width: 768px) {
      min-height: auto;
      border-radius: 8px;
      height: auto;
      max-height: 95vh;
      overflow: auto;
      margin: 8px;
      display: block;
    }
  }
  
  .modal-dialog {
    max-width: 900px;
    margin: 0;
    min-height: auto;
    width: 100vw;
    z-index: 9999;
    
    @media (min-width: 768px) {
      margin: 1.75rem auto;
      height: auto;
      width: auto;
    }
    
    @media (max-width: 768px) {
      margin: 0;
      max-height: 100vh;
      height: auto;
      display: flex;
      align-items: center;
      justify-content: center;
    }
  }
  
  &.modal {
    z-index: 1060;
  }
  
  .modal-backdrop {
    background-color: rgba(30, 35, 40, 0.85) !important;
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
  }
  
  @media (max-width: 768px) {
    margin: 0;
    padding: 0;
    
    &.modal-dialog-centered {
      min-height: auto;
      align-items: center;
      height: auto;
      padding: 8px;
    }
  }
`;

const RightSection = styled.div`
  flex: 1;
  background-image: url('/assets/images/bcgames/signup/signup.png');
  background-size: cover;
  background-position: center;
  position: relative;
  background-repeat:no-repeat;
  min-height: 160px;
  display: flex;
  flex-direction: column;
  align-items:center;
  justify-content: space-between;
  padding: 30px;
  object-fit: cover;
  
  @media (min-width: 768px) {
    min-height: auto;
    background-position: center top;
    overflow: hidden;
    background-size: 100% auto;
  }
  
  @media (max-width: 768px) {
    order: 1;
    padding: 8px;
    height: 339px;
    min-height: auto;
    background-image: url('/assets/images/bcgames/signup/signup.png');
    background-position: top;
    justify-content: flex-end;
    flex: none;
    
    &::after {
      content: '';
      position: absolute;
      bottom: 0;
      left: 0;
      right: 0;
      height: 50%;
      background: linear-gradient(to bottom, rgba(35, 38, 38, 0), rgba(35, 38, 38, 1));
      pointer-events: none;
    }
  }
`;

const RightContent = styled.div`
  position: relative;
  z-index: 1;
  color: white;
`;

const LeftSection = styled(Modal.Body)`
  padding: 16px;
  flex: 1;
  position: relative;
  width: 100%;
  
  @media (max-width: 768px) {
    padding: 16px;
    order: 2;
    height: auto;
    overflow: visible;
    min-height: auto;
    max-height: none;
    flex: none;
  }
`;

const StayUntamed = styled.div`
  h2 {
    font-size: 28px;
    font-weight: bold;
    margin-bottom: 16px;
    color: white;
    text-align: center;
    
    @media (max-width: 768px) {
      font-size: 20px;
      margin-bottom: 8px;
      margin-top:-65px;
    }
  }

  p {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    text-align: center;
    
    @media (max-width: 768px) {
      font-size: 12px;
    }
  }

  @media (max-width: 768px) {
    display: none;
  }
`;

const CloseButton = styled.button`
  position: fixed;
  right: 40px;
  top: 47px;
  background: rgba(255, 255, 255, 0.1);
  border: none;
  color: white;
  font-size: 18px;
  width: 32px;
  height: 32px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  z-index: 10;
  
  @media (min-width: 768px) {
    position: absolute;
  }
  
  @media (max-width: 768px) {
    position: absolute;
    right: 16px;
    top: 16px;
    z-index: 20;
  }
  
  &:hover {
    background: rgba(255, 255, 255, 0.2);
  }
`;

const Title = styled.h2`
  font-size: 24px;
  color: white;
  margin-bottom: 16px;

  @media (max-width: 768px) {
    font-size: 18px;
    margin-bottom: 20px;
    margin-top: 0;
    padding-top: 0;
    margin-top:-65px;
  }
`;

const StyledForm = styled.form`
  display: flex;
  flex-direction: column;
  gap: 10px;

  @media (max-width: 768px) {
    gap: 6px;
  }
`;

const InputWrapper = styled.div`
  display: flex;
  flex-direction: column;
  gap: 4px;
`;

const StyledInput = styled.input`
   background: rgba(0, 0, 0, 0.35);

  border: 1px solid #272B30;
  border-radius: 12px;
  color: white;
  padding: 8px 12px;
  width: 100%;
  font-size: 12px;

  @media (max-width: 768px) {
    // padding: 10px 12px;
    font-size: 13px;
    border-radius: 8px;
  }

  &::placeholder {
    color: #fff;
  }

  &:focus {
    outline: none;
    border-color: #f09c06;
  }

  &::-webkit-outer-spin-button,
  &::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
  }

  &[type='number'] {
    -moz-appearance: textfield;
  }
`;

const Label = styled.div`
  color: #fff;
  font-size: 14px;
  font-weight: 500;
  
  @media (max-width: 768px) {
    font-size: 12px;
  }
`;

const CheckboxContainer = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  margin: 2px 0;
`;

const CheckboxInput = styled.input`
  width: 20px;
  height: 20px;
  cursor: pointer;
  
  @media (max-width: 768px) {
    width: 16px;
    height: 16px;
  }
`;

const CheckboxLabel = styled.label`
  color: #fff;
  font-size: 12px;
  
  @media (max-width: 768px) {
    font-size: 11px;
  }
`;

const SignUpButton = styled.div`
  background: #f09c06;
  border: none;
  border-radius: 12px;
  text-align:center;
  color: black !important;
  padding: 12px 16px;
  font-weight: 600;
  font-size: 15px;
  width: 100%;
  cursor: pointer;
  margin-top: 12px;

  @media (max-width: 768px) {
    padding: 10px 12px;
    font-size: 14px;
    margin-top:0px;
    border-radius: 8px;
  }

  &:hover {
    background-color:  #f09c06;
  }

  &:disabled {
    opacity: 0.7;
    cursor: not-allowed;
  }
`;

const SignUpButtonO = styled.div`
  font-size: 14px;
  // background: #f09c06
  background:#f09c06;
  border-radius: 10px;
  padding: 7px 14px;
  font-weight: bold;
  cursor: pointer;
  color: black !important;
  white-space: nowrap;

  @media (max-width: 768px) {
    width: 100%;
    text-align: center;
    font-size: 13px;
    padding: 6px 12px;
    border-radius: 8px;
  }
`;

const SignInText = styled.div`
  text-align: center;
  margin-top: 24px;
  color: #fff;
  font-size: 14px;

  @media (max-width: 768px) {
    margin-top: 16px;
    font-size: 12px;
  }
`;

const SignInLink = styled.span`
  color: #f09c06;
  cursor: pointer;
  margin-left: 8px;
  font-weight: 500;

  &:hover {
    text-decoration: underline;
  }
`;

const PasswordWrapper = styled.div`
  position: relative;
  width: 100%;
`;

const PasswordToggle = styled.button`
  position: absolute;
  right: 16px;
  top: 50%;
  transform: translateY(-50%);
  background: none;
  border: none;
  color: #fff;
  cursor: pointer;
`;

const ModalClose = styled.div`
  display: none;
  @media (max-width: 768px) {
    display: flex;
    height: 30px;
    width: 30px;
    justify-content: center;
    align-items: center;
    border-radius: 20%;
    background-color: #2D6A4D;
    position: absolute;
    padding: 12px;
    top: -550px;
    left: 299px;
    z-index: 9999;
  }
`;

const CountrySelectWrapper = styled.div`
  select {
    width: 100%;
    background: rgba(0, 0, 0, 0.35);
    border: 1px solid #272B30;
    border-radius: 12px;
    color: white;
    padding: 8px 12px;
    font-size: 12px;
    appearance: none;
    background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='white' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 12px center;
    background-size: 16px;
    cursor: pointer;

    @media (max-width: 768px) {
      font-size: 13px;
      border-radius: 8px;
    }

    &:focus {
      outline: none;
      border-color: #f09c06;
    }

    option {
      background: #1E2124;
      color: white;
      padding: 8px;
    }
  }
`;

const FlagIcon = styled.span`
  display: inline-block;
  width: 20px;
  height: 15px;
  margin-right: 8px;
  vertical-align: middle;
  background-image: url(https://flagcdn.com/${props => props.countryCode.toLowerCase()}.svg);
  background-size: cover;
  background-position: center;
`;
// Add these styled components to your existing styled components

const OtpSectionWrapper = styled.div`
  display: flex;
  flex-direction: column;
  width: 100%;
  padding: 1rem 0;
`;

const OtpDescription = styled.p`
  font-size: 14px;
  color: #666;
  margin-bottom: 1.5rem;
  text-align: center;
`;

const VerifyButton = styled.button`
  width: 100%;
  background-color:  #f09c06;
  color: white;
  padding: 12px;
  margin-top: 1rem;
  border: none;
  border-radius: 4px;
  cursor: pointer;
  font-size: 16px;
  font-weight: 500;
  transition: background-color 0.3s;

  &:hover {
    // background-color: #f09c06;
  }

  &:disabled {
    background-color: #cccccc;
    cursor: not-allowed;
  }
`;

const ResendWrapper = styled.div`
  display: flex;
  justify-content: center;
  margin-top: 1rem;
`;

const ResendButton = styled.button`
  background: none;
  border: none;
  color: #1a73e8;
  cursor: pointer;
  font-size: 14px;
  text-decoration: underline;
  
  &:hover {
    color: #0d47a1;
  }
`;

const ResendTimerText = styled.span`
  color: #666;
  font-size: 14px;
`;

const BackButton = styled.button`
  background: none;
  border: none;
  color: #666;
  cursor: pointer;
  font-size: 14px;
  margin-top: 1.5rem;
  align-self: center;
  
  &:hover {
    color: #333;
    text-decoration: underline;
  }
`;

const VerifiedBadge = styled.div`
  display: inline-flex;
  align-items: center;
  background-color: #e6f7e6;
  color: #2e7d32;
  padding: 4px 8px;
  border-radius: 4px;
  font-size: 12px;
  margin-top: 5px;
`;

const CheckIcon = styled.span`
  margin-left: 5px;
  
  &:before {
    content: '✓';
  }
`;
class RegisterPageModal extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isLogged: storage.getKey('logged'),
            show: true,
            username: '',
            email: '',
            password: '',
            phoneNumber: '',
            referral: this.props.referral || '',
            ruleChecked: false,
            marketingChecked: false,
            submitted: false,
            disabled: false,
            effect: 'zoomIn',
            selectedCountry: null,
            country: '',
            // New OTP related state
            otpSent: false,
            otpVerified: false,
            otp: '',
            resendTimer: 0,
            showOtpSection: false,
            showPassword: false
        };
        this.resendTimerInterval = null;
    }

    componentDidMount() {
        socket.off(C.REGISTER);
        socket.on(C.REGISTER_USER, data => this.setRegister(decode(data)));
        Event.on('register_form', () => {
            this.handleShow();
        });
        
        // Automatically show modal when component mounts via route
        this.handleShow();
    }
    componentWillUnmount() {
        // Clear timer interval if component unmounts
        socket.off(C.REGISTER, this.setRegister);
        if (this.resendTimerInterval) {
            clearInterval(this.resendTimerInterval);
        }
    }

    handleCountryChange = (country) => {
        this.setState({ selectedCountry: country });
    }

    setRegister = (data) => {
        console.log('Received registration response:', data);

        if (data.error) {
            console.log('Registration error:', data.error);
            this.setState({ disabled: false, submitted: false });
            sendNotfication(data.error, 'error', 'bottom-left');
            return;
        }

        if (data.status) {
            console.log('Registration successful');
            this.setState({ submitted: false });
            // sendNotfication('Registration successful!', 'success', 'bottom-left');

            wait(1000).then(() => {
                socket.emit(C.LOGIN_USER, encode({
                    username: data.name,
                    password: data.password,
                    recaptcha: 'google'
                }));
            });

            localStorage.setItem('showLoginSuccessModal', 'true');
            this.handleClose();
        }
    };

    handleShow = () => {
        this.setState({ show: true, effect: 'zoomIn' });
    }

    handleClose = () => {
        this.setState({
            show: false,
            effect: 'zoomOut',
            disabled: false,
            submitted: false,
            ruleChecked: false,
            marketingChecked: false,
            otpSent: false,
            otpVerified: false,
            otp: '',
            showOtpSection: false,
            resendTimer: 0
        });
        if (this.resendTimerInterval) {
            clearInterval(this.resendTimerInterval);
            this.resendTimerInterval = null;
        }
        // Redirect to home page
        this.props.history.push('/');
    }

    verifyRefrelCode = async () => {
        try {
            const response = await axios.get(`https://api.boss707.com/verify-referral-code/${this.state.referral}`);
            console.log(response);
            console.log(response.data.valid);  // Access the valid field from response.data
            return response.data.valid;
        } catch (error) {
            console.log("error", error);
            return false;
        }
    }

    // Function to handle sending OTP
    sendOtp = async () => {
        const { email } = this.state;

        // Basic validation
        if (!email) {
            sendNotfication('Please enter an email address', 'error', 'bottom-left');
            return;
        }

        if (!isEmail(email)) {
            sendNotfication('Please enter valid email address', 'error', 'bottom-left');
            return;
        }

        try {
            // Call the OTP send API
            const response = await axios.post('https://api.boss707.com/email/otp/send', {
                email: email,
                purpose: 'register'
            });

            if (response.data.success) {
                // OTP sent successfully
                this.setState({
                    otpSent: true,
                    showOtpSection: true,
                    resendTimer: 30
                });
                sendNotfication('OTP sent successfully to your email', 'success', 'bottom-left');

                // Start the resend timer
                this.startResendTimer();

            } else {
                // Error sending OTP
                sendNotfication(response.data.error || 'Failed to send OTP', 'error', 'bottom-left');
            }
        } catch (error) {
            console.error('Error sending OTP:', error);
            sendNotfication('An error occurred while sending OTP', 'error', 'bottom-left');
        }
    }

    // Function to verify OTP
    verifyOtp = async () => {
        const { email, otp } = this.state;

        if (!otp) {
            sendNotfication('Please enter the OTP', 'error', 'bottom-left');
            return;
        }

        try {
            const response = await axios.post('https://api.boss707.com/email/otp/verify', {
                email: email,
                otp: otp,
                purpose: 'register'
            });

            if (response.data.success) {
                // OTP verified successfully
                this.setState({
                    otpVerified: true,
                    showOtpSection: false
                });
                // sendNotfication('Email verified successfully!', 'success', 'bottom-left');

                // Clear the timer if it's running
                if (this.resendTimerInterval) {
                    clearInterval(this.resendTimerInterval);
                    this.resendTimerInterval = null;
                }

                // Proceed with registration after OTP verification
                this.finalizeRegistration();

            } else {
                // Invalid OTP
                sendNotfication(response.data.error || 'Invalid OTP', 'error', 'bottom-left');
            }
        } catch (error) {
            console.error('Error verifying OTP:', error);
            sendNotfication('An error occurred while verifying OTP', 'error', 'bottom-left');
        }
    }

    // Function to resend OTP
    resendOtp = async () => {
        const { email, resendTimer } = this.state;

        // Check if timer has expired
        if (resendTimer > 0) {
            sendNotfication(`Please wait ${resendTimer} seconds before requesting another OTP`, 'warning', 'bottom-left');
            return;
        }

        try {
            const response = await axios.post('https://api.boss707.com/email/otp/resend', {
                email: email,
                purpose: 'register'
            });

            if (response.data.success) {
                // OTP resent successfully
                this.setState({ resendTimer: 30 });
                sendNotfication('OTP resent successfully', 'success', 'bottom-left');

                // Restart the timer
                this.startResendTimer();

            } else {
                sendNotfication(response.data.error || 'Failed to resend OTP', 'error', 'bottom-left');
            }
        } catch (error) {
            console.error('Error resending OTP:', error);
            sendNotfication('An error occurred while resending OTP', 'error', 'bottom-left');
        }
    }

    // Start the resend timer
    startResendTimer = () => {
        // Clear any existing interval
        if (this.resendTimerInterval) {
            clearInterval(this.resendTimerInterval);
        }

        this.resendTimerInterval = setInterval(() => {
            this.setState(prevState => {
                if (prevState.resendTimer <= 1) {
                    clearInterval(this.resendTimerInterval);
                    this.resendTimerInterval = null;
                    return { resendTimer: 0 };
                }
                return { resendTimer: prevState.resendTimer - 1 };
            });
        }, 1000);
    }
    //   handleSubmit = async (e) => {
    //     console.log('Registration process started');
    //     e.preventDefault();

    //     this.setState({ submitted: true, disabled: true });
    //     console.log('Form submission state updated - submitted: true, disabled: true');

    //     const { username, email, password, ruleChecked, referral, phoneNumber, country } = this.state;
    //     console.log('Form data:', {
    //         username,
    //         email,
    //         hasPassword: !!password,
    //         ruleChecked,
    //         hasReferral: !!referral,
    //         phoneNumber,
    //         country
    //     });

    //     // Referral verification
    //     if (referral && referral.trim()) {
    //         console.log('Verifying referral code:', referral);
    //         const verified = await this.verifyRefrelCode();
    //         console.log('Referral verification result:', verified);

    //         if (!verified) {
    //             console.log('Invalid referral code - stopping registration');
    //             this.setState({ disabled: false });
    //             sendNotfication('Please enter valid referral code', 'error', 'bottom-left');
    //             return;
    //         }
    //     }

    //     // Required fields validation with specific error messages
    //     if (!username) {
    //         console.log('Username missing');
    //         this.setState({ disabled: false });
    //         sendNotfication('Please enter a username', 'error', 'bottom-left');
    //         return;
    //     }

    //     if (!password) {
    //         console.log('Password missing');
    //         this.setState({ disabled: false });
    //         sendNotfication('Please enter a password', 'error', 'bottom-left');
    //         return;
    //     }

    //     if (!email) {
    //         console.log('Email missing');
    //         this.setState({ disabled: false });
    //         sendNotfication('Please enter an email address', 'error', 'bottom-left');
    //         return;
    //     }

    //     if (!ruleChecked) {
    //         console.log('Terms not accepted');
    //         this.setState({ disabled: false });
    //         sendNotfication('Please accept the Terms of Service', 'error', 'bottom-left');
    //         return;
    //     }

    //     // Username length validation
    //     if (username.length < 5) {
    //         console.log('Username too short:', username.length);
    //         this.setState({ disabled: false });
    //         sendNotfication('Please enter username more than 5 characters', 'error', 'bottom-left');
    //         return;
    //     }

    //     // Email validation
    //     if (!isEmail(email)) {
    //         console.log('Invalid email format:', email);
    //         this.setState({ disabled: false });
    //         sendNotfication('Please enter valid email address', 'error', 'bottom-left');
    //         return;
    //     }

    //     // Country validation
    //     if (!country) {
    //         console.log('Country not selected');
    //         this.setState({ disabled: false });
    //         sendNotfication('Please select country', 'error', 'bottom-left');
    //         return;
    //     }

    //     try {
    //         // Prepare registration data
    //         const registrationData = {
    //             username: username,
    //             password: password,
    //             email: email,
    //             phone: phoneNumber,
    //             method: true,
    //             refree: referral || '',
    //             country: country,
    //             aff: storage.getKey('aff') ? storage.getKey('aff') : null
    //         };

    //         console.log('Sending registration data to server:', {
    //             ...registrationData,
    //             password: '[HIDDEN]' // Hide password in logs
    //         });

    //         // Emit registration event
    //         socket.emit(C.REGISTER_USER, encode(registrationData));
    //         console.log('Registration data sent to server');

    //         // Don't close the form immediately - wait for server response
    //         // The form will be closed in setRegister if registration is successful
    //     } catch (error) {
    //         console.error('Registration error:', error);
    //         this.setState({ disabled: false });
    //         sendNotfication('An error occurred during registration. Please try again.', 'error', 'bottom-left');
    //     }
    // }
    //   handleInputChange = (e) => {
    //       this.setState({ [e.target.name]: e.target.value });
    //   }

    //   checkRule = () => {
    //       this.setState(prevState => ({ ruleChecked: !prevState.ruleChecked }));
    //   }

    //   checkMarketing = () => {
    //       this.setState(prevState => ({ marketingChecked: !prevState.marketingChecked }));
    //   }

    //   login = () => {
    //       this.handleClose();
    //       Event.emit('login_form');
    //   }
    //   selectCountry = (val) => {
    //     this.setState({ country: val });
    // }
    // Modified handleSubmit to first verify OTP before registration
    handleSubmit = async (e) => {
        console.log('Registration process started');
        e.preventDefault();

        this.setState({ submitted: true, disabled: true });
        console.log('Form submission state updated - submitted: true, disabled: true');

        const { username, email, password, ruleChecked, otpVerified } = this.state;

        // Required fields validation with specific error messages
        if (!username) {
            console.log('Username missing');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please enter a username', 'error', 'bottom-left');
            return;
        }

        if (!password) {
            console.log('Password missing');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please enter a password', 'error', 'bottom-left');
            return;
        }
        // Add strong password validation
        if (password.length < 8) {
            console.log('Password too short');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Password must be at least 8 characters long', 'error', 'bottom-left');
            return;
        }

        // Check for # character which is not allowed
        if (password.includes('#')) {
            console.log('Password contains # which is not allowed');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Password cannot contain the # character', 'error', 'bottom-left');
            return;
        }

        // Add complexity requirement (at least one uppercase, one lowercase, one number, and one special character)
        // Allow all special characters except #
        const strongPasswordRegex = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@$%^&*()_+\-=\[\]{};':"\\|,.<>\/?])[A-Za-z\d!@$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/;
        if (!strongPasswordRegex.test(password)) {
            console.log('Password not strong enough');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Password must contain at least one uppercase letter, one lowercase letter, one number, and one special character (except #)', 'error', 'bottom-left');
            return;
        }
        if (!email) {
            console.log('Email missing');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please enter an email address', 'error', 'bottom-left');
            return;
        }

        if (!ruleChecked) {
            console.log('Terms not accepted');
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please accept the Terms of Service', 'error', 'bottom-left');
            return;
        }

        // Username length validation - minimum 3 characters
        if (username.length < 3) {
            console.log('Username too short:', username.length);
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Username must have at least 3 characters', 'error', 'bottom-left');
            return;
        }

        if (username.length > 16) {
            console.log('Username too long', username.length);
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please enter username less than or equal to 16 characters', 'error', 'bottom-left');
            return;
        }

        // Email validation
        if (!isEmail(email)) {
            console.log('Invalid email format:', email);
            this.setState({ disabled: false, submitted: false });
            sendNotfication('Please enter valid email address', 'error', 'bottom-left');
            return;
        }

        // Country validation
        // if (!this.state.country) {
        //     console.log('Country not selected');
        //     this.setState({ disabled: false, submitted: false });
        //     sendNotfication('Please select country', 'error', 'bottom-left');
        //     return;
        // }

        // If OTP is not yet verified, show OTP section
        // if (!otpVerified) {
        //     this.sendOtp();
        //     this.setState({ disabled: false, submitted: false });
        //     return;
        // }

        // Continue with referral verification and final registration
        await this.continueWithReferralCheck();
    }

    // Continue with referral check after OTP verification
    continueWithReferralCheck = async () => {
        const { referral } = this.state;

        // Referral verification
        if (referral && referral.trim()) {
            console.log('Verifying referral code:', referral);
            const verified = await this.verifyRefrelCode();
            console.log('Referral verification result:', verified);

            if (!verified) {
                console.log('Invalid referral code - stopping registration');
                this.setState({ disabled: false, submitted: false });
                sendNotfication('Please enter valid referral code', 'error', 'bottom-left');
                return;
            }
        }

        // Finalize registration process
        this.finalizeRegistration();
    }

    // Finalize registration after all validations
    finalizeRegistration = () => {
        const { username, email, password, phoneNumber, referral, country } = this.state;

        try {
            // Prepare registration data
            const registrationData = {
                username: username,
                password: password,
                email: email,
                phone: phoneNumber,
                method: true,
                refree: referral || '',
                
                aff: storage.getKey('aff') ? storage.getKey('aff') : null
            };

            console.log('Sending registration data to server:', {
                ...registrationData,
                password: '[HIDDEN]' // Hide password in logs
            });

            // Emit registration event
            socket.emit(C.REGISTER_USER, encode(registrationData));
            console.log('Registration data sent to server');
            
            // Don't close the form immediately - wait for server response
            // The form will be closed in setRegister if registration is successful
        } catch (error) {
            console.error('Registration error:', error);
            this.setState({ disabled: false, submitted: false });
            sendNotfication('An error occurred during registration. Please try again.', 'error', 'bottom-left');
        }
        sendNotfication('Registration Successfull', 'success', 'bottom-left');
    }

    handleInputChange = (e) => {
        this.setState({ [e.target.name]: e.target.value });
    }

    togglePasswordVisibility = () => {
        this.setState(prevState => ({
            showPassword: !prevState.showPassword
        }));
    }

    checkRule = () => {
        this.setState(prevState => ({ ruleChecked: !prevState.ruleChecked }));
    }

    checkMarketing = () => {
        this.setState(prevState => ({ marketingChecked: !prevState.marketingChecked }));
    }

    login = () => {
        this.props.history.push('/signin');
    }

    selectCountry = (val) => {
        this.setState({ country: val });
    }

    render() {
        const {
            show,
            username,
            email,
            password,
            phoneNumber,
            referral,
            ruleChecked,
            marketingChecked,
            disabled,
            selectedCountry,
            showOtpSection,
            otp,
            resendTimer,
            otpVerified
        } = this.state;

        return (
            <>
                {/* <SignUpButtonO onClick={this.handleShow}>
                    Sign up
                </SignUpButtonO> */}
                <StyledModal
                    size="md"
                    centered
                    show={show}
                    onHide={this.handleClose}
                    aria-labelledby="register-modal"
                    className={`animated ${this.state.effect}`}
                >
                    <CloseButton onClick={this.handleClose}>×</CloseButton>
                    <RightSection>
                        <RightContent>
                            <ModalClose onClick={this.handleClose}>
                                x
                            </ModalClose>
                        </RightContent>
                        {/* <StayUntamed>
                          <h2>Stay Untamed</h2>
                          <p>Sign Up & Get Welcome Bonus</p>
                      </StayUntamed> */}
                    </RightSection>
                    <LeftSection>
                        <Title>{showOtpSection ? 'Verify Email' : 'Sign Up'}</Title>

                        {showOtpSection ? (
                            <OtpSectionWrapper>
                                <OtpDescription>
                                    We've sent a verification code to {email}. Please check your inbox and enter the code below.
                                </OtpDescription>

                                <InputWrapper>
                                    <Label htmlFor="otp">Verification Code</Label>
                                    <StyledInput
                                        type="text"
                                        id="otp"
                                        name="otp"
                                        placeholder="Enter OTP"
                                        value={otp}
                                        onChange={this.handleInputChange}
                                        required
                                    />
                                </InputWrapper>

                                <VerifyButton
                                    type="button"
                                    onClick={this.verifyOtp}
                                    disabled={disabled}
                                >
                                    Verify Code
                                </VerifyButton>

                                <ResendWrapper>
                                    {resendTimer > 0 ? (
                                        <ResendTimerText>
                                            Resend code in {resendTimer} seconds
                                        </ResendTimerText>
                                    ) : (
                                        <ResendButton type="button" onClick={this.resendOtp}>
                                            Resend Code
                                        </ResendButton>
                                    )}
                                </ResendWrapper>

                                <BackButton type="button" onClick={() => this.setState({ showOtpSection: false })}>
                                    Back to Sign Up
                                </BackButton>
                            </OtpSectionWrapper>
                        ) : (
                            <StyledForm onSubmit={this.handleSubmit}>
                                <InputWrapper>
                                    <Label htmlFor="username">Username</Label>
                                    <StyledInput
                                        type="text"
                                        id="username"
                                        name="username"
                                        placeholder="Enter username"
                                        value={username}
                                        onChange={this.handleInputChange}
                                        required
                                    />
                                </InputWrapper>

                                <InputWrapper>
                                    <Label htmlFor="email">Email</Label>
                                    <StyledInput
                                        type="email"
                                        id="email"
                                        name="email"
                                        placeholder="Enter email"
                                        value={email}
                                        onChange={this.handleInputChange}
                                        required
                                    />
                                </InputWrapper>

                                <InputWrapper>
                                    <Label htmlFor="password">Password</Label>
                                    <PasswordWrapper>
                                        <StyledInput
                                            type={this.state.showPassword ? "text" : "password"}
                                            id="password"
                                            name="password"
                                            placeholder="Enter password"
                                            value={password}
                                            onChange={this.handleInputChange}
                                            required
                                        />
                                        <PasswordToggle 
                                            type="button" 
                                            onClick={this.togglePasswordVisibility}
                                        >
                                            {this.state.showPassword ? (
                                                <svg viewBox="0 0 24 24" width="20" height="20">
                                                    <path fill="currentColor" d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.20-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"/>
                                                </svg>
                                            ) : (
                                                <svg viewBox="0 0 24 24" width="20" height="20">
                                                    <path fill="currentColor" d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
                                                </svg>
                                            )}
                                        </PasswordToggle>
                                    </PasswordWrapper>
                                </InputWrapper>
                                {/* <InputWrapper>
                                    <Label>Country</Label>
                                    <CountrySelectWrapper>
                                        <CountryDropdown
                                            value={this.state.country}
                                            onChange={this.selectCountry}
                                            priorityOptions={["US", "GB", "CA", "AU"]}
                                            valueType="short"
                                        />
                                    </CountrySelectWrapper>
                                </InputWrapper> */}
                                {/* <InputWrapper>
                                    <Label htmlFor="phoneNumber">Phone Number (Optional)</Label>
                                    <StyledInput
                                        type="tel"
                                        id="phoneNumber"
                                        name="phoneNumber"
                                        placeholder="Enter phone number"
                                        value={phoneNumber}
                                        onChange={this.handleInputChange}
                                    />
                                </InputWrapper> */}

                                <InputWrapper>
                                    <Label htmlFor="referral">Referral Code (Optional)</Label>
                                    <StyledInput
                                        type="text"
                                        id="referral"
                                        name="referral"
                                        placeholder="Enter referral code"
                                        value={referral}
                                        onChange={this.handleInputChange}
                                    />
                                </InputWrapper>

                                <CheckboxContainer>
                                    <CheckboxInput
                                        type="checkbox"
                                        id="rules"
                                        checked={ruleChecked}
                                        onChange={this.checkRule}
                                        required
                                    />
                                    <CheckboxLabel htmlFor="rules">
                                        I agree to the Terms of Service and Privacy Policy
                                    </CheckboxLabel>
                                </CheckboxContainer>

                                <CheckboxContainer>
                                    <CheckboxInput
                                        type="checkbox"
                                        id="marketing"
                                        checked={marketingChecked}
                                        onChange={this.checkMarketing}
                                    />
                                    <CheckboxLabel htmlFor="marketing">
                                        I agree to receive marketing communications
                                    </CheckboxLabel>
                                </CheckboxContainer>

                                <SignUpButton type="submit" onClick={this.handleSubmit}>
                                    Sign Up
                                </SignUpButton>
                            </StyledForm>
                        )}


                        <SignInText>
                            Already have an account?
                            <SignInLink onClick={this.login}>Sign In</SignInLink>
                        </SignInText>
                    </LeftSection>
                </StyledModal>
            </>
        );
    }
}

export default RegisterPageModal;