import React from 'react';
// import { IoDice } from "react-icons/io5";
import './index.css'

const games = [
    {id:1, name: "Crash", icon: "", house_edge:"House Edge 1%", route: "crash", isActive: false, img: "https://img2.nanogames.io/game/image/c405f953-f7ca-4da5-8309-dcba4fc44e7d.png"},
    {id:3, name: "Plinko", icon: "", house_edge:"House Edge 1%", route: "plinko", isActive: false, img: "https://img2.nanogames.io/game/image/ae817f12-fa67-49b8-b33e-6cafda497488.png" },
    {id:4, name: "Tower", icon: "", house_edge:"House Edge 1%", route: "tower", isActive: false, img: "https://img2.nanogames.io/game/image/7f1f471d-0768-42f1-9d92-e70ce0e10235.png" },
    {id:5, name: "HiLo", icon: "", house_edge:"House Edge 1%", route: "hilo", isActive: false, img:"https://img2.nanogames.io/game/image/d64c5ee5-68c0-4d7e-bf8d-0be925f378b1.png" },
    {id:2, name: "Classic Dice", icon: "", house_edge:"House Edge 1%", route: "classic-dice", isActive: false, img: "https://img2.nanogames.io/game/image/0aa80aca-75d1-4fff-b8c9-1d67f1498373.png" },
    {id:6, name: "Diamonds", icon: "", house_edge:"House Edge 1%", route: "diamonds", isActive: false, img: "https://img2.nanogames.io/game/image/42026a73-a033-4a57-bb1c-7e09fd2ea30f.png" },
    {id:7, name: "Mines", icon: "", house_edge:"House Edge 1%", route: "mines", isActive: false, img: "https://img2.nanogames.io/game/image/0aa3d807-0380-4f8e-b65e-3179d4af2234.png" },
];

const GameItem = ({ game }) => (
    <div className="sc-gfqkcP epfPPG bot-view super-block game-crash">
        <a className="sc-hKTqa dbJiKC game-item-wrap" href={`/${game.route}`}>
            <div className="lazy-img img">
                <img src={game.img} alt={game.name} />
            </div>
            <div className="hover-mask">
                <div className="house-edge">{game.house_edge}</div>
                <svg className="play-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 63 63">
                    <g fill="none" fillRule="evenodd">
                        <circle cx="31.3" cy="31.3" r="30.3" fill="#000" fillOpacity=".2" stroke="#E5E7EE" strokeWidth="2"/>
                        <path fill="#F5F6F7" d="M39.5 34.3l-11.3 7.5a2 2 0 01-3-1.6v-15a2 2 0 013-1.7L39.5 31a2 2 0 010 3.3z"/>
                    </g>
                </svg>
            </div>
        </a>
        <div className="sc-fivaXQ gVplre bot-view">
            <div className="wrap">
                <a className="item" href={`/${game.route}`}>{game.name}</a>
                <div className="help-btn-wrap">
                    <button>
                        <svg xmlns="http://www.w3.org/2000/svg" className="sc-gsDKAQ hxODWG icon">
                            <use xlinkHref="#icon_Help"></use>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
);

const GameList = () => (
    <div className='sc-jYmNlR blJYGp sc-emDsmM ijbeXh'>
        <div className='sc-ekrjqK hmXLyn'>
            <div className="sc-jibziO dJteWA nav-tit">
                <div className="cont-txt">truewinz <b>IN-HOUSE</b><br/>GAMES</div>
            </div>
        </div>
        <div className="sc-bjeSbO cFDYcT grid-list">
            {games.map(game => (
                <GameItem key={game.id} game={game} />
            ))}
        </div>
    </div>
);

export default GameList;