import React, { useState, useEffect, useCallback } from "react";
import { Link, useLocation } from 'react-router-dom';
import styled from "styled-components";
import Login from "../../Auth/Login";
import Register from "../../Auth/Register";
import SkylaMenu from "../../../../Icons/Menu";
import MenuPlayIcon from "../../../../Icons/Menu";
import SearchStarIcon from "../../../../Icons/Search";
import MessageIcon from "../../../../Icons/Chat";
import GlobeIcon from "../../../../Icons/Glob";
import SkylaSidebar from "../../../Components/SkylaSiebar";
import { useSidebar } from "../../../../context/SidebarContext";
import BottomNavigation from "../../../Components/SkylaBottomTab";
import { isMobile } from "../../../../Helper";
import GlobalSearchModal from "../GlobalSearch";

const HeaderWrapper = styled.div`
  width: 100%;
  background: #03030F;
  border-bottom: 1px solid #2C2F36;
  height: 63px;
  padding: 12px 16px;
  position: sticky;
  top: 0;
  z-index: 1000;
  box-shadow: 
    0 10px 15px -3px rgba(0, 0, 0, 0.15), 
    0 4px 6px -2px rgba(0, 0, 0, 0.1),
    0 2px 4px -1px rgba(0, 0, 0, 0.05);
`;

const StyledSignInButton = styled(Link)`
  font-size: 14px;
  color: #fff !important;
  background-color: transparent;
  border: 1px solid #f09c06;
  border-radius: 10px;
  padding: 7px 14px;
  font-weight: bold;
  cursor: pointer;
  white-space: nowrap;
  text-decoration: none;
  display: inline-block;

  @media (max-width: 768px) {
    width: 100%;
    text-align: center;
    font-size: 13px;
    padding: 6px 12px;
    border-radius: 8px;
  }
`;

const SignUpButtonO = styled(Link)`
  font-size: 14px;
  background: #f09c06;
  border-radius: 10px;
  padding: 7px 14px;
  font-weight: bold;
  cursor: pointer;
  color: black !important;
  white-space: nowrap;
  text-decoration: none;
  display: inline-block;

  @media (max-width: 768px) {
    width: 100%;
    text-align: center;
    font-size: 13px;
    padding: 6px 12px;
    border-radius: 8px;
  }
`;

const HeaderContainer = styled.header`
  display: flex;
  align-items: center;
  justify-content: space-between;
`;

const LeftSection = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
`;

const LogoContainer = styled(Link)`
  display: flex;
  align-items: center;
`;

const Logo = styled.img`
  width: ${props => props.$showFull ? '100px' : '96px'};
  height: auto;
  transition: width 0.3s ease;
  object-fit: contain;
`;

const SearchBarContainer = styled.div`
  display: none;
  flex: 1;
  max-width: 576px;
  margin: 0 16px;
  
  @media (min-width: 768px) {
    display: flex;
  }
`;

const RightSection = styled.div`
  display: flex;
  align-items: center;
  gap: 12px;
`;

const IconButton = styled.button`
  padding: 8px;
  background: transparent;
  border: none;
  border-radius: 9999px;
  cursor: pointer;
  transition: background-color 0.2s ease;

  &:hover {
    background-color: #2C2F36;
  }

  @media (max-width: 768px) {
    display: none;
  }
`;

const IconBg = styled.div`
   padding: 6px 8px;
  background-color: rgb(18, 20, 24);
  border-radius: 10px;
`;

const MenuIconBg = styled(IconBg)`
  @media (max-width: 768px) {
    display: none;
  }
`;

const AuthButtons = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
`;

const ResponsiveSidebarWrapper = styled.div`
  @media (max-width: 768px) {
    display: none;
  }
`;

const Header = () => {
  const [showLogo, setShowLogo] = useState(window.innerWidth > 768);
  const [isOpenSearch, setIsOpenSearch] = useState(false);
  const { isCollapsed, setIsCollapsed } = useSidebar();

  const location = useLocation();
  const isSportsRoute = () => {
    const path = location.pathname;
    return path.startsWith('/sports/') || path.startsWith('/match/');
  };

  useEffect(() => {
    const handleResize = () => {
      setShowLogo(window.innerWidth > 768);
    };
    window.addEventListener('resize', handleResize);
    return () => {
      window.removeEventListener('resize', handleResize);
    };
  }, []);

  const handleCollapse = useCallback(() => {
    setIsCollapsed(prev => !prev);
  }, []);

  return (
    <div style={{ display: "flex" }}>
      {!isSportsRoute() && (
        <ResponsiveSidebarWrapper>
          <SkylaSidebar isCollapsed={isCollapsed} />
        </ResponsiveSidebarWrapper>
      )}

      <HeaderWrapper>
        <HeaderContainer>
          <LeftSection>
            <MenuIconBg onClick={handleCollapse}>
              <MenuPlayIcon />
            </MenuIconBg>
            <LogoContainer to="/">
              <Logo
                src="./assets/boss707.png"
                alt="Logo"
                $showFull={showLogo}
              />
            </LogoContainer>
          </LeftSection>
          <RightSection>
          {
            !isMobile&&(
              <IconBg onClick={() => setIsOpenSearch(!isOpenSearch)}>
              <SearchStarIcon />
            </IconBg>
            )
          }
            <AuthButtons>
              <StyledSignInButton to="/signin">Sign In</StyledSignInButton>
              <SignUpButtonO to="/signup">Sign Up</SignUpButtonO>
            </AuthButtons>
            {/* <IconBg>
              <MessageIcon />
            </IconBg>
            <IconBg>
              <GlobeIcon />
            </IconBg> */}
          </RightSection>
        </HeaderContainer>
      </HeaderWrapper>

      <GlobalSearchModal  isOpen={isOpenSearch} onClose={() => setIsOpenSearch(false)} />      
    </div>
  );
};

export default Header;