import React, { useEffect, useState } from "react";
import { Link } from "react-router-dom";
import styled from "styled-components";
import {
  __,
  wait,
  Event,
  decode,
} from "../../../../../Helper";
import socket from "../../../../../Socket";
import C from "../../../../../Constant";

const HeaderContainer = styled.div`
  width: 100%;
  display: flex;
  justify-content: space-between;
`;

const HeaderContent = styled.div`
  display: flex;
  gap: 10px;
  align-items: center;
`;

const TopTitle = styled.h3`
  color: white;
  font-size: 16px;
  font-weight: bold;
`;

const GridWrapper = styled.div`
  display: grid;
  grid-template-columns: repeat(3, 1fr); // 3 columns for all screens
  gap: 10px; // Adjust gap between items as needed
  margin-top: 20px;

  @media (min-width: 768px) {
    grid-template-columns: repeat(8, 1fr); // 8 columns for larger screens
  }
`;

const GameCard = styled.div`
  height: 190px; // Fixed height to maintain aspect ratio
  border-radius: 8px;
  position: relative;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  transition: transform 0.2s ease;
  overflow: hidden;

  &:hover {
    transform: translateY(-5px);
  }

  @media (max-width: 768px) {
    height: 150px; // Adjust height for mobile if needed
  }
`;

const GameImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover; // Ensures the image covers the card without cutting off
  border-radius: 8px; // Ensure border radius is applied
`;

const GameTitle = styled.div`
  color: #fff;
  font-size: 14px;
  font-weight: bold;
  text-align: center;
  margin-top: 8px;
`;

const LiveCasinoGames = ({ title, games }) => {
  const [loading, setLoading] = useState(false);



  if (loading) {
    return (
      <div className="ycenter text-center">
        <div className="spinner-grow text-white my-5" role="status" />
      </div>
    );
  }

  return (
    <>
      <HeaderContainer>
        <TopTitle>{title}</TopTitle>
      
      </HeaderContainer>

      <GridWrapper>
        {games.slice(0, 18).map((game, index) => (
            <GameCard
            key={game.game_code}
           onClick={() => onGameLaunch(game.game_code, game.provider_code)} 
          >
            <GameImage src={game.banner} alt={`Game ${index}`} />
            <GameOverlay>
              <PlayIconContainer>
                <PlayIcon />
              </PlayIconContainer>
            </GameOverlay>
          </GameCard>
        ))}
      </GridWrapper>
    </>
  );
};

export default LiveCasinoGames;