import React from 'react';
import styled from 'styled-components';

const Container = styled.div`
  background:rgb(18, 20, 24);
  color: #b9bbbe;
  padding: 24px;
  border-radius: 20px;

`;

const Section = styled.section`
  margin-bottom: 24px;
`;

const Title = styled.div`
  color: #ffffff;
  font-size: 20px;
  margin-bottom: 12px;
`;

const Paragraph = styled.div`
  font-size: 14px;
  line-height: 1.5;
  margin-bottom: 12px;
`;

const List = styled.ul`
  list-style-type: none;
  padding-left: 0;
`;

const ListItem = styled.li`
  font-size: 14px;
  line-height: 1.5;
  margin-bottom: 8px;
  &:before {
    content: "•";
    color: #b9bbbe;
    display: inline-block;
    width: 1em;
    margin-left: -1em;
  }
`;

const Link = styled.a`
  color: #00b0f4;
  text-decoration: none;
  &:hover {
    text-decoration: underline;
  }
`;

const CryptocurrencyInfo = () => (
  <Container>
    <Section>
      <Title>What is cryptocurrency?</Title>
      <Paragraph>
        Cryptocurrency is a digital currency that does not rely on any real substance and makes use of cryptography, eg. Bitcoin, litcoin, BitShares, etc. It is a digital currency that is created, distributed, and maintained based on cryptography and validation technology. The characteristics of cryptocurrency are its application of P2P technology and the fact that everyone issues it.
      </Paragraph>
      <Paragraph>
        Cryptocurrency is also an online payment system that supports anonymous transcommon.actions. Bitcoin is the top cryptocurrency, and is recognised by the laws in many countries.
      </Paragraph>
    </Section>

    <Section>
      <Title>Why using cryptocurrency?</Title>
      <Paragraph>
        Due to several reasons, crytocurrency is the most popular and widely used digital currency. In contrast to traditional transfer, We transfers never require several hours of waiting, and are not affected by the transfer amount or the region of the user. The fee is also much lower, and is usually a few cents. Refund will not happen to cryptocurrency, and no cheating is possible. No bank, government agency, or individual could manipulate cryptocurrency. In contrast to traditional currency, cryptocurrency transactions are anonymous, and there is no threat of confiscation.
      </Paragraph>
    </Section>

    <Section>
      <Title>How does cryptocurrency transaction work?</Title>
      <Paragraph>
        Cryptocurrency transactions are actually very simple. Basically it is to send cryptocurrency from an online wallet to another. The first step in the whole process is that the payer sends a private key (a randomly generated sequence of numbers) to the payee, after which a transaction will go through 0 to 5 validations. An ordinary transaction will go through 1 validation, but if the amount is very large, it is better to perform multiple validations. It takes about 10 minutes for a single validation on the blockchain network. After validation, anyone on the blockchain can check this transaction but could not see any sensitive information.
      </Paragraph>
    </Section>

    <Section>
      <Title>How to purchase cryptocurrency?</Title>
      <Paragraph>Cryptocurrency can be purchased at the following places:</Paragraph>
      <List>
        <ListItem>
          <strong>Market exchange:</strong> If the buyer does not care much about privacy, then an online market exchange is the best option to buy cryptocurrency because market exchanges usually require the buyers to provide identification. Buyers could purchase cryptocurrency from a market exchange and store it there.
        </ListItem>
        <ListItem>
          <strong>Over the counter:</strong> This means two people perform a cryptocurrency transaction face-to-face. Usually cryptocurrency transactions are carried out anonymously between the two parties. Although the face-to-face approach does not enjoy this benefit, it is still very popular. Sellers and buyers could contact each other through many websites.
        </ListItem>
        <ListItem>
          <strong>Cryptocurrency ATM:</strong> These ATM are no different from normal ATM apart from that the buyer gets a receipt with a certain code instead of cash. By scanning the code, the bitcoin will be transferred to the buyer's wallet.
        </ListItem>
      </List>
    </Section>

    <Section>
      <Title>Is cryptocurrency legal?</Title>
      <Paragraph>
        Simply put, the legal status of cryptocurrency is getting better. In the past few months, Japan announced to recognise bitcoin as a legal currency, and Russia also declared its plan to recognise bitcoin as a financial tool. This is a major change of stance for Russia, since bitcoin was originally banned in Russia.
      </Paragraph>
      <Paragraph>
        While cryptocurrency gradually becomes a strong and important global currency, this kind of change will also increase. The regulation on, use of, and taxation on cryptocurrency still vary across countries. On the other hand, new laws and rules are published all the time. If you wish to know in details about your government's stance on cryptocurrency and potential changes in the future, please contact a legal consultant.
      </Paragraph>
    </Section>

    <Section>
      <Title>Bitcoin wallet</Title>
      <Paragraph>
        There are many bitcoin wallet available. There are cloud-based wallets as well as wallets that can be downloaded to personal computers, tablet computers, or mobile phones. You can also get a physical hardware wallet that stores cryptocurrency. There is a common function among the various wallets, which is to transfer cryptocurrency, but each wallet has its own merit.
      </Paragraph>
    </Section>

    <Section>
      <Title>Cloud-based wallet</Title>
      <Paragraph>
        Cloud-based wallet is the easiest and most convenient to use wallet. However, storing cryptocurrency in the cloud means trusting a third party with your money.
      </Paragraph>
    </Section>

    <Section>
      <Title>Software wallet</Title>
      <Paragraph>
        A software wallet is a downloadable program that can be run on computers, tablet computers, or mobile phones. A software wallet is safer than a cloud-based one because you can take full control of it. However, a software wallet still has its risks.
      </Paragraph>
      <Paragraph>We recommend the following software wallets:</Paragraph>
      <List>
        <ListItem>copay.io</ListItem>
        <ListItem>Breadwallet</ListItem>
        <ListItem>Mycelium</ListItem>
      </List>
    </Section>

    <Section>
      <Title>Hardware Wallet</Title>
      <Paragraph>
        A hardware wallet stores the user's private key in a secure hardware device. Compared to software wallets, one of the main advantages of hardware wallets is immunity against computer virus. Moreover, since the private key is stored in the protected zone of a microcontroller, it cannot be transferred out of the device in cleartext.
      </Paragraph>
      <Paragraph>We recommend the following hardware wallets:</Paragraph>
      <List>
        <ListItem>Trezor</ListItem>
        <ListItem>Ledger</ListItem>
      </List>
      <Paragraph>
        To know more about various bitcoin wallets, please visit <Link href="https://Bitcoin.org" target="_blank" rel="noopener noreferrer">Bitcoin.org</Link>.
      </Paragraph>
    </Section>

    <Section>
      <Title>Protect your wallet</Title>
      <Paragraph>
        When used properly, bitcoin is highly secure. Please always remember it is your responsibility to take measures to protect your money.
      </Paragraph>
      <Paragraph>You should consider the following points:</Paragraph>
      <List>
        <ListItem>Like legal tender, do not put all your money in one wallet.</ListItem>
        <ListItem>Choose your online wallet carefully. 2FA is a good extra guarantee.</ListItem>
        <ListItem>Back up your wallet regularly. It is also a good practice to encrypt backups that are exposed to the Internet.</ListItem>
        <ListItem>Store the password in a secure location. You may memorise your password, or store it in a secure physical location.</ListItem>
        <ListItem>Choose a strong password that contains letters, numbers, and symbols, and is at least 16 characters long.</ListItem>
        <ListItem>Offline wallet, also known as cold storage, provides the highest security for your deposit. It is to hide the wallet in a secure location that is not connected to the Internet. If implemented well, this option could provide excellent protection against computer vulnerabilities.</ListItem>
      </List>
    </Section>
  </Container>
);

export default CryptocurrencyInfo;