import React from 'react';
import styled from 'styled-components';

const ContentSection = styled.div`
 background:rgb(18, 20, 24);
  padding: 20px;
  border-radius: 20px;
  margin-bottom: 20px;
  color: #b9bbbe;
  font-size: 14px;
  line-height: 1.5;
`;

const SectionTitle = styled.div`
  color: #ffffff;
  font-size: 24px;
  margin-bottom: 20px;
`;

const SubSectionTitle = styled.div`
  color: #ffffff;
  font-size: 18px;
  margin-top: 20px;
  margin-bottom: 10px;
`;

const Link = styled.a`
  color: #43b581;
  text-decoration: none;
  &:hover {
    text-decoration: underline;
  }
`;

const CodeBlock = styled.pre`
//   background-color: #2f3136;
  padding: 10px;
  border-radius: 3px;
//   font-family: monospace;
  white-space: pre-wrap;
  word-wrap: break-word;
`;

export default function FairnessComponent() {
  return (
    <ContentSection>
      <SectionTitle>Fairness</SectionTitle>
      
      <SubSectionTitle>Is The Game Fair?</SubSectionTitle>
     <div>We are a fair and impartial prediction and guessing platform. Our goal is to eliminate all unfair factors and make players feel comfortable and have fun.</div>
     <div>We have generated a total of 10 million hashes (the generation chain is verifiable), and each hash corresponds to a curve crash multiplier.</div>
     <div>We release these 10 million numbers in reverse order, each corresponding to one turn of the game (i.e. we have 10 million turns in total).</div>
     <div>In other words, the crash number of each turn already exists and is not calculated after the game starts. Players can therefore place their bet without concern.</div>
      
      <SubSectionTitle>Will The Game Be Manipulated By The Platform?</SubSectionTitle>
     <div>The integrity check value is key to verifying whether there is any official manipulation; The test algorithm is provided as follows.</div>
     <div>Example: 6b5124897c3c48d0e46cc9249f08c7e560792459f1bad117122463b5d2be231</div>
      <ol>
        <li style={{marginTop:'10px'}}>1. Take a random value in the 2^52 range, namely 16^13, i.e. a 13-bit hexadecimal number (because the hash value is hexadecimal, 2^52 === 16^13)6b5124897c3c4 (0x6b5124897c3c4 equals 1887939992208324 in the decimal system).</li>
        <li style={{marginTop:'10px'}}>2. Distribute the random value to 0~1, by dividing it by the maximum value of 13 fs, namely 0x6b5124897c3c4/0x1000000000000. Given the discrete random nature of the hash value, we then can think that any hash value can be transformed into a random number of 0~1, 1887939992208324/4503599627370496 = 0.419206889692064.</li>
        <li style={{marginTop:'10px'}}> 3. Make the house edge 1%. Further to calculate 99/(1-X), where X is the random value calculated at Step 2. When X is 0, the result is 99; when X is 1, the result is positive infinite; when X is 0.01, the result is 100; when X is less than 0.01, the result is less than 100.</li>
      </ol>
     <div style={{marginTop:'10px'}}>Conclusion: The overall random number distribution is 99 to positive infinite; and when the random number distribution is 0~0.01, the result is less than 100.</div>
      {/* <CodeBlock>99/(1-0.419206889692064) = 170.45656748150867</CodeBlock> */}
      <ol start="4">
        <li>All values less than 100 will be set to 100. In other words, there is a probability of 1% that 100 will appear. Round off the number and divide it by 100 to get the final result.</li>
      </ol>
      {/* <CodeBlock>170/100 = 1.70</CodeBlock> */}
     <div>Conclusion: The hash value used in the game is inverse ordered. Therefore, with the SHA256 algorithm, a previous hash used in the game can be calculated from its subsequent hash. Since there is one-to-one correspondence between the key and the value of hash, we can draw the conclusion that if a hash can be used to calculate the hash that precedes it, then this hash should have been already generated when the preceding prize is announced. Similarly, the entire hash chain is generated at the very beginning and cannot be changed once generated. Otherwise, it cannot pass verification by SHA256, and as far as the payout is concerned, this is nothing more than a probability game in which crash is a given. The official organizer cannot manipulate any game set. Therefore, CRASH is more transparent than other gambling methods. This is the cornerstone on which our game is built.</div>
     <div>Simple calculation:</div>
     <div>When the 13-bit hash value is 8000000000000 = 1.98, 0xb00000000 = 3.168, 0xc00000000 = 3.96, that is, the first digit is greater than 8((16-8)/16≈0.5), the result is approximately 2x; when the first digit is greater than b((16-11)/16≈0.3), the result is approximately 3x; and when the first digit is greater than c((16-12)/16≈0.25), the result is approximately 4x, and the same rule applies to the rest.</div>
     <div>When the 13-bit hash value is f000000000000 = 15.84, ff000000000000 = 253.44, fff000000</div>
    </ContentSection>
  );
}