import React, { useState, useEffect, useRef, useCallback } from 'react';
import PropTypes from "prop-types";
import { connect } from "react-redux";
import PerfectScrollbar from 'perfect-scrollbar';
import styled from "styled-components";
import { Search, ChevronDown, X, InfoIcon, Plus, Info } from 'lucide-react';
import { setCoin, gameCoin, setCredit } from "../../../../actions/gameCoin";
import { __, wait, decode, encode, forceSatoshiFormat, Event, getUID, isMobile } from "../../../../Helper";
import storage from "../../../../Storage";
import coins from "../../../coins";
import socket from "../../../../Socket";
import C from "../../../../Constant";
import SkylaDepositModal from '../../Wallet/Deposit/ModalContent';
import SkylawWalletManage from './ManageCoins.js'
import { useSelector } from 'react-redux';

const ModalOverlay = styled.div`
  position: fixed;
  top: 10%;
  left: 0;
  right: 0;
  bottom: 10%;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.$show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 1050;
  padding: 20px;
   @media (max-width: 768px) {
    padding: 0px;
    // height:100vh;
  }
`;

const ModalContent = styled.div`
    // background:rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 570px;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  min-height: 400px;
  max-height: 76vh;
  display: flex;
  flex-direction: column;
    box-shadow: 
    0 4px 12px rgba(0, 0, 0, 0.2),
    0 1px 3px rgba(0, 0, 0, 0.1),
    inset 0 1px 0 rgba(255, 255, 255, 0.1);

  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

   @media (max-width: 768px) {
    // padding: 0px;
    height:86vh;
      max-height: 76vh;
  }
`;

const ModalHeader = styled.div`
  display: grid;
  grid-template-columns: 24px 1fr 24px;  /* Create three columns: space for balance, title, close button */
  align-items: center;
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
  flex-shrink: 0;
   background: rgb(30, 35, 40);
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const ModalTitle = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  text-align: center;
  grid-column: 2;  /* Place in middle column */
`;

const CloseButton = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  grid-column: 3;  /* Place in last column */
  margin-left: auto;  /* Push to the end */
  
  &:hover {
    color: white;
  }
`;
const ModalBody = styled.div`
  padding: 24px;
  color: white;
  background: rgb(18, 20, 24);
  overflow-y: auto;
  flex-grow: 1;
  
  /* Custom scrollbar styles */
  &::-webkit-scrollbar {
    width: 6px;
  }
  
  &::-webkit-scrollbar-track {
    background: #2A2D35;
    border-radius: 3px;
  }
  
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
     @media (max-width: 768px) {
    padding: 12px 14px;
    height:100vh;
  }
`;

// const CloseButton = styled.button`
//   background: none;
//   border: none;
//   color: #6F767E;
//   cursor: pointer;
//   padding: 4px;
//   display: flex;
//   align-items: center;
//   justify-content: center;

//   &:hover {
//     color: white;
//   }
// `;


const DepositInfo = styled.div`
  background-color: #2A2D35;
  border-radius: 8px;
  padding: 16px;
  margin-bottom: 20px;
`;

const QRContainer = styled.div`
  background-color: white;
  padding: 16px;
  border-radius: 8px;
  width: fit-content;
  margin: 20px auto;
`;

const AddressContainer = styled.div`
  background-color: #2A2D35;
  border-radius: 8px;
  padding: 12px;
  margin-top: 20px;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const Address = styled.input`
  background: none;
  border: none;
  color: white;
  width: 100%;
  margin-right: 12px;
  outline: none;
  font-family: monospace;
`;

const CopyButton = styled.button`
  background: #f09c06;
  color: black;
  border: none;
  border-radius: 6px;
  padding: 8px 16px;
  font-weight: 600;
  cursor: pointer;
  
  &:hover {
    opacity: 0.9;
  }
`;


const Container = styled.div`
  display: flex;
  align-items: center;
  position: relative;
  max-width: 500px;
`;

const CoinSelector = styled.div`
 background: rgb(18, 20, 24);
  border-top-left-radius: 8px;
  border-bottom-left-radius: 8px;
  padding: 8px 12px;
  display: flex;
  align-items: center;
  gap: 8px;
  cursor: pointer;
  min-width: 120px;
  position: relative;
  box-shadow: 
    0 4px 6px rgba(0, 0, 0, 0.1),
    0 1px 3px rgba(0, 0, 0, 0.08),
    inset 0 1px 0 rgba(255, 255, 255, 0.1);
  transition: all 0.2s ease;

  &:hover {
    background-color: #2A2D35;
    box-shadow: 
      0 6px 8px rgba(0, 0, 0, 0.15),
      0 3px 6px rgba(0, 0, 0, 0.1),
      inset 0 1px 0 rgba(255, 255, 255, 0.15);
    // transform: translateY(-1px);
  }

  &:active {
    box-shadow: 
      0 2px 4px rgba(0, 0, 0, 0.1),
      inset 0 1px 2px rgba(0, 0, 0, 0.2);
    transform: translateY(1px);
  }
`;

const CoinIcon = styled.img`
  width: 24px;
  height: 24px;
`;

const CoinText = styled.div`
  color: white;
  font-size: 14px;
  font-weight: 500;
`;

const CreditAmount = styled.span`
  color: white;
  font-size: 14px;
  margin-right: 8px;
`;

const DepositButton = styled.div`
  background: #f09c06;
  color: black;
  border-radius: 0;
  font-weight: bold !important;
  border-top-right-radius: 8px;
  border-bottom-right-radius: 8px;
  // border: 2px solid rgb(58 65 66);
  padding: 9px 16px;
  @media (max-width: 768px) {
    padding: 5px 16px;
  }
  font-size: 14px;
  font-weight: 500;
  cursor: pointer;
  transition: all 0.2s ease;
  box-shadow: 
    0 4px 6px rgba(0, 0, 0, 0.1),
    0 1px 3px rgba(0, 0, 0, 0.08),
    inset 0 1px 0 rgba(255, 255, 255, 0.2);
  position: relative;

  &:hover {
    background-color: #f09c06;
    // transform: translateY(-1px);
    box-shadow: 
      0 6px 8px rgba(0, 0, 0, 0.15),
      0 3px 6px rgba(0, 0, 0, 0.1),
      inset 0 1px 0 rgba(255, 255, 255, 0.3);
  }

  &:active {
    transform: translateY(1px);
    box-shadow: 
      0 2px 4px rgba(0, 0, 0, 0.1),
      inset 0 1px 2px rgba(0, 0, 0, 0.2);
  }
`;

const DropdownContainer = styled.div`
  position: absolute;
  top: 100%;
  left: 0;
  margin-top: 8px;
  background: rgb(30, 35, 40);
  border-radius: 8px;
  width: 280px;
  max-height: 400px;
  overflow-y: auto;
  z-index: 1000;
  box-shadow: 
    0 4px 12px rgba(0, 0, 0, 0.2),
    0 1px 3px rgba(0, 0, 0, 0.1),
    inset 0 1px 0 rgba(255, 255, 255, 0.1);
  display: ${props => props.$show ? 'block' : 'none'};
`;

const SearchContainer = styled.div`
  padding: 12px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
  display: flex;
  align-items: center;
  gap: 5px;
`;

const SearchInput = styled.div`
  background: rgba(0, 0, 0, 0.2);
  border-radius: 8px;
  padding: 8px 12px;
  display: flex;
  align-items: center;
  gap: 8px;
  transition: all 0.2s ease;
  border: 1px solid rgba(255, 255, 255, 0.05);

  &:focus-within {
    background: rgba(0, 0, 0, 0.25);
    border-color: rgba(255, 255, 255, 0.1);
  }

  input {
    background: none;
    border: none;
    color: white;
    width: 100%;
    outline: none;
    font-size: 14px;
    &::placeholder {
      color: rgba(255, 255, 255, 0.5);
    }
  }
`;

const IconBg = styled.div`
  padding: 6px 8px;
  background: rgba(0, 0, 0, 0.2);
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.2s ease;
  border: 1px solid rgba(255, 255, 255, 0.05);

  &:hover {
    background: rgba(0, 0, 0, 0.25);
    border-color: rgba(255, 255, 255, 0.1);
    transform: translateY(-1px);
  }

  &:active {
    transform: translateY(1px);
  }
`;

const CoinList = styled.div`
  padding: 8px 0;
`;



const CoinItem = styled.div`
padding: 8px 12px;
display: flex;
align-items: center;
justify-content: space-between;
cursor: pointer;
transition: background-color 0.2s;

&:hover {
  background: rgba(0, 0, 0, 0.2);
  }
  
  ${props => props.$active && `
     background: rgba(0, 0, 0, 0.2);
    `}
    `;

const CoinItemLeft = styled.div`
    display: flex;
    align-items: center;
    gap: 8px;
    `;
// const IconBg = styled.div`
//       padding: 6px 8px;
//       background-color: #2A2D35;
//       border-radius:8px;
//       cursor:pointer;

//     `;

const DifferentAmount = styled.li`
  list-style: none;
  text-align: right;
  animation: fadeInDown 0.3s ease-in-out;
  margin: 4px 0;
  
  &.text-success {
    color: #00C087;
  }
  
  &.text-danger {
    color: #FF4136;
  }
  
  &.fadeOutDown {
    animation: fadeOutDown 0.3s ease-in-out;
  }
`;

const BJBInfoModal = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.7);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 1100;
  animation: fadeIn 0.2s ease-out;
  
  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
`;

const BJBInfoContent = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  padding: 24px;
  width: 90%;
  max-width: 350px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
  position: relative;
  animation: scaleIn 0.2s ease-out;
  
  @keyframes scaleIn {
    from { transform: scale(0.9); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
  }
`;

const CloseInfoButton = styled.button`
  position: absolute;
  top: 12px;
  right: 12px;
  background: none;
  border: none;
  color: rgba(255, 255, 255, 0.7);
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  
  &:hover {
    color: white;
  }
`;

const InfoTitle = styled.h4`
  color: white;
  margin: 0 0 8px 0;
  font-size: 16px;
  font-weight: 600;
  background: rgb(30, 35, 40);
  padding: 12px 16px;
  margin: -24px -24px 16px -24px;
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const InfoText = styled.p`
  color: rgba(255, 255, 255, 0.8);
  margin: 0;
  font-size: 14px;
  line-height: 1.5;
`;

const InfoIconWrapper = styled.span`
  display: inline-flex;
  align-items: center;
  margin-left: 6px;
  cursor: pointer;
  color: rgba(255, 255, 255, 0.7);
  
  &:hover {
    color: white;
  }
`;

function SkylaCredit(props) {
  const [show, setShow] = useState(false);
  const [token, setToken] = useState(storage.getKey('token'));
  const [coin, setCoinState] = useState(storage.getKey('coin') ? storage.getKey('coin') : 'BTC');
  const [activeClientCoins, setActiveClientCoins] = useState(storage.getKey('active_coins'));
  const [selectedCoin, setSelectedCoin] = useState(storage.getKey('coin') ? storage.getKey('coin') : 'BTC');
  const [credits, setCredits] = useState({});
  const [filteredCoins, setFilteredCoins] = useState([]);
  const [different, setDifferent] = useState([]);
  const [credit, setCreditState] = useState(false);
  const [usd] = useState(storage.getKey('usd') === "true" ? true : false);
  const [searchTerm, setSearchTerm] = useState("");
  const [showDepositModal, setShowDepositModal] = useState(false);
  const [showManage, setShowManage] = useState(false);
  const [depositAddress] = useState('1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa');
  const [showBJBInfoModal, setShowBJBInfoModal] = useState(false);
  const [showcoins,setshowcoins] =useState(true);
  const wrapperRef = useRef(null);
 const finalState = useSelector((state) => state.finalState.finalState) || {};

// const creditsState = credits || {};

const updateAllCoins = useCallback((newCoin = null) => {
const coinsToDisplay = coins
  .filter(item => 
    item.preffix === 'B7' || finalState?.[__.lowerCase(item.preffix)] === true
  )
  .map(item => ({
    preffix: item.preffix,
    image: item.image,
    value: forceSatoshiFormat(credits[__.lowerCase(item.preffix)] || 0),
    isActive: __.lowerCase(item.preffix) === __.lowerCase(newCoin || selectedCoin)
  }));


  console.log("Updated coins:", coinsToDisplay);
  console.log("Final state:", finalState);
  setFilteredCoins(coinsToDisplay);
}, [coins, finalState, credits, selectedCoin]);



// useEffect(() => {
//   if (Object.keys(finalState).length < 0) {
//     const timer = setTimeout(() => {
//       updateAllCoins();
//     }, 2000); // delay in ms
//     return () => clearTimeout(timer);
//   }
// }, [finalState, updateAllCoins]);

  

  useEffect(() => {
  if (token !== null) {
    socket.emit(C.CREDIT, encode({ token: token, coin: coin }));
  }
}, [token, coin]);
  // Effect: componentDidMount/componentWillUnmount
  useEffect(() => {
    props.gameCoin();
    // if (token !== null) {
    //   socket.emit(C.CREDIT, encode({ token: token, coin: coin }));
    // }
    const handleCredit = data => getCredit(decode(data));
    const handleUpdateCredit = data => updateCredit(decode(data));
    const handleActiveCoinsChanged = (activeCoins) => {
      setActiveClientCoins(activeCoins);
      updateAllCoins();
    };
    socket.on(C.CREDIT, handleCredit);
    socket.on(C.UPDATE_CREDIT, handleUpdateCredit);
    socket.on('active_coins_changed', handleActiveCoinsChanged);
    socket.on(C.USER_INFO, data => getUserInfo(decode(data)));
  
    // socket.on(C.USER_INFO, requestUserInfo);
    const handleClickOutside = (event) => {
      if (wrapperRef.current && !wrapperRef.current.contains(event.target)) {
        setShow(false);
      }
    };
   

    document.addEventListener('mousedown', handleClickOutside);
    return () => {
      document.removeEventListener('mousedown', handleClickOutside);
      socket.off(C.CREDIT, handleCredit);
      socket.off(C.UPDATE_CREDIT, handleUpdateCredit);
      socket.off('active_coins_changed', handleActiveCoinsChanged);
     socket.off(C.USER_INFO);
    };
    
    // eslint-disable-next-line
  }, [ props.gameCoin, updateAllCoins]);
 useEffect(() => {
    const onUpdate = e => {
      const updated = e.detail;
      setCreditState(updated);
      storage.setKey('credit', updated);
      props.setCredit(updated);
      updateAllCoins();  // refresh your dropdown UI
    };
    window.addEventListener('credit_update', onUpdate);
    return () => {
      window.removeEventListener('credit_update', onUpdate);
    };
  }, [updateAllCoins, props]);
  // Effect: update filtered coins when credits or selectedCoin changes
  useEffect(() => {
    updateAllCoins();
  }, [credits, selectedCoin, updateAllCoins]);

  // Handlers
  const toggleDepositModal = () => setShowDepositModal(v => !v);
  const toggleShowManage = () => setShowManage(v => !v);
  const toggleBJBInfoModal = () => setShowBJBInfoModal(v => !v);
  const copyToClipboard = () => {
    navigator.clipboard.writeText(depositAddress)
      .then(() => {
        // You could add a success notification here
      })
      .catch(err => {
        // Optionally handle error
      });
  };
  const getUserInfo = (data) => {
      //  console.log("helojuhchabsx", data.parent_id);

  if (typeof data.parent_id === 'number' && Number.isInteger(data.parent_id)) {
         setshowcoins(false);
        } else {
    setshowcoins(true);
  }
      
    };
 
  const getCredit = (data) => {
    let { credit: creditObj } = data;
    setCredits(creditObj);
    let currentCoin = __.lowerCase(props.coin);
    let currentCredit = forceSatoshiFormat(creditObj[currentCoin]);
    setCreditState(currentCredit);
    storage.setKey('credit', currentCredit);
    props.setCredit(currentCredit);
    updateAllCoins();
  };
  
  const updateCredit = (data) => {
    let creditVal = data.value;
    let coinName = data.coin;
    let diff, arr;
    if (__.toNumber(creditVal) > __.toNumber(credit)) {
      diff = __.toNumber(creditVal) - __.toNumber(credit);
      arr = { amount: diff, color: 'text-success' };
    } else {
      diff = __.toNumber(credit) - __.toNumber(creditVal);
      arr = { amount: diff, color: 'text-danger' };
    }
    let check = forceSatoshiFormat(diff);
    if (check.toString() !== '0.00000000') {
      setDifferent(state => [arr, ...state]);
    }
    creditVal = forceSatoshiFormat(creditVal);
    setCreditState(creditVal);
    storage.setKey('credit', creditVal);
    props.setCredit(creditVal);
  };
  const selectCoin = (name) => {
    if (storage.getKey('coin') === name) return;
    storage.setKey('coin', name);
    let creditVal = credits[__.lowerCase(name)];
    setCoinState(name);
    setShow(false);
    setCreditState(creditVal);
    setSelectedCoin(name);
    props.setCoin(name);
    props.setCredit(creditVal);
    wait(200).then(() => {
      Event.emit('coin_changed', name);
    });
  };
  const handleSearch = (e) => setSearchTerm(e.target.value);
  const toggleDropdown = () => setShow(v => !v);
  const addDiff = (data, i) => {
    let id = 'id_' + Math.floor(Math.random() * 1000 + 1);
    wait(2000).then(() => {
      try {
        document.getElementById(id).classList.remove('frd');
        document.getElementById(id).classList.add('fadeOutDown');
      } catch (e) { }
      setDifferent(state => {
        const arr = [...state];
        arr.splice(i, 1);
        return arr;
      });
    });
    return (
      <DifferentAmount key={i} id={id} className={`animated frd ${data.color}`}>
        {(data.color === 'text-danger' ? '-' : '+')}
        {forceSatoshiFormat(data.amount, coin)}
      </DifferentAmount>
    );
  };
  const handleCoinsUpdated = (activeCoins) => {
    setActiveClientCoins(activeCoins);
    updateAllCoins();
  };

  const formattedCredit = forceSatoshiFormat(credit, coin, usd);
  const diff = different.map((data, i) => addDiff(data, i));
    const displayedCoins = filteredCoins.filter(coinItem =>
      coinItem.preffix.toLowerCase().includes(searchTerm.toLowerCase())
    );

    return (
    <Container ref={wrapperRef}>
        <div style={{ position: 'absolute', top: '-20px', right: '0' }}>
          <ul>{diff}</ul>
        </div>

      <CoinSelector onClick={toggleDropdown}>
          <CoinIcon src={`/assets/images/${__.lowerCase(coin)}.png`} alt={coin} />
          <CreditAmount>
            {coin === 'INR' || coin === 'USDT'
              ? Number(formattedCredit).toFixed(2)
              : formattedCredit}
          </CreditAmount>
        {showcoins && (
          <ChevronDown size={16} color="white" />
        )}
        </CoinSelector>

      <DepositButton onClick={toggleDepositModal}>{
          isMobile() ? <div style={{ fontSize: '20px', fontWeight: 'bold' }}>+</div> : 'Deposit'
        }</DepositButton>

{showcoins && (
      <DropdownContainer $show={show}>
        {/* <SearchContainer>
          <SearchInput>
            <Search size={16} color="rgba(255, 255, 255, 0.5)" />
            <input
              type="text"
              placeholder="Search coins..."
              value={searchTerm}
              onChange={handleSearch}
            />
          </SearchInput>
          <IconBg onClick={toggleShowManage}>
            <Plus size={22} />
          </IconBg>
        </SearchContainer> */}
          <CoinList>
          {displayedCoins.map((coinItem, index) => (
                <CoinItem
                  key={index}
              onClick={() => selectCoin(coinItem.preffix)}
              $active={coinItem.preffix === coin}
                >
                  <CoinItemLeft>
                    <CoinIcon
                      src={`/assets/images/${coinItem.image}`}
                      alt={coinItem.preffix}
                    />
                    <CoinText>
                       {coinItem.preffix === "B7" ? "B7" : coinItem.preffix}
                      {coinItem.preffix === "B7" && (
                        <InfoIconWrapper onClick={(e) => {
                          e.stopPropagation();
                      toggleBJBInfoModal();
                        }}>
                          <Info size={12} />
                        </InfoIconWrapper>
                      )}
                    </CoinText>
                  </CoinItemLeft>
              <CreditAmount>
                {coinItem.value}
              </CreditAmount>
            </CoinItem>
          ))}
        </CoinList>
      </DropdownContainer>
)}
      <ModalOverlay $show={showDepositModal}>
          <ModalContent>
            <ModalHeader>
              <ModalTitle>Deposit </ModalTitle>
            <CloseButton onClick={toggleDepositModal}>
                <X size={24} />
              </CloseButton>
            </ModalHeader>
            <ModalBody>
              <SkylaDepositModal />
            </ModalBody>
          </ModalContent>
        </ModalOverlay>
        <SkylawWalletManage
        show={showManage}
        onHide={toggleShowManage}
        onCoinsUpdated={handleCoinsUpdated}
      />
      {showBJBInfoModal && (
        <BJBInfoModal onClick={toggleBJBInfoModal}>
            <BJBInfoContent onClick={(e) => e.stopPropagation()}>
            <CloseInfoButton onClick={toggleBJBInfoModal}>
                <X size={18} />
              </CloseInfoButton>
            <InfoTitle>About B7 Coin</InfoTitle>
              <InfoText style={{ color: '#EDCC06' }}>
              1 B7 = 1 USDT
                <br /><br />
              <span style={{ color: '#fff' }}>B7 (B7 Bonus) is a special bonus currency on our platform that can be earned through promotions, bonuses, and events. While it cannot be withdrawn, it can be used for betting on any game. Additionally, players have the option to exchange B7 for USDT.</span>
              </InfoText>
            </BJBInfoContent>
          </BJBInfoModal>
        )}
      </Container>
    );
}

SkylaCredit.propTypes = {
  setCoin: PropTypes.func.isRequired,
  coin: PropTypes.string
};

const mapStateToProps = state => ({
  coin: state.items.coin
});

export default connect(mapStateToProps, { setCoin, gameCoin, setCredit })(SkylaCredit);