import React, { useContext, useEffect, useLayoutEffect, useRef, useState } from 'react';
import styled from 'styled-components';
import { useHistory } from 'react-router-dom';
import Swal from 'sweetalert2';
import socket from '../../../../../Socket';
import C from '../../../../../Constant';
import { __, addNewStyle, CRISTP_ID, decode, defaultAvatar, encode, forceSatoshiFormat, getUID, sendNotfication, toUSD, wait } from '../../../../../Helper';
import storage from '../../../../../Storage';
import { ChevronRight, Heart, PencilIcon, Wallet2, X, Receipt, Upload, BadgeCheck, BadgeX } from 'lucide-react';
import NotificationsSkyla from '../../../../../Icons/Notifications';
import AffilateIcon from '../../../../../Icons/AffliateIcon';
import { Modal } from 'react-bootstrap';
import SkylaDepositModal from '../../../Wallet/Deposit/ModalContent';
import Cookies from 'js-cookie';
import { useSiteConfig } from '../../../../../hooks/useSiteConfig';
import { getVipLevelDetails } from '../../../VipClub/calculateLevel';
import { cleanupNotifications, getToken, onMessageListener } from '../../../../../services/firebase';
import axios from 'axios';
import { NotificationContext } from "../../../../../context/notificationcontext";
import BetHistoryModal from '../bethistorymodal';
import { useEvent } from '../../../../../contexts/EventContext';
import { toBase64 } from '../../../../../utils/fileUtils';

// Styled components remain the same as in your original code
const Container = styled.div`
  min-height: 90vh;
  width: 100%;
  color: white;
  background:rgb(18, 20, 24);
  position: fixed;
  top: 7%;
  left: 0;
  right: 0;
  bottom: 10%;
  z-index: 10;
  display: flex;
  flex-direction: column;
  overflow: hidden;
`;

const InnerContainer = styled.div`
  padding: 10px;
  flex: 1;
  overflow-y: auto;
  margin-top:-19px;
  -webkit-overflow-scrolling: touch;
  padding-bottom: 100px;
  &::-webkit-scrollbar { width: 6px; }
  &::-webkit-scrollbar-track { background: #2A2D35; border-radius: 3px; }
  &::-webkit-scrollbar-thumb { background: #454951; border-radius: 3px; }
`;

const BackButton = styled.div`
  position: absolute;
  top: 10px;
  right:4px;
  background:transparent;
  height:24px;
  width:24px;
  z-index:9999;
`;

const Header = styled.div`
  padding: 20px;
  padding-top: 31px;
  border-radius: 12px;
  margin-bottom: 20px;
  position: relative;
  flex-shrink: 0;
`;

const ProfileSection = styled.div`
  display: flex;
  align-items: center;
  gap: 12px;
  margin-bottom: 12px;
`;

const ProfileImage = styled.img`
  width: 48px;
  height: 48px;
  border-radius: 50%;
`;

const ProfileInfo = styled.div`
  h2 { font-size: 18px; margin: 0; font-weight: 500; color: white; }
  p { font-size: 14px; margin: 4px 0 0 0; opacity: 0.8; color: rgba(255, 255, 255, 0.8); }
`;

const Card = styled.div`
  background-color: #1B2326;
  border-radius: 12px;
  padding: 8px;
  margin-bottom: 2%;
`;

const CardN = styled.div`
  background-color:#f09c06;
  border-radius: 12px;
  padding: 8px 20px;
  margin-bottom: 16px;
`;

const ButtonGroup = styled.div`
  display: grid;
  grid-template-columns: repeat(2, 1fr);
  gap: 12px;
  margin-bottom: 16px;
`;

const ActionButton = styled.div.withConfig({
  shouldForwardProp: (prop) => prop !== 'primary'
})`
  background: ${props => props.primary ? '#f09c06' : 'transparent'};
  border: ${props => props.primary ? 'none' : '1px solid rgba(255, 255, 255, 0.2)'};
  color:${props => props.primary ? 'white' : 'white'};
  padding: 8px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  font-size: 12px;
  cursor: pointer;
  transition: opacity 0.2s;
  &:hover { opacity: 0.8; }
`;

const QuickActions = styled.div`
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  gap: 12px;
  margin-top: 16px;
`;

const QuickActionItem = styled.div`
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 8px;
`;

const ActionIcon = styled.img`
  width: 24px;
  height: 24px;
`;

const ActionText = styled.span`
  font-size: 12px;
  color: rgba(255, 255, 255, 0.8);
  text-align: center;
`;

const MenuItem = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 12px 0;
`;

const MenuLeft = styled.div`
  display: flex;
  align-items: center;
  gap: 12px;
`;

const MenuIcon = styled.img`
  width: 20px;
  height: 20px;
`;

const MenuText = styled.div`
  font-size: 16px;
  color: white;
`;

const MenuRight = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
`;

const StyledModal = styled(Modal)`
  .modal-content {
    background:rgb(18, 20, 24);
    border-radius: 15px;
    border: none;
    color: white;
    height:100vh;
    width:100%;
    margin-top:24px;
  }
  .modal-dialog {
    @media (min-width: 576px) { height:100vh; width:100%; }
    @media (min-width: 768px) { height:100vh; width:100%; }
    @media (min-width: 992px) { height:100vh; width:100%; }
  }
`;

const ModalHeader = styled(Modal.Header)`
  border-bottom: none;
  padding: 20px;
  background: rgb(30, 35, 40) !important;
  display: flex;
  justify-content: space-between;
  align-items: center;
  .close-button { background: none; border: none; color: white; cursor: pointer; }
`;

const ModalBody = styled(Modal.Body)`
  padding: 0 20px 20px;
  background:rgb(18, 20, 24);
`;

const ModalOverlay = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.$show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 99999;
`;

const ModalContent = styled.div`
  background:rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 470px;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  min-height: 400px;
  max-height: 76vh;
  display: flex;
  flex-direction: column;
  @media screen and (max-width: 768px) {
    width: 100%;
    height: 86vh;
    max-height: 76vh;
    min-height: 76vh;
    border-radius: 0;
  }
  @keyframes modalFadeIn {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
  }
`;

const ModalHeader1 = styled.div`
  display: grid;
  grid-template-columns: 24px 1fr 24px;
  align-items: center;
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
  flex-shrink: 0;
  background: rgb(30, 35, 40);
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const ModalTitle = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  text-align: center;
  grid-column: 2;
`;

const CloseButton = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  grid-column: 3;
  margin-left: auto;
  &:hover { color: white; }
`;

const ModalBody1 = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar { width: 6px; }
  &::-webkit-scrollbar-track { background: #2A2D35; border-radius: 3px; }
  &::-webkit-scrollbar-thumb { background: #454951; border-radius: 3px; }
  &::-webkit-scrollbar-thumb:hover { background: #555; }
`;

const StatBox = styled.div`
  background: rgb(18, 20, 24);
  padding: 15px;
  border-radius: 15px;
  text-align: center;
  .stat-label { color: #fff; font-size: 12px; margin-bottom: 5px; white-space: nowrap; }
  .stat-value { font-size: 14px; font-weight: bold; white-space: nowrap; }
`;

const InputContainer = styled.div`
  margin-bottom: 20px;
`;

const StyledButtonNew = styled.button`
  background: #f09c06;
  color: white;
  font-weight: bold;
  padding: 0.55rem 1rem;
  border-radius: 9999px;
  width: 100%;
  max-width: 20rem;
  margin-top: 10px;
  margin-bottom: 10px;
  transition: all 0.3s ease-in-out;
  &:hover { background-color: #56CF16; transform: scale(1.05); }
`;

const Label = styled.label`
  display: block;
  margin-bottom: 5px;
  font-size: 14px;
  color: #a0a0a0;
  font-family:normal;
`;

const Input = styled.input`
  width: 100%;
  padding: 10px;
  background-color: #25282C;
  border: 1px solid #3a3a3a;
  border-radius: 20px;
  color: #ffffff;
  font-size: 12px;
`;

const Pencil = styled.div`
  display:flex;
  justify-content:center;
  background-color:#1C1D21;
  padding: 0.75rem;
  border-radius:50%;
`;

const LogoutModal = styled(Modal)`
  .modal-content {
    background-color: #232626;
    border-radius: 15px;
    border: none;
    color: white;
    width: 100%;
    max-width: 400px;
    height: 235px;
    display: flex;
    flex-direction: column;
    margin: 0 auto;
  }
  @media (max-width: 576px) {
    .modal-content { max-width: 90%; margin: 0 auto; }
  }
`;

const ModalHeaderLogout = styled(Modal.Header)`
  border-bottom: none;
  padding: 10px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: relative;
  .close-button {
    background: none;
    border: none;
    color: white;
    cursor: pointer;
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
  }
  .header-title {
    width: 100%;
    text-align: center;
    font-size: 16px;
    font-weight: bold;
    color: white;
  }
`;

const LogoutModalBody = styled(Modal.Body)`
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-align: center;
  color: white;
  flex: 1;
  padding: 1rem;
`;

const LogoutButtonContainer = styled.div`
  display: flex;
  justify-content: center;
  margin-top: 20px;
  z-index: 100;
`;

const LogoutButton1 = styled.button`
  background-color: #F89C03;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  cursor: pointer;
  transition: background-color 0.3s;
  &:hover { background-color: #F89C03; }
`;

const LogoutButton2 = styled.div`
  background-color:transparent;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  cursor: pointer;
  transition: background-color 0.3s;
`;

const ProfileImageContainer = styled.div`
  position: relative;
  width: 90px;
  height: 90px;
  margin: 10px auto;
`;

const ProfileImageEdit = styled.div`
  position: absolute;
  bottom: 0;
  right: 0;
  background: rgba(59, 163, 100, 0.8);
  border-radius: 50%;
  width: 28px;
  height: 28px;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  transition: all 0.2s ease;
  &:hover { background: rgba(59, 163, 100, 1); }
`;

const HiddenFileInput = styled.input`
  display: none;
`;

const DEFAULT_AVATAR_PATH = "//img2.distributedresourcestorage.com/avatar/57268122/s?t=0";

const SkylaMobileUserProfile = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [showUserModal, setShowUserModal] = useState(false);
  const [showEditUi, setShowEditUi] = useState(false);
  const [showBetHistoryModal, setShowBetHistoryModal] = useState(false);
  const [openDeposit, setOpenDeposit] = useState(false);
  const menuRef = useRef(null);
  const buttonRef = useRef(null);
  const fileInputRef = useRef(null);
  const progressAnimationRef = useRef(null);
  const history = useHistory();

  const currentName = storage.getKey('name') || 'Guest';
  const [level, setLevel] = useState(1);
  const [displayUid] = useState(getUID());
  const [name, setName] = useState(currentName);
  const [haveData, setHaveData] = useState('');
  const [data, setData] = useState([]);
  const [vipDetails, setVipDetails] = useState(null);
  const [wageredAmount, setWageredAmount] = useState(null);
  const [isUpdatingUsername, setIsUpdatingUsername] = useState(false);
  const [newUsername, setNewUsername] = useState(currentName);
  const [updateError, setUpdateError] = useState(null);
  const [loaded, setLoaded] = useState(false);
  const [showLogoutModal, setShowLogoutModal] = useState(false);
  const [isUploadingImage, setIsUploadingImage] = useState(false);
  const [stats, setStats] = useState({ betCount: null, winCount: null });
  const { siteConfig } = useSiteConfig();
  const { avatarUrl, updateAvatar } = useEvent();
  const { showNotification } = useContext(NotificationContext);
  const API_BASE_URL = 'https://api.boss707.com/kyc';
  const [kycStatus, setKycStatus] = useState('Unverified');
  const [errors, setErrors] = useState({});
  const getValidAvatarUrl = (url) => {
    if (!url || typeof url !== 'string') return DEFAULT_AVATAR_PATH;
    if (url.startsWith('https') || url.startsWith('localhost') || url.startsWith('http')) {
      return DEFAULT_AVATAR_PATH;
    }
    return url;
  };

  const displayAvatarUrl = getValidAvatarUrl(avatarUrl);
  const getAuthToken = () => {
    return localStorage.getItem('token');
  };
  // Removed debug console.log to clean up console output
  const token = getAuthToken();
  // Fetch KYC status on component initialization
  useEffect(() => {
    const fetchKycStatus = async () => {
      try {
        const response = await axios.get(
          `${API_BASE_URL}/status/${getUID()}`,
          {
            headers: {
              Authorization: `Bearer ${token}`
            }
          }
        );
        setKycStatus(response.data.status);

        // If there's a rejection reason, store it
        if (response.data.rejectionReason) {
          setErrors((prev) => ({
            ...prev,
            submit: response.data.rejectionReason
          }));
        }
      } catch (error) {
        console.error("Error fetching KYC status:", error);
        sendNotfication("Failed to fetch KYC status");
      }
    };

    fetchKycStatus();

    if (kycStatus === "Pending") {
      const interval = setInterval(fetchKycStatus, 30000);
      return () => clearInterval(interval);
    }
  }, [kycStatus]);

  useEffect(() => {


    const fetchBetWinCount = async () => {
      try {
        const token = localStorage.getItem('token');
        const response = await fetch(`https://api.boss707.com/betHistory/user/${getUID()}/bet-win-count`, {
          method: 'GET',
          headers: {
            Authorization: `Bearer ${token}`,
            'Content-Type': 'application/json',
          },
        });
        if (!response.ok) {
          throw new Error('Failed to fetch bet and win counts');
        }
        const data = await response.json();
        setStats({
          betCount: data.betCount || 0,
          winCount: data.winCount || 0
        });
      } catch (err) {
        console.error('Error fetching bet and win counts:', err);
        setStats({ betCount: 0, winCount: 0 });
      }
    };

    fetchBetWinCount();
  }, []);
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (menuRef.current && !menuRef.current.contains(event.target) &&
        buttonRef.current && !buttonRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    };
    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  const handleUserInfoClick = () => {
    socket.emit(C.USER_INFO, encode({
      id: getUID(),
      coin: storage.getKey('coin') || '',
      rate: null,
      game: 'all',
      first: true
    }));
  };
  useLayoutEffect(() => {
    // Fetch user info immediately on mount
    handleUserInfoClick();

    // Listen for socket response
    socket.on(C.USER_INFO, (encodedData) => {
      const decodedData = decode(encodedData);
      getUserInfo(decodedData);
    });

    // Cleanup
    return () => {
      if (progressAnimationRef.current) cancelAnimationFrame(progressAnimationRef.current);
      socket.off(C.USER_INFO);
    };
  }, []); // Empty dependency array ensures this runs only once on mount

  const handleLogout = () => {
    socket.emit(C.LOGOUT_USER);
    localStorage.clear();
    Cookies.remove('session');
    Cookies.remove('auth');
    Cookies.remove('uid');
    cleanupNotifications();
    window.location.replace('./');
  };

  const handleUsernameChange = (event) => {
    setNewUsername(event.target.value);
  };

  const updateUsername = async () => {
    if (!newUsername.trim()) {
      setUpdateError('Username cannot be empty');
      return;
    }
    setIsUpdatingUsername(true);
    setUpdateError(null);
    const token = localStorage.getItem('token');
    try {
      const response = await fetch('https://api.boss707.com/editProfile', {
        method: 'PUT',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
        },
        body: JSON.stringify({ uid: displayUid, username: newUsername.trim() })
      });

      if (!response.ok) throw new Error('Failed to update username');
      const data = await response.json();
      storage.setKey('name', newUsername);
      setName(newUsername);
      setShowEditUi(false);
      socket.emit(C.USER_INFO, encode({
        id: getUID(),
        coin: storage.getKey('coin') || '',
        rate: null,
        game: 'all',
        first: true
      }));
    } catch (error) {
      setUpdateError('Failed to update username. Please try again.');
    } finally {
      setIsUpdatingUsername(false);
    }
  };

  const getUserInfo = (data) => {
    if (data.status) {
      setHaveData('ok');
      setData(data);
      let amount = parseFloat(data?.profit).toFixed(4);
      if (amount) {
        setWageredAmount(amount);
        const vipInfo = getVipLevelDetails(amount);
        setVipDetails(vipInfo);
      }
    } else {
      setHaveData('notFound');
    }
  };

  const support = () => {
    window.$crisp = [];
    window.CRISP_WEBSITE_ID = CRISTP_ID;

    // Set configuration
    window.$crisp.push(["config", "container:fullpage", true]);
    window.$crisp.push(["config", "position:reverse", true]);
    window.$crisp.push(["config", "hide:on:mobile", false]);
    window.$crisp.push(["config", "button:hide", true]);

    if (!loaded) {
      console.log("support");
      setLoaded(true);

      const script = document.createElement('script');
      script.src = "https://client.crisp.chat/l.js";
      script.id = "chtt";
      script.async = true;

      script.onload = function () {
        setTimeout(() => {
          window.$crisp.push(["do", "chat:open"]);

          // Apply styles
          const crispStyles = `
            .crisp-client .cc-1xry { display: none !important; }
            .crisp-client .cc-kv6t { visibility: visible !important; opacity: 1 !important; display: block !important; }
            .crisp-client .cc-k5k0 { visibility: visible !important; opacity: 1 !important; display: block !important; }
            @media screen and (max-width: 768px) {
              #crisp-chatbox { display: block !important; z-index: 1000000 !important; }
              .crisp-client .cc-kv6t { max-height: 100% !important; height: 100% !important; }
            }
          `;

          const styleSheet = document.createElement("style");
          styleSheet.id = "crisp-custom-styles";
          styleSheet.innerText = crispStyles;
          document.head.appendChild(styleSheet);
        }, 1000);
      };

      document.head.appendChild(script);
    } else {
      window.$crisp.push(["do", "chat:open"]);
    }

    addNewStyle("#crisp-chatbox { display: block !important; }");
    addNewStyle(".crisp-client .cc-1xry { display: none !important; }");

    // Enhanced close button handler
    wait(2000).then(() => {
      const close = document.querySelector(".cc-wdhl");
      if (close === null) return;
      close.addEventListener("click", function (event) {
        // Hide the chat window
        addNewStyle("#crisp-chatbox { display: none !important; }");

        // Completely hide all Crisp elements including the icon
        addNewStyle(".crisp-client { display: none !important; visibility: hidden !important; }");
        addNewStyle(".crisp-client .cc-1xry { display: none !important; visibility: hidden !important; }");

        // Properly clean up the Crisp instance
        window.$crisp.push(["do", "chat:hide"]);
        window.$crisp.push(["do", "session:reset"]);

        // Remove the script to completely unload Crisp
        const crispScript = document.getElementById("chtt");
        if (crispScript) {
          crispScript.remove();
        }

        // Remove any custom styles
        const customStyles = document.getElementById("crisp-custom-styles");
        if (customStyles) {
          customStyles.remove();
        }

        // Set loaded state back to false
        setLoaded(false);
      });
    });
  };

  useLayoutEffect(() => {
    socket.on(C.USER_INFO, data => getUserInfo(decode(data)));
    return () => {
      if (progressAnimationRef.current) cancelAnimationFrame(progressAnimationRef.current);
      socket.off(C.USER_INFO);
    };
  }, []);

  const handleTransactionsClick = () => history.push("/transactions");
  const handleBetHistoryClick = () => setShowBetHistoryModal(true);
  const handleCloseBetHistoryModal = () => setShowBetHistoryModal(false);
  const handleSupportClick = () => support();
  const handleAffiliateClick = () => history.push("/affiliate");
  const handleWalletClick = () => history.push("/wallet");
  const handleSwapClick = () => history.push("/swap");
  const handleGlobalSettingsClick = () => history.push("/global-settings");
  const handleLogoutClick = () => setShowLogoutModal(true);

  const handleImageClick = () => fileInputRef.current.click();

  const handleImageChange = async (e) => {
    const file = e.target.files[0];
    if (!file) return;

    if (file.size > 2 * 1024 * 1024) {
      sendNotfication('Image too large. Maximum size is 2MB.', 'danger', 'top-center');
      return;
    }

    if (!file.type.match('image.*')) {
      sendNotfication('Please select an image file.', 'danger', 'top-center');
      return;
    }

    try {
      setIsUploadingImage(true);
      const base64 = await toBase64(file);
      updateAvatar(base64);
      sendNotfication('Avatar updated successfully!', 'success', 'top-center');
    } catch (error) {
      console.error('Error updating avatar:', error);
      sendNotfication('Failed to update avatar. Please try again.', 'danger', 'top-center');
    } finally {
      setIsUploadingImage(false);
    }
  };

  return (
    <Container>
      <BackButton onClick={() => history.goBack()}>
        <X size={20} />
      </BackButton>
      <Header>
        <div style={{ width: "100%", display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
          <ProfileSection>
            <ProfileImage
              src={displayAvatarUrl}
              alt="Profile"
              onError={(e) => {
                e.target.onerror = null;
                e.target.src = DEFAULT_AVATAR_PATH;
              }}
            />
            <ProfileInfo>
              <div style={{ display: 'flex', alignItems: 'center', gap: '8px' }}>
                <h2>{name}</h2>
                {/* Static check - you can replace true with your actual condition later */}
                {kycStatus === "Verified" ? (
                  <span
                    style={{
                      display: 'flex',
                      alignItems: 'center',
                      gap: '4px',
                      // backgroundColor: '#2ecc71',
                      color: 'white',
                      padding: '2px 6px',
                      borderRadius: '4px',
                      fontSize: '12px',
                      fontWeight: '500'
                    }}
                  >
                    <img src="/assets/images/verified-account.png" style={{ width: '24px', objectFit: 'contain' }} />
                    <div style={{ border: '1px solid rgba(255, 255, 255, 0.2)', padding: '4px 8px', borderRadius: '8px' }}>

                      Verified
                    </div>
                  </span>
                ) : (
                  <span
                    onClick={() => {
                      history.push("/global-settings");
                      setShowUserModal(false);
                    }}
                    style={{
                      display: 'flex',
                      alignItems: 'center',
                      gap: '4px',
                      // backgroundColor: '#e74c3c',
                      color: 'white',
                      padding: '2px 6px',
                      borderRadius: '4px',
                      fontSize: '12px',
                      fontWeight: '500',
                      cursor: 'pointer'

                    }}
                  >
                    <img src="/assets/images/unverified-account.png" style={{ width: '24px', objectFit: 'contain' }} />
                    <div style={{ border: '1px solid rgba(255, 255, 255, 0.2)', padding: '4px 8px', borderRadius: '8px' }}>

                      Unverified
                    </div>
                  </span>
                )}
              </div>
              <p>ID:{getUID()}</p>
            </ProfileInfo>
          </ProfileSection>
          <div style={{ border: '1px solid rgba(255, 255, 255, 0.2)', padding: '4px 8px', borderRadius: '8px' }} onClick={() => setShowUserModal(!showUserModal)}>
            <ChevronRight />
          </div>
        </div>
      </Header>

      <InnerContainer>
        <Card>
          <ButtonGroup>
            <ActionButton onClick={() => setOpenDeposit(!openDeposit)} primary>Deposit</ActionButton>
            <ActionButton onClick={() => history.push('/withdraw-mobile')}>Withdraw</ActionButton>
          </ButtonGroup>
          <QuickActions>
            <QuickActionItem onClick={handleTransactionsClick}>
              <Receipt color="#fff" size={24} />
              <ActionText>Transactions</ActionText>
            </QuickActionItem>
            <QuickActionItem onClick={handleBetHistoryClick}>
              <ActionIcon src="/assets/images/nanoicons/transactions.png" alt="Bet History" />
              <ActionText>Bet History</ActionText>
            </QuickActionItem>
            <QuickActionItem onClick={handleSwapClick}>
              <ActionIcon src="/assets/images/nanoicons/nanoswap.png" alt="Swap" />
              <ActionText>Swap</ActionText>
            </QuickActionItem>
            <QuickActionItem onClick={handleWalletClick}>
              <Wallet2 color="#fff" size={24} />
              <ActionText>Wallet</ActionText>
            </QuickActionItem>
          </QuickActions>
        </Card>

        <Card>
          <MenuItem onClick={handleAffiliateClick}>
            <MenuLeft>
              <AffilateIcon />
              <MenuText>Affiliate</MenuText>
            </MenuLeft>
          </MenuItem>
        </Card>
        <Card>
          <MenuItem onClick={() => history.push('/notification')}>
            <MenuLeft>
              <NotificationsSkyla />
              <MenuText>Notification</MenuText>
            </MenuLeft>
          </MenuItem>
        </Card>
        <Card>
          <MenuItem onClick={handleGlobalSettingsClick}>
            <MenuLeft>
              <MenuIcon src="/assets/images/normal-seetings.png" alt="Settings" />
              <MenuText>Global Setting</MenuText>
            </MenuLeft>
          </MenuItem>
        </Card>
        <Card>
          <MenuItem onClick={handleSupportClick}>
            <MenuLeft>
              <MenuIcon src="/assets/images/nanoicons/liveSupport.png" alt="Support" />
              <MenuText>Live Support</MenuText>
            </MenuLeft>
          </MenuItem>
        </Card>
        <div style={{ width: '100%', display: 'flex', justifyContent: 'center' }}>
          <CardN onClick={handleLogoutClick}>
            <MenuLeft>
              <MenuText style={{ fontWeight: "bold" }}>Logout</MenuText>
            </MenuLeft>
          </CardN>
        </div>
      </InnerContainer>

      <StyledModal show={showUserModal} onHide={() => setShowUserModal(false)} centered>
        <ModalHeader>
          <div style={{ fontSize: '16px', fontWeight: 'bold' }}>User Profile</div>
          <button className="close-button" onClick={() => { setShowUserModal(false); setShowEditUi(false); }}>
            <X size={24} />
          </button>
        </ModalHeader>
        <ModalBody>
          {showEditUi ? (
            <div style={{ width: "100%", height: '50vh' }}>
              <ProfileImageContainer>
                <img

                  style={{ width: '90px', height: '90px', borderRadius: '50%' }}
                  src={displayAvatarUrl}
                  onError={(e) => {
                    e.target.onerror = null;
                    e.target.src = DEFAULT_AVATAR_PATH;
                  }}
                />
                <ProfileImageEdit onClick={handleImageClick}>
                  {isUploadingImage ? (
                    <div className="spinner-border spinner-border-sm text-white" role="status">
                      <span className="sr-only">Loading...</span>
                    </div>
                  ) : (
                    <Upload size={14} color="white" />
                  )}
                </ProfileImageEdit>
                <HiddenFileInput
                  type="file"
                  ref={fileInputRef}
                  onChange={handleImageChange}
                  accept="image/*"
                />
              </ProfileImageContainer>
              <InputContainer>
                <Label>Username</Label>
                <Input
                  type="text"
                  value={newUsername}
                  onChange={handleUsernameChange}
                  placeholder="Enter new username"
                  disabled={isUpdatingUsername}
                />
              </InputContainer>
              <Label>Do not use special punctuation, otherwise your account may not be supported.</Label>
              <div style={{ width: '100%', display: 'flex', justifyContent: 'center' }}>
                <StyledButtonNew
                  type="button"
                  onClick={updateUsername}
                  disabled={isUpdatingUsername}
                >
                  {isUpdatingUsername ? 'Updating...' : 'Modify'}
                </StyledButtonNew>
              </div>
            </div>
          ) : (
            <div style={{ padding: '20px 0' }}>
              <div style={{ textAlign: 'center', marginBottom: '20px' }}>
                <ProfileImageContainer>
                  <img
                    src={displayAvatarUrl}
                    style={{ width: '100px', height: '100px', borderRadius: '50%', marginBottom: '10px' }}
                    alt="Profile"
                    onError={(e) => {
                      e.target.onerror = null;
                      e.target.src = DEFAULT_AVATAR_PATH;
                    }}
                  />
                  {/* <ProfileImageEdit onClick={() => setShowEditUi(true)}>
                    <PencilIcon size={14} color="white" />
                  </ProfileImageEdit> */}
                </ProfileImageContainer>
                <h3>{name}</h3>
                {/* <div style={{ display: 'flex', justifyContent: 'center', gap: '10px', alignItems: "center" }}>
                  <Heart size={16} color="#ff6b6b" />
                  <span>Level {data.level || 0}</span>
                </div> */}
              </div>
              <div style={{ background: 'rgb(30, 35, 40)', padding: '20px', borderRadius: '15px', marginTop: '20px' }}>
                <h4 style={{ marginBottom: '15px', color: "white" }}>Statistics</h4>
                <div style={{ display: 'grid', gridTemplateColumns: '1fr', gap: '10px' }}>
                  <StatBox>
                    <div className="stat-label">Total Wins</div>
                    <div className="stat-value">
                      {haveData === 'ok' ? (stats.winCount || 0) : <span className="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>}
                    </div>
                  </StatBox>
                  <StatBox>
                    <div className="stat-label">Total Bets</div>
                    <div className="stat-value">
                      {haveData === 'ok' ? (stats.betCount || 0) : <span className="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>}
                    </div>
                  </StatBox>
                  <StatBox>
                    <div className="stat-label">Total Wagered</div>
                    <div className="stat-value">
                      {haveData === 'ok' ? (data.profit || 0) : <span className="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>}
                    </div>
                  </StatBox>
                </div>
              </div>
            </div>
          )}
        </ModalBody>
      </StyledModal>

      <ModalOverlay $show={openDeposit}>
        <ModalContent>
          <ModalHeader1>
            <ModalTitle>Deposit</ModalTitle>
            <CloseButton onClick={() => setOpenDeposit(!openDeposit)}>
              <X size={24} />
            </CloseButton>
          </ModalHeader1>
          <ModalBody1>
            <SkylaDepositModal />
          </ModalBody1>
        </ModalContent>
      </ModalOverlay>

      <LogoutModal show={showLogoutModal} onHide={() => setShowLogoutModal(false)} centered>
        <ModalHeaderLogout>
          <div className="header-title">Sign Out</div>
          <button className="close-button" onClick={() => setShowLogoutModal(false)}>
            <X size={20} color="white" />
          </button>
        </ModalHeaderLogout>
        <LogoutModalBody>
          <div style={{ display: 'flex', flexDirection: 'column', alignItems: 'center', justifyContent: 'center', height: '100%', padding: '0 1rem' }}>
            <p style={{ fontSize: '14px', marginBottom: '1rem', color: 'white', textAlign: 'center' }}>
              Are you sure you want to log out? Check our great promotions and bonuses before you leave!
            </p>
            <LogoutButtonContainer>
              <LogoutButton2 onClick={() => setShowLogoutModal(false)}>Cancel</LogoutButton2>
              <LogoutButton1 onClick={handleLogout}>Sign Out</LogoutButton1>
            </LogoutButtonContainer>
          </div>
        </LogoutModalBody>
      </LogoutModal>

      <BetHistoryModal show={showBetHistoryModal} onHide={handleCloseBetHistoryModal} />
    </Container>
  );
};

export default SkylaMobileUserProfile;