import React, { useState, useEffect, useRef, useLayoutEffect } from 'react';
import { Heart, PencilIcon, UserRound, Wallet2, X, Receipt, Upload } from 'lucide-react';
import { Dropdown, Modal, Button, Col } from "react-bootstrap";
import { Link, useHistory } from 'react-router-dom';
import styled from 'styled-components';
import Cookies from 'js-cookie';
import Swal from 'sweetalert2';
import socket from '../../../../Socket';
import C from "../../../../Constant";
import { __, addNewStyle, CRISTP_ID, decode, defaultAvatar, encode, getUID, sendNotfication, toUSD, wait } from "../../../../Helper";
import storage from '../../../../Storage';
import { getVipLevelDetails } from '../../VipClub/calculateLevel';
import { useSiteConfig } from '../../../../hooks/useSiteConfig';
import BetHistoryModal from './bethistorymodal';
import { useEvent } from '../../../../contexts/EventContext';
import { toBase64 } from '../../../../utils/fileUtils';
import axios from 'axios';
// Styled components remain unchanged
const Container = styled.div`
  position: relative;
  display: inline-block;
`;

const MenuText = styled.div`
  color: #BCC7CB;
  font-size: 16px;
`;

const ProfileButton = styled.button`
  background: transparent;
  border: none;
  cursor: pointer;
  padding: 8px;
`;

const ProfileImage = styled.img`
  height: 30px;
  width: 30px;
  border-radius: 50%;
  object-fit: contain;
`;

const MenuPopover = styled.div`
  position: absolute;
  top: 100%;
  right: 0;
  background-color: #03030F;
  border-radius: 12px;
  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.25);
  padding: 8px;
  width: 250px;
  z-index: 100;

  @media (max-width: 768px) {
    position: fixed;
    left: 0;
    right: 0;
    top: 10%;
    bottom: 0;
    width: 100%;
    max-width: 100%;
    border-radius: 12px 12px 0 0;
    max-height: 100vh;
    overflow-y: auto;
  }
`;

const IconWrapper = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  width: 18px;
  height: 18px;
  margin-right: 7px;
  
  img {
    filter: brightness(0) invert(1);
    transition: filter 0.2s ease-in-out;
  }
`;

const MenuItem = styled.div`
  display: flex;
  align-items: center;
  padding: 0.58rem 1rem;
  border-radius: 8px;
  cursor: pointer;
  transition: background-color 0.2s ease;

  &:hover {
    background: rgb(30, 35, 40);
    
    ${MenuText} {
      color: white;
    }
    
    ${IconWrapper} {
      img {
        filter: brightness(0) invert(1);
      }
    }
  }
`;

const StyledImg = styled.img`
  height: 18px;
  width: 18px;
  filter: brightness(0) invert(1);
`;

const StyledIcon = styled.img`
  height: 18px;
  width: 18px;
  filter: brightness(0) invert(1);
`;

const StyledLink = styled(Link)`
  text-decoration: none;
  color: inherit;

  &:hover {
    text-decoration: none;
  }
`;

const StyledNew = styled.div`
  text-decoration: none;
  color: inherit;
  cursor: pointer;

  &:hover {
    text-decoration: none;
  }
`;

const StyledModal = styled(Modal)`
  .modal-content {
    background-color: #17181B;
    border-radius: 15px;
    border: none;
    color: white;
  }
  .modal-dialog {
    @media (min-width: 576px) {
      max-width: 90%;
      width: 320px;
    }
    @media (min-width: 768px) {
      max-width: 85%;
      width: 350px;
    }
    @media (min-width: 992px) {
      max-width: 80%;
      width: 380px;
    }
  }
`;

const ModalHeader = styled(Modal.Header)`
  border-bottom: none;
  padding: 15px;
  display: flex;
  background: rgb(30, 35, 40) !important;
  justify-content: space-between;
  align-items: center;
  position: relative;
  
  .close-button {
    background: none;
    border: none;
    color: white;
    cursor: pointer;
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
  }

  .header-title {
    width: 100%;
    text-align: center;
    font-size: 16px;
    font-weight: bold;
    color: white;
  }
`;

const ModalHeaderLogout = styled(Modal.Header)`
  border-bottom: none;
  padding: 10px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: relative;
  
  .close-button {
    background: none;
    border: none;
    color: white;
    cursor: pointer;
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
  }

  .header-title {
    width: 100%;
    text-align: center;
    font-size: 16px;
    font-weight: bold;
    color: white;
  }
`;

const ModalBody = styled(Modal.Body)`
  padding: 0 15px 15px;
  background-color: #03030F;
`;

const StatBox = styled.div`
  background: rgb(18, 20, 24);
  padding: 10px;
  border-radius: 12px;
  text-align: center;
  
  .stat-label {
    color: #fff;
    font-size: 11px;
    margin-bottom: 3px;
    white-space: nowrap;
  }
  
  .stat-value {
    font-size: 12px;
    font-weight: bold;
    white-space: nowrap;
  }
`;

const MobileCloseButton = styled.button`
  display: none;
  @media (max-width: 768px) {
    display: flex;
    position: absolute;
    top: 10px;
    right: 10px;
    background: rgba(255,255,255,0.1);
    border: none;
    border-radius: 10%;
    padding: 8px;
    z-index: 101;
  }
`;

const InputContainer = styled.div`
  margin-bottom: 20px;
`;

const StyledButtonNew = styled.button`
  background: #f09c06;
  color: white;
  font-weight: bold;
  padding: 0.55rem 1rem;
  border-radius: 9999px;
  width: 100%;
  margin-top: 10px;
  margin-bottom: 10px;
  max-width: 20rem;
  transition: all 0.3s ease-in-out;

  &:hover {
    background: #f09c06;
    transform: scale(1.05);
  }
`;

const Label = styled.label`
  display: block;
  margin-bottom: 5px;
  font-size: 14px;
  color: #a0a0a0;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const Input = styled.input`
  width: 100%;
  padding: 10px;
  background: rgba(0, 0, 0, 0.2);
  border: 1px solid #3a3a3a;
  border-radius: 20px;
  color: #ffffff;
  font-size: 12px;
`;

const Pencil = styled.div`
  display: flex;
  justify-content: center;
  background-color: #1C1D21;
  padding: 0.75rem;
  border-radius: 50%;
`;

const UserContainer = styled.div`
  display: flex;
  justify-content: space-between;
  gap: 5px;
  padding: 5px;
`;

const LogoutModal = styled(Modal)`
  .modal-content {
    background-color: #232626;
    border-radius: 15px;
    border: none;
    color: white;
    width: 600px;
    height: 200px;
  }
`;

const LogoutModalBody = styled(Modal.Body)`
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  text-align: center;
  color: white;
`;

const LogoutButtonContainer = styled.div`
  display: flex;
  gap: 1rem;
  margin-top: 1.5rem;
`;

const LogoutButton = styled.button`
  padding: 0.5rem 1.5rem;
  border-radius: 8px;
  border: none;
  cursor: pointer;
  font-weight: bold;
  font-size: 14px;
  transition: all 0.2s ease;

  &.cancel {
    background-color: #373E3F;
    color: white;
    &:hover {
      background-color: #3A3D45;
    }
  }

  &.signout {
    font-weight: 800;
    background: #F89C03;
    color: white;
  }
`;

const DEFAULT_AVATAR_PATH = "//img2.distributedresourcestorage.com/avatar/57268122/s?t=0";

const ProfileImageContainer = styled.div`
  position: relative;
  width: 90px;
  height: 90px;
  margin: 10px auto;
`;

const ProfileImageEdit = styled.div`
  position: absolute;
  bottom: 0;
  right: 0;
  background: rgba(59, 163, 100, 0.8);
  border-radius: 50%;
  width: 28px;
  height: 28px;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  transition: all 0.2s ease;
  
  &:hover {
    background: rgba(59, 163, 100, 1);
  }
`;

const HiddenFileInput = styled.input`
  display: none;
`;

const ProfileMenu = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [showUserModal, setShowUserModal] = useState(false);
  const [showBetHistoryModal, setShowBetHistoryModal] = useState(false);
  const [showEditUi, setShowEditUi] = useState(false);
  const menuRef = useRef(null);
  const buttonRef = useRef(null);

  const history = useHistory();
  const progressAnimationRef = useRef(null);
  const currentName = storage.getKey('name') !== undefined ? storage.getKey('name') : 'Guest';

  const [level, setLevel] = useState(1);
  const [isOpenMenu, setIsOpenMenu] = useState(false);
  const [displayUid] = useState(getUID());
  const [name, setName] = useState(currentName);
  const [avatar] = useState(defaultAvatar);
  const [showPopup, setShowPopup] = useState(false);
  const [showPopupUserProfile, setShowPopupUserProfile] = useState(false);
  const [showPopupUserProfileStatistics, setShowPopupUserProfileStatistics] = useState(false);
  const [showWalletModal, setShowWalletModal] = useState(false);
  const [showCurrencyModal, setShowCurrencyModal] = useState(false);
  const [activeSection, setActiveSection] = useState('deposit');
  const [haveData, setHaveData] = useState('');
  const [data, setData] = useState({ wined: 0, played: 0, profit: 0 }); // Initialize with default values
  const [currentLevel, setCurrentLevel] = useState('vip 0');
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [nextLevel, setNextLevel] = useState('vip 1');
  const [progress, setProgress] = useState(0);
  const [xpNeeded, setXpNeeded] = useState(1);
  const [currentXP, setCurrentXP] = useState(0);
  const [vipDetails, setVipDetails] = useState(null);
  const [wageredAmount, setWageredAmount] = useState(null);
  const [isUpdatingUsername, setIsUpdatingUsername] = useState(false);
  const [newUsername, setNewUsername] = useState(currentName);
  const [updateError, setUpdateError] = useState(null);
  const [loaded, setLoaded] = useState(false);
  const [showLogoutModal, setShowLogoutModal] = useState(false);
  const [isAffiliateEnabled, setIsAffiliateEnabled] = useState(false);
  const [stats, setStats] = useState({ betCount: null, winCount: null });
  const { siteConfig } = useSiteConfig();
  const { avatarUrl, updateAvatar } = useEvent();
  const API_BASE_URL = 'https://api.boss707.com/kyc';

  const [kycStatus, setKycStatus] = useState('Unverified');
  const [errors, setErrors] = useState({});

  const getValidAvatarUrl = (url) => {
    if (!url || typeof url !== 'string') return DEFAULT_AVATAR_PATH;
    if (url.startsWith('https') || url.startsWith('localhost') || url.startsWith('http')) {
      return DEFAULT_AVATAR_PATH;
    }
    return url;
  };

  const displayAvatarUrl = getValidAvatarUrl(avatarUrl);
  const getAuthToken = () => {
    return localStorage.getItem('token');
  };

  const token = getAuthToken();

  useEffect(() => {
    const fetchKycStatus = async () => {
      try {
        const response = await axios.get(
          `${API_BASE_URL}/status/${getUID()}`,
          {
            headers: {
              Authorization: `Bearer ${token}`
            }
          }
        );
        setKycStatus(response.data.status);

        // If there's a rejection reason, store it
        if (response.data.rejectionReason) {
          setErrors((prev) => ({
            ...prev,
            submit: response.data.rejectionReason
          }));
        }
      } catch (error) {
        console.error("Error fetching KYC status:", error);
        sendNotfication("Failed to fetch KYC status");
      }
    };

    fetchKycStatus();

    if (kycStatus === "Pending") {
      const interval = setInterval(fetchKycStatus, 30000);
      return () => clearInterval(interval);
    }
  }, [kycStatus]);
  // Fetch user info on component mount
  useEffect(() => {


    const fetchBetWinCount = async () => {


      try {
        const token = getAuthToken();
        const response = await fetch(`https://api.boss707.com/betHistory/user/${getUID()}/bet-win-count`, {
          method: 'GET',
          headers: {
            Authorization: `Bearer ${token}`,
            'Content-Type': 'application/json',
          },
        });
        if (!response.ok) {
          throw new Error('Failed to fetch bet and win counts');
        }
        const data = await response.json();
        setStats({
          betCount: data.betCount || 0,
          winCount: data.winCount || 0
        });
      } catch (err) {
        console.error('Error fetching bet and win counts:', err);
        setStats({ betCount: 0, winCount: 0 });
      }
    };

    fetchBetWinCount();
  }, []);
  useEffect(() => {
    socket.emit(C.USER_INFO, encode({
      id: getUID(),
      coin: storage.getKey('coin') ? storage.getKey('coin') : '',
      rate: null,
      game: 'all',
      first: true
    }));

    const handleClickOutside = (event) => {
      if (
        menuRef.current &&
        !menuRef.current.contains(event.target) &&
        !buttonRef.current.contains(event.target)
      ) {
        setIsOpen(false);
      }
    };

    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  useEffect(() => {
    const checkAffiliateStatus = async () => {
      const response = await new Promise(resolve =>
        setTimeout(() => resolve({ isEnabled: false }), 1000)
      );
      setIsAffiliateEnabled(response.isEnabled);
    };

    checkAffiliateStatus();
  }, []);

  const handleUserInfoClick = () => {
    socket.emit(C.USER_INFO, encode({
      id: getUID(),
      coin: storage.getKey('coin') ? storage.getKey('coin') : '',
      rate: null,
      game: 'all',
      first: true
    }));
    setShowUserModal(true);
    setIsOpen(false);
  };

  const handleLogout = () => {
    socket.emit(C.LOGOUT_USER);
    localStorage.clear();
    Cookies.remove('session');
    Cookies.remove('auth');
    Cookies.remove('uid');
    window.location.replace('./');
  };

  const handleToggle = () => {
    setIsOpenMenu(prev => !prev);
  };

  const handleUsernameChange = (event) => {
    setNewUsername(event.target.value);
  };

  const updateUsername = async () => {
    if (!newUsername.trim()) {
      setUpdateError('Username cannot be empty');
      return;
    }

    setIsUpdatingUsername(true);
    setUpdateError(null);

    try {
      const token = localStorage.getItem('token');
      const response = await fetch('https://api.boss707.com/editProfile', {
        method: 'PUT',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
        },
        body: JSON.stringify({
          uid: displayUid,
          username: newUsername.trim()
        })
      });

      if (!response.ok) {
        throw new Error('Failed to update username');
      }

      const data = await response.json();
      storage.setKey('name', newUsername);
      setName(newUsername);
      setShowEditUi(false);

      socket.emit(C.USER_INFO, encode({
        id: getUID(),
        coin: storage.getKey('coin') ? storage.getKey('coin') : '',
        rate: null,
        game: 'all',
        first: true
      }));

      updateAvatar(newAvatarUrl);

    } catch (error) {
      setUpdateError('Failed to update username. Please try again.');
    } finally {
      setIsUpdatingUsername(false);
    }
  };

  const getUserInfo = (data) => {
    if (data.status) {
      // console.log("data received", data);
      setHaveData('ok');
      setData({
        wined: data.wined || 0,
        played: data.played || 0,
        profit: data.profit || 0
      });

      let amount = parseFloat(data?.profit).toFixed(4);
      if (amount) {
        setWageredAmount(amount);
        const vipInfo = getVipLevelDetails(amount);
        setVipDetails(vipInfo);
        animateProgress(parseFloat(vipInfo.completionPercentage));
      }
    } else {
      setHaveData('notFound');
    }
  };

  const animateProgress = (targetProgress) => {
    let currentProgress = 0;
    const duration = 1000;
    const startTime = performance.now();

    const animate = (currentTime) => {
      const elapsed = currentTime - startTime;
      const progress = Math.min(elapsed / duration, 1);

      currentProgress = progress * targetProgress;
      setProgress(currentProgress);

      if (progress < 1) {
        progressAnimationRef.current = requestAnimationFrame(animate);
      }
    };

    progressAnimationRef.current = requestAnimationFrame(animate);
  };

  const handleTogglePopup = () => {
    socket.emit(C.USER_INFO, encode({
      id: getUID(),
      coin: storage.getKey('coin') ? storage.getKey('coin') : '',
      rate: null,
      game: 'all',
      first: true
    }));
    setShowPopup(prev => !prev);
    setShowEditUi(false);
  };

  const handleTogglePopupProfile = () => {
    setShowPopupUserProfile(prev => !prev);
  };

  const handleTogglePopupProfileStatistics = () => {
    setShowPopupUserProfileStatistics(prev => !prev);
  };

  const toggleModal = () => {
    setIsModalOpen(prev => !prev);
  };

  const support = () => {
    window.$crisp = [];
    window.CRISP_WEBSITE_ID = CRISTP_ID;

    window.$crisp.push(["config", "container:fullpage", true]);
    window.$crisp.push(["config", "position:reverse", true]);
    window.$crisp.push(["config", "hide:on:mobile", false]);
    window.$crisp.push(["config", "button:hide", true]);

    if (!loaded) {
      setLoaded(true);

      const script = document.createElement('script');
      script.src = "https://client.crisp.chat/l.js";
      script.id = "chtt";
      script.async = true;

      script.onload = function () {
        setTimeout(() => {
          window.$crisp.push(["do", "chat:open"]);

          const crispStyles = `
            .crisp-client .cc-1xry { display: none !important; }
            .crisp-client .cc-kv6t { visibility: visible !important; opacity: 1 !important; display: block !important; }
            .crisp-client .cc-k5k0 { visibility: visible !important; opacity: 1 !important; display: block !important; }
            @media screen and (max-width: 768px) {
              #crisp-chatbox { display: block !important; z-index: 1000000 !important; }
              .crisp-client .cc-kv6t { max-height: 100% !important; height: 100% !important; }
            }
          `;

          const styleSheet = document.createElement("style");
          styleSheet.id = "crisp-custom-styles";
          styleSheet.innerText = crispStyles;
          document.head.appendChild(styleSheet);
        }, 1000);
      };

      document.head.appendChild(script);
    } else {
      window.$crisp.push(["do", "chat:open"]);
    }

    addNewStyle("#crisp-chatbox { display: block !important; }");
    addNewStyle(".crisp-client .cc-1xry { display: none !important; }");

    wait(2000).then(() => {
      const close = document.querySelector(".cc-wdhl");
      if (close === null) return;
      close.addEventListener("click", function (event) {
        addNewStyle("#crisp-chatbox { display: none !important; }");
        addNewStyle(".crisp-client { display: none !important; visibility: hidden !important; }");
        addNewStyle(".crisp-client .cc-1xry { display: none !important; visibility: hidden !important; }");

        window.$crisp.push(["do", "chat:hide"]);
        window.$crisp.push(["do", "session:reset"]);

        const crispScript = document.getElementById("chtt");
        if (crispScript) {
          crispScript.remove();
        }

        const customStyles = document.getElementById("crisp-custom-styles");
        if (customStyles) {
          customStyles.remove();
        }

        setLoaded(false);
      });
    });
  };

  useLayoutEffect(() => {
    socket.on(C.USER_INFO, data => getUserInfo(decode(data)));

    return () => {
      if (progressAnimationRef.current) {
        cancelAnimationFrame(progressAnimationRef.current);
      }
      socket.off(C.USER_INFO);
    };
  }, []);

  const handleStatisticsClick = () => {
    setIsOpen(false);
  };

  const handleTransactionsClick = () => {
    history.push("/transactions");
    setIsOpen(false);
  };

  const handleBetHistoryClick = () => {
    setShowBetHistoryModal(true);
    setIsOpen(false);
  };

  const handleCloseBetHistoryModal = () => {
    setShowBetHistoryModal(false);
  };

  const handleSupportClick = () => {
    support();
    setIsOpen(false);
  };

  const handleAffiliateClick = () => {
    history.push("/affiliate");
    setIsOpen(false);
  };

  const handleWalletClick = () => {
    history.push("/wallet");
    setIsOpen(false);
  };

  const handleSwapClick = () => {
    history.push("/swap");
    setIsOpen(false);
  };

  const handleVaultProClick = () => {
    history.push("/vault-pro");
    setIsOpen(false);
  };

  const handleRakebackClick = () => {
    history.push("/rakeback");
    setIsOpen(false);
  };

  const handleVipClubClick = () => {
    history.push("/vip-club");
    setIsOpen(false);
  };

  const handleGlobalSettingsClick = () => {
    history.push("/global-settings");
    setIsOpen(false);
  };

  const handleLogoutClick = () => {
    setShowLogoutModal(true);
    setIsOpen(false);
  };

  const handleImageClick = () => {
    fileInputRef.current.click();
  };

  const handleImageChange = async (e) => {
    const file = e.target.files[0];
    if (!file) return;

    if (file.size > 2 * 1024 * 1024) {
      sendNotfication('Image too large. Maximum size is 2MB.', 'danger', 'top-center');
      return;
    }

    if (!file.type.match('image.*')) {
      sendNotfication('Please select an image file.', 'danger', 'top-center');
      return;
    }

    try {
      setIsUploadingImage(true);
      const base64 = await toBase64(file);
      updateAvatar(base64);
      sendNotfication('Avatar updated successfully!', 'success', 'top-center');
    } catch (error) {
      console.error('Error updating avatar:', error);
      sendNotfication('Failed to update avatar. Please try again.', 'danger', 'top-center');
    } finally {
      setIsUploadingImage(false);
    }
  };

  return (
    <Container>
      <ProfileButton
        ref={buttonRef}
        onClick={() => setIsOpen(!isOpen)}
      >
        <ProfileImage
          src={displayAvatarUrl}
          alt="Profile"
          onError={(e) => {
            e.target.onerror = null;
            e.target.src = DEFAULT_AVATAR_PATH;
          }}
        />
      </ProfileButton>

      {isOpen && (
        <MenuPopover ref={menuRef}>
          <MobileCloseButton
            onClick={() => setIsOpen(false)}
          >
            <X size={24} color="#BCC7CB" />
          </MobileCloseButton>
          <MenuItem onClick={handleUserInfoClick}>
            <IconWrapper>
              <UserRound color="#fff" size={18} />
            </IconWrapper>
            <MenuText>User Information</MenuText>
          </MenuItem>
          <MenuItem onClick={handleTransactionsClick}>
            <IconWrapper>
              <Receipt color="#fff" size={18} />
            </IconWrapper>
            <MenuText>Transactions</MenuText>
          </MenuItem>
          <MenuItem onClick={handleBetHistoryClick}>
            <IconWrapper>
              <StyledIcon src="/assets/images/nanoicons/transactions.png" alt="Bet History" />
            </IconWrapper>
            <MenuText>Bet History</MenuText>
          </MenuItem>
          <MenuItem onClick={support}>
            <IconWrapper>
              <StyledIcon src="/assets/images/nanoicons/liveSupport.png" alt="Support" />
            </IconWrapper>
            <MenuText>Live Support</MenuText>
          </MenuItem>
          {isAffiliateEnabled && (
            <StyledLink onClick={handleAffiliateClick} to="/affiliate">
              <MenuItem>
                <IconWrapper>
                  <StyledIcon src="/assets/images/nanoicons/affiliates.png" alt="Affiliate" />
                </IconWrapper>
                <MenuText>Affiliate</MenuText>
              </MenuItem>
            </StyledLink>
          )}
          <MenuItem onClick={handleWalletClick}>
            <IconWrapper>
              <Wallet2 color="#fff" size={18} />
            </IconWrapper>
            <MenuText>Wallet</MenuText>
          </MenuItem>
          <MenuItem onClick={handleSwapClick}>
            <IconWrapper>
              <StyledIcon src="/assets/images/nanoicons/nanoswap.png" alt="Swap" />
            </IconWrapper>
            <MenuText>Swap</MenuText>
          </MenuItem>
          {
            siteConfig?.vipclub && (
              <StyledLink to="/vip-club">
                <MenuItem onClick={handleVipClubClick}>
                  <IconWrapper>
                    <StyledIcon src="/assets/images/nanoicons/vipclub.png" alt="VIP" />
                  </IconWrapper>
                  <MenuText>VIP club</MenuText>
                </MenuItem>
              </StyledLink>
            )
          }
          <StyledLink to="/global-settings">
            <MenuItem onClick={handleGlobalSettingsClick}>
              <IconWrapper>
                <StyledIcon src="/assets/images/normal-seetings.png" alt="Settings" />
              </IconWrapper>
              <MenuText>Global Settings</MenuText>
            </MenuItem>
          </StyledLink>
          <StyledNew onClick={() => {
            setShowLogoutModal(true);
            setIsOpen(false);
          }}>
            <MenuItem>
              <IconWrapper>
                <StyledImg src='/assets/images/nanoicons/logout.png' alt="Logout" />
              </IconWrapper>
              <MenuText>Logout</MenuText>
            </MenuItem>
          </StyledNew>
        </MenuPopover>
      )}

      <StyledModal show={showUserModal} onHide={() => setShowUserModal(false)} centered>
        <ModalHeader>
          <div style={{ fontSize: '14px', fontWeight: 'bold' }}>User Profile</div>
          <button className="close-button" onClick={() => {
            setShowUserModal(false);
            setShowEditUi(false);
          }}>
            <X size={24} />
          </button>
        </ModalHeader>
        <ModalBody>
          {showEditUi ? (
            <div style={{ width: "100%", height: '50vh' }}>
              <div>
                <div style={{ width: '100%', justifyContent: 'center', display: 'flex', flexDirection: 'column', alignItems: 'center' }}>
                  <ProfileImageContainer>
                    <img
                      style={{ width: '90px', height: '90px', borderRadius: '50%' }}
                      src={avatarUrl || DEFAULT_AVATAR_PATH}
                      onError={(e) => {
                        e.target.onerror = null;
                        e.target.src = DEFAULT_AVATAR_PATH;
                      }}
                    />
                    <ProfileImageEdit onClick={handleImageClick}>
                      {isUploadingImage ? (
                        <div className="spinner-border spinner-border-sm text-white" role="status">
                          <span className="sr-only">Loading...</span>
                        </div>
                      ) : (
                        <Upload size={14} color="white" />
                      )}
                    </ProfileImageEdit>
                    <HiddenFileInput
                      type="file"
                      ref={fileInputRef}
                      onChange={handleImageChange}
                      accept="image/*"
                    />
                  </ProfileImageContainer>
                </div>
              </div>
              <InputContainer>
                <Label>Username</Label>
                <Input
                  type="text"
                  value={newUsername}
                  onChange={handleUsernameChange}
                  placeholder="Enter new username"
                  disabled={isUpdatingUsername}
                />
              </InputContainer>
              <Label>Do not use special punctuation, otherwise your account may not be supported.</Label>
              <div style={{ width: '100%', display: 'flex', justifyContent: 'center' }}>
                <StyledButtonNew
                  type="button"
                  onClick={updateUsername}
                  disabled={isUpdatingUsername}
                >
                  {isUpdatingUsername ? 'Updating...' : 'Modify'}
                </StyledButtonNew>
              </div>
            </div>
          ) : (
            <div style={{ padding: '20px 0' }}>
              <div style={{ textAlign: 'center', marginBottom: '20px' }}>
                <ProfileImageContainer>
                  <img
                    src={avatarUrl || DEFAULT_AVATAR_PATH}
                    style={{ width: '100px', height: '100px', borderRadius: '50%', marginBottom: '10px' }}
                    alt="Profile"
                    onError={(e) => {
                      e.target.onerror = null;
                      e.target.src = DEFAULT_AVATAR_PATH;
                    }}
                  />
                  {/* <ProfileImageEdit onClick={() => setShowEditUi(true)}>
                    <PencilIcon size={14} color="white" />
                  </ProfileImageEdit> */}
                </ProfileImageContainer>
                <div style={{ width: "100%", display: "flex", justifyContent: "center" }}>
                  <div style={{ display: "flex", alignItems: "center", gap: "5px" }}>
                    <h3>{name}</h3>
                    {kycStatus === "Verified" ? (
                      <span
                        style={{
                          display: 'flex',
                          alignItems: 'center',
                          gap: '4px',
                          // backgroundColor: '#2ecc71',
                          color: 'white',
                          padding: '2px 6px',
                          borderRadius: '4px',
                          fontSize: '12px',
                          fontWeight: '500'
                        }}
                      >
                        <img src="/assets/images/verified-account.png" style={{ width: '24px', objectFit: 'contain' }} />
                        <div style={{ border: '1px solid rgba(255, 255, 255, 0.2)', padding: '4px 8px', borderRadius: '8px' }}>

                          Verified
                        </div>
                      </span>
                    ) : (
                      <span
                        onClick={() => {
                          history.push("/global-settings");
                          setShowUserModal(false);
                        }}
                        style={{
                          display: 'flex',
                          alignItems: 'center',
                          gap: '4px',
                          // backgroundColor: '#e74c3c',
                          color: 'white',
                          padding: '2px 6px',
                          borderRadius: '4px',
                          fontSize: '12px',
                          fontWeight: '500',
                          cursor: 'pointer'

                        }}
                      >
                        <img src="/assets/images/unverified-account.png" style={{ width: '24px', objectFit: 'contain' }} />
                        <div style={{ border: '1px solid rgba(255, 255, 255, 0.2)', padding: '4px 8px', borderRadius: '8px' }}>

                          Unverified
                        </div>
                      </span>
                    )}
                  </div>
                </div>
              </div>
              <div style={{ background: 'rgb(30, 35, 40)', padding: '20px', borderRadius: '15px', marginTop: '20px' }}>
                <h4 style={{ marginBottom: '15px', color: 'white' }}>Statistics</h4>
                <div style={{ display: 'grid', gridTemplateColumns: '1fr 1fr 1fr', gap: '10px' }}>
                  <StatBox>
                    <div className="stat-label">Total Wins</div>
                    <div className="stat-value">{stats.winCount}</div>
                  </StatBox>
                  <StatBox>
                    <div className="stat-label">Total Bets</div>
                    <div className="stat-value">{stats.betCount}</div>
                  </StatBox>
                  <StatBox>
                    <div className="stat-label">Total Wagered</div>
                    <div className="stat-value">{data.profit}</div>
                  </StatBox>
                </div>
              </div>
            </div>
          )}
        </ModalBody>
      </StyledModal>

      <LogoutModal show={showLogoutModal} onHide={() => setShowLogoutModal(false)} centered>
        <ModalHeaderLogout>
          <div className="header-title">Signing Out</div>
          <button className="close-button" onClick={() => setShowLogoutModal(false)}>
            <X size={20} color="white" />
          </button>
        </ModalHeaderLogout>
        <LogoutModalBody>
          <p style={{ fontSize: '14px', marginBottom: '5px', color: 'white' }}>
            Are you sure you want to log out? Check our great promotions and bonuses before you leave!
          </p>
          <LogoutButtonContainer>
            <LogoutButton
              className="cancel"
              onClick={() => setShowLogoutModal(false)}
            >
              Cancel
            </LogoutButton>
            <LogoutButton
              className="signout"
              onClick={handleLogout}
            >
              Sign Out
            </LogoutButton>
          </LogoutButtonContainer>
        </LogoutModalBody>
      </LogoutModal>
      <BetHistoryModal
        show={showBetHistoryModal}
        onHide={handleCloseBetHistoryModal}
      />
    </Container>
  );
};

export default ProfileMenu;