import React, { useEffect, useLayoutEffect, useState } from 'react';
import styled from 'styled-components';
import { Link } from 'react-router-dom';
import { ChevronDown, ChevronUp, Gamepad, OrigamiIcon, SliceIcon } from 'lucide-react';
import { ArrowDownTrayIcon } from '@heroicons/react/24/outline'; // Added react-heroicons import
import ClaudeIcon from '../../../Icons/Casino';
import GameIcon from '../../../Icons/Game';
import LotteryIcon from '../../../Icons/Lottery';
import TradingIcon from '../../../Icons/Crypto';
import PromotionIcon from '../../../Icons/PromotionIcon';
import VipSvg from '../../../Icons/Vip';
import BonusIcon from '../../../Icons/BonusIcon';
import AffilateIcon from '../../../Icons/AffliateIcon';
import ProvablyFairIcon from '../../../Icons/Provably';
import HeadphoneIcon from '../../../Icons/Support';
import GlobeIcon from '../../../Icons/Glob';
import SkylaSlot from '../../../Icons/SlotsSkyla';
import SkylaLivecasino from '../../../Icons/SkylaLiveCasino';
import ClubIconMember from '../../../Icons/Club';
import { CRISTP_ID, addNewStyle, getUID, wait } from '../../../Helper'; // Ensure addNewStyle and wait are imported
import SlotsIcon from '../../../Icons/SlotsIcon';
import CrashIcon from '../../../Icons/CrashIcon';
import { Android } from '@mui/icons-material';
import { useGameLaunch } from '../../../context/gameLaunchContext';
import { launchGame } from '../../../services/gameLaunchService';

const SidebarContainer = styled.div`
  width: 100%;
  transition: width 0.3s ease;
  overflow-y: auto;
  color: white;
  padding-top: 46px;
  display: flex;
  flex-direction: column;
  height: 100%; /* Ensure it takes full height */
`;

const MenuSection = styled.div`
  padding: 12px;
  margin-top: -55px;
`;

const MenuSectionS = styled.div`
  padding: 6px 0px;
  width: 100%;
`;

const MenuItem = styled(Link)`
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  border-radius: ${props => {
    if (props.accordion) {
      return props.isAccordionOpen ? '12px 12px 0 0' : '12px';
    }
    return '12px';
  }};
  margin-bottom: 4px;
  background-color: #2c3137;
  transition: all 0.2s ease;

  &:hover {
    background: linear-gradient(90deg, rgba(35, 238, 136, 0.2), rgba(35, 238, 136, 0)) !important;
    background-color: rgba(255, 255, 255, 0.05) !important;
    color: white;
  }
`;

const MenuItemVip = styled(Link)`
  display: flex;
  align-items: center;
  text-decoration: none;
  color: #808A94;
  margin: 4px 0px;
  width: 100%;
  border-radius: 12px;
  padding: 8px 12px;
  background-color: ${props => props.isActive ? '#3A4142' : '#2c3137'};
  transition: all 0.2s ease;

  &:hover {
    background: linear-gradient(90deg, rgba(35, 238, 136, 0.2), rgba(35, 238, 136, 0)) !important;
    background-color: rgba(255, 255, 255, 0.05) !important;
  }
`;

const BottomMenuItem = styled.div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  margin: 4px 0px;
  border-radius: 12px;
  background-color: #2c3137;
  transition: all 0.2s ease;
  cursor: pointer;

  &:hover {
    background: linear-gradient(90deg, rgba(35, 238, 136, 0.2), rgba(35, 238, 136, 0)) !important;
    background-color: rgba(255, 255, 255, 0.05) !important;
    color: white;
  }
`;

const OuterWrapper = styled(Link)`
  display: flex;
  align-items: center;
  color: #808A94;
  border-radius: 12px;
  transition: all 0.2s ease;
`;

const IconBgNew = styled.div`
  background: rgba(0, 0, 0, 0.1);
  border-radius: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 4px;
  transition: background-color 0.2s ease;

  &:hover {
    background-color: #4a5354;
  }
`;

const MenuIcon = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  color: ${props => props.color || 'inherit'};
  transition: color 0.2s ease;

  ${MenuItem}:hover &,
  ${MenuItemVip}:hover &,
  ${BottomMenuItem}:hover & {
    color: #ffffff;
  }
`;

const VIPSpan = styled.span`
  color: #FFA500;
  &:hover {
    color: white !important;
  }
`;

const ClubSpan = styled.span`
  color: white;
  &:hover {
    color: white !important;
  }
`;

const VIPContainer = styled.div`
  display: flex;
  gap: 2px;

  ${MenuItem}:hover &,
  ${MenuItemVip}:hover & ${ClubSpan} {
    color: #FFA500;
  }
`;

const MenuText = styled.span`
  display: ${props => props.isCollapsed ? 'none' : 'block'};
  font-size: 14px;
  font-weight: bold;
  color: ${props => props.isActive ? '#FFA500' : 'white'};
  white-space: nowrap;
  transition: color 0.2s ease;

  ${MenuItem}:hover &,
  ${MenuItemVip}:hover &,
  ${BottomMenuItem}:hover & {
    color: white !important;
  }
`;

const Divider = styled.div`
  height: 1px;
  background-color: #2C2F36;
  margin: 12px 4px;
`;

const ExternalIndicator = styled.div`
  display: ${props => props.isCollapsed ? 'none' : 'flex'};
  align-items: center;
`;

const LeftSection = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  transition: all 0.2s ease;
`;

const IconBg = styled.div`
  padding: 6px 8px;
  background-color: #394142;
  border-radius: 10px;
  transition: background-color 0.2s ease;

  &:hover {
    background-color: #4a5354;
  }
`;

const LogoContainer = styled(Link)`
  display: flex;
  align-items: center;
`;

const Logo = styled.img`
  width: ${props => props.showFull ? '128px' : '96px'};
  height: auto;
  transition: width 0.3s ease;
`;

const SubMenuContainer = styled.div`
  margin-top: -6px;
  background: rgb(18, 20, 24);
  display: ${props => props.isOpen ? 'block' : 'none'};
  border-bottom-left-radius: 12px;
  border-bottom-right-radius: 12px;
`;

const SubMenuItem = styled(Link)`
  display: flex;
  align-items: center;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  border-radius: 8px;
  margin-bottom: 4px;
  background-color: ${props => props.isActive ? '#3A4142' : '#2c3137'};
  transition: all 0.2s ease;

  &:hover {
    background-color: #3A4142;
    color: #ffffff;
  }
`;

const MenuItemClub = styled(MenuItemVip)`
  color: #FFD700;
  margin: 4px 0px;

  ${props => props.isActive && `
    background: linear-gradient(90deg, rgba(255, 215, 0, 0.2), rgba(255, 215, 0, 0)) !important;
    background-color: rgba(255, 215, 0, 0.05) !important;
  `}

  ${MenuText} {
    color: #FFD700;
  }

  ${MenuIcon} {
    color: #FFD700;
  }
`;

const BottomSection = styled.div`
  padding: 8px;
  margin-top: auto; /* Pushes this section to the bottom */
`;

const SkylaMobileMenu = ({ isCollapsed }) => {
  const [activePath, setActivePath] = useState('/');
  const [openAccordions, setOpenAccordions] = useState({});
  const [openSGOriginals, setSGOriginals] = useState(false);
  const [isHovered, setIsHovered] = useState(false);
  const [loaded, setLoaded] = useState(false);

  const { setGameUrl, setIsGameOpen } = useGameLaunch();

  useLayoutEffect(() => {
    setOpenAccordions(prev => ({ ...prev }));
  }, [isCollapsed]);

  const toggleAccordion = (path) => {
    setOpenAccordions((prevState) => ({
      ...prevState,
      [path]: !prevState[path],
    }));
  };

   const handleSportsClick = async () => {
      try {
        const credits = localStorage.getItem('credit') || '0';
        const coins = localStorage.getItem('coin') || 'INR';  
        const id = getUID();
        const gameUrl = await launchGame(
          '92b24e4c25107367a80e0fe1a97c24e4', 
          id, 
          coins,
          credits
        );
        if (gameUrl) {
          setGameUrl(gameUrl);
          setIsGameOpen(true);
        } else {
          console.error('Failed to get game URL');
        }
      } catch (error) {
        console.error('Failed to launch sports game:', error);
      }
    };
  

  const handleMenuClick = (e, item) => {
    if (item.accordion) {
      e.preventDefault();
      toggleAccordion(item.path);

    }

    if(item.text=="Sports"){
      handleSportsClick;
      
    }

    // Handle specific menu item clicks
    switch (item.text) {
     
      case 'Casino':
        window.location.href = '/';
        break;
      case 'Lottery':
        window.location.href = '/lottery';
        break;
      case 'Crash':
        window.location.href = '/crash-games';
        break;
      case 'All Slots':
        window.location.href = '/all-slots';
        break;
      default:
        break;
    }

    setActivePath(item.path);
  };

  const support = () => {
    // Support function remains unchanged...
    window.$crisp = [];
    window.CRISP_WEBSITE_ID = CRISTP_ID;
    window.$crisp.push(["config", "container:fullpage", true]);
    window.$crisp.push(["config", "position:reverse", true]);
    window.$crisp.push(["config", "hide:on:mobile", false]);
    window.$crisp.push(["config", "button:hide", true]);
    
    if (!loaded) {
      console.log("support");
      setLoaded(true);
      const script = document.createElement('script');
      script.src = "https://client.crisp.chat/l.js";
      script.id = "chtt";
      script.async = true;
      script.onload = function() {
        setTimeout(() => {
          window.$crisp.push(["do", "chat:open"]);
          const crispStyles = `
            .crisp-client .cc-1xry { display: none !important; }
            .crisp-client .cc-kv6t { visibility: visible !important; opacity: 1 !important; display: block !important; }
            .crisp-client .cc-k5k0 { visibility: visible !important; opacity: 1 !important; display: block !important; }
            @media screen and (max-width: 768px) {
              #crisp-chatbox { display: block !important; z-index: 1000000 !important; }
              .crisp-client .cc-kv6t { max-height: 100% !important; height: 100% !important; }
            }
          `;
          const styleSheet = document.createElement("style");
          styleSheet.id = "crisp-custom-styles";
          styleSheet.innerText = crispStyles;
          document.head.appendChild(styleSheet);
        }, 1000);
      };
      document.head.appendChild(script);
    } else {
      window.$crisp.push(["do", "chat:open"]);
    }
    addNewStyle("#crisp-chatbox { display: block !important; }");
    addNewStyle(".crisp-client .cc-1xry { display: none !important; }");
    wait(2000).then(() => {
      const close = document.querySelector(".cc-wdhl");
      if (close === null) return;
      close.addEventListener("click", function (event) {
        addNewStyle("#crisp-chatbox { display: none !important; }");
        addNewStyle(".crisp-client { display: none !important; visibility: hidden !important; }");
        addNewStyle(".crisp-client .cc-1xry { display: none !important; visibility: hidden !important; }");
        window.$crisp.push(["do", "chat:hide"]);
        window.$crisp.push(["do", "session:reset"]);
        const crispScript = document.getElementById("chtt");
        if (crispScript) crispScript.remove();
        const customStyles = document.getElementById("crisp-custom-styles");
        if (customStyles) customStyles.remove();
        setLoaded(false);
      });
    });
  };

  const handleDownloadAPK = () => {
    window.open('https://your-app-download-url.apk', '_blank');
  };

  const menuItems = [
    { id: 1, icon: <ClaudeIcon />, text: 'Casino', path: '/', accordion: false },
    { id: 2, icon: <GameIcon />, text: 'Sports', path: '/', accordion: false },
    { id: 3, icon: <LotteryIcon />, text: 'Spribe', path: '/spribe-games', accordion: false },
    { id: 646, icon: <CrashIcon />, text: 'Live', path: '/live', accordion: false },
    { id: 11, icon: <SlotsIcon />, text: 'Slots', path: '/pm-slots', accordion: false },
  ];

  const vipItems = [
    { id: 1, icon: <VipSvg />, text: 'VIP Club', path: '/vip-club', color: '#4CAF50' },
    // { id: 2, icon: <ClubIconMember />, text: 'Club Membership', path: '/club-membership', color: '#4CAF50' },
    { id: 3, icon: <BonusIcon />, text: 'Bonus', path: '/bonus' },
    { id: 847, icon: <AffilateIcon />, text: 'Affiliate', path: '/affiliate' },
    { id: 5, icon: <ProvablyFairIcon />, text: 'Provably Fair', path: '/provably-fair' },
  ];

  return (
    <SidebarContainer isCollapsed={isCollapsed}>
      <MenuSection>
        {menuItems.map((item) => (
          <React.Fragment key={item.path}>
            <MenuItem
              to={item.path}
              accordion={item.accordion}
              isAccordionOpen={openAccordions[item.path]}
              isActive={activePath === item.path}
              isCollapsed={isCollapsed}
              onClick={(e) => handleMenuClick(e, item)} // Use the unified handler
            >
              <div style={{
                width: "100%",
                display: "flex",
                justifyContent: "space-between",
                alignItems: "center"
              }}>
                <LeftSection>
                  <MenuIcon isCollapsed={isCollapsed} color={item.color}>
                    {item.icon}
                  </MenuIcon>
                  <MenuText
                    isActive={activePath === item.path}
                    isCollapsed={isCollapsed}
                    color={item.color}
                    isSpecial={item.text === 'VIP Club'}
                  >
                    {item.text === "VIP Club" ? (
                      <VIPContainer>
                        <VIPSpan>VIP</VIPSpan>
                        <ClubSpan>Club</ClubSpan>
                      </VIPContainer>
                    ) : item.text}
                  </MenuText>
                </LeftSection>
                {item.accordion && !isCollapsed && (
                  <IconBgNew>
                    <MenuIcon isCollapsed={isCollapsed}>
                      {openAccordions[item.path] ? <ChevronUp size={18} /> : <ChevronDown size={18} />}
                    </MenuIcon>
                  </IconBgNew>
                )}
              </div>
            </MenuItem>
          </React.Fragment>
        ))}
      </MenuSection>

      <div style={{ padding: '8px', flex: 1 }}>
        <OuterWrapper>
          <MenuSectionS>
            {vipItems.map((item, index) => (
              <React.Fragment key={item.path}>
                {item.text === 'Club Membership' ? (
                  <MenuItemClub
                    to={item.path}
                    isActive={activePath === item.path}
                    isCollapsed={isCollapsed}
                    onClick={() => setActivePath(item.path)}
                  >
                    <LeftSection>
                      <MenuIcon isCollapsed={isCollapsed} color="#FFD700">
                        {item.icon}
                      </MenuIcon>
                      <MenuText
                        isActive={activePath === item.path}
                        isCollapsed={isCollapsed}
                        color="#FFD700"
                      >
                        {item.text}
                      </MenuText>
                    </LeftSection>
                  </MenuItemClub>
                ) : (
                  <MenuItemVip
                    to={item.path}
                    isActive={activePath === item.path}
                    isCollapsed={isCollapsed}
                    onClick={() => setActivePath(item.path)}
                  >
                    <LeftSection>
                      <MenuIcon isCollapsed={isCollapsed} color={item.color}>
                        {item.icon}
                      </MenuIcon>
                      <MenuText
                        isActive={activePath === item.path}
                        isCollapsed={isCollapsed}
                        color={item.color}
                        isSpecial={item.text === 'VIP Club'}
                      >
                        {item.text === "VIP Club" ? (
                          <VIPContainer>
                            <VIPSpan>VIP</VIPSpan>
                            <ClubSpan>Club</ClubSpan>
                          </VIPContainer>
                        ) : item.text}
                      </MenuText>
                    </LeftSection>
                    {item.external && (
                      <ExternalIndicator isCollapsed={isCollapsed}>
                        <GlobeIcon size={16} />
                      </ExternalIndicator>
                    )}
                  </MenuItemVip>
                )}
                {[4, 7, 8, 12].includes(index) && <Divider />}
              </React.Fragment>
            ))}
          </MenuSectionS>
        </OuterWrapper>
      </div>

      <BottomSection>
        <BottomMenuItem onClick={support}>
          <div style={{
            width: "100%",
            display: "flex",
            justifyContent: "space-between",
            alignItems: "center"
          }}>
            <LeftSection>
              <MenuIcon isCollapsed={isCollapsed}>
                <HeadphoneIcon />
              </MenuIcon>
              <MenuText isCollapsed={isCollapsed}>
                Live Support
              </MenuText>
            </LeftSection>
          </div>
        </BottomMenuItem>
      </BottomSection>
    </SidebarContainer>
  );
};

export default SkylaMobileMenu;