// import React, { useEffect, useState } from 'react';
// import styled from 'styled-components';
// import { useBetting } from '../../../../../context/BettingContext';
// import { Play, RefreshCw, Flag, Info, BadgeDollarSign } from 'lucide-react';
// import { useHistory } from 'react-router-dom';
// import LoadingSpinner from '../../components/Loader';

// // Styled Components
// const Container = styled.div`
//   width: 100%;
//   background:rgb(18, 20, 24);
//   font-family: M;
//   margin-top: 10px;
// `;



// const Match = styled.div`
//   display: flex;
//   justify-content: space-between;
//   align-items: center;
//   padding: 10px;
//   border-bottom: 1px solid rgb(50, 55, 56);
//   background: #000000;
//   font-family: M;
// `;

// const MatchInfo = styled.div`
//   flex: 1;
//   font-family: M;
// `;

// const MatchTitle = styled.div`
//   color: #ffffff;
//   font-weight: bold;
//   margin-bottom: 0px;
//   cursor: pointer;
//   display: inline-block;
//   font-size: 11px;
//   font-family: M;
  
//   &:hover {
//     text-decoration: underline;
//     color: rgb(240, 156, 6);
//   }
// `;

// const StatusDot = styled.span`
//   display: inline-block;
//   width: 8px;
//   height: 8px;
//   background-color: ${props => props.isLive === "In-Play" ? '#2ecc71' : '#95a5a6'};
//   border-radius: 50%;
//   margin-right: 8px;
//   margin-bottom: -5px;
//   animation: ${props => props.isLive === "In-Play" ? 'blink 1s ease-in-out infinite' : 'none'};

//   @keyframes blink {
//     0% { opacity: 0; }
//     50% { opacity: 1; }
//     100% { opacity: 0; }
//   }
// `;
// const Status = styled.div`
//   color: ${props => {
//     switch (props.status) {
//       case 'In-Play':
//         return 'rgb(240, 156, 6)';
//       case 'Not Started':
//         return '#cccccc';
//       case 'Suspended':
//         return '#e74c3c';
//       default:
//         return '#cccccc';
//     }
//   }};
//   font-size: 10px;
//   font-weight: bold;
//   margin-top: 12px;
//   font-family: M;
// `;

// const IconGroup = styled.div`
//   display: flex;
//   gap: 2px;
//   margin-bottom: -5px;
//   font-family: M;
// `;

// const Icon = styled.span`
//   background: #2ecc71;
//   color: white;
//   padding: 2px 6px;
//   border-radius: 4px;
//   font-size: 10px;
//   font-family: M;
// `;

// const TabContainer = styled.div`
//   display: flex;
//   gap: 2px;
//   background: rgb(50, 55, 56);
//   font-family: M;
// `;

// const TabButton = styled.button`
//   padding: 8px 16px;
//   background: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
//   color: ${props => props.active ? '#000000' : '#ffffff'};
//   border: none;
//   cursor: pointer;
//   font-weight: 600;
//   font-size: 10px;
//   font-family: M;
//   transition: all 0.2s ease;
//   position: relative;

//   &:hover {
//     background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'rgba(240, 156, 6, 0.1)'};
//     color: ${props => props.active ? '#000000' : 'rgb(240, 156, 6)'};
//   }

//   &:after {
//     content: '';
//     position: absolute;
//     bottom: 0;
//     left: 0;
//     width: 100%;
//     height: 2px;
//     background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
//     transition: all 0.2s ease;
//   }
// `;

// const ContentContainer = styled.div`
//   padding: 2px;
//   width: 100%;
//   border-radius: 0 0 8px 8px;
//   color: #ffffff;
//   background: #000000;
//   font-family: M;
// `;

// const TabContent = styled.div`
//   animation: fadeIn 0.3s ease;
//   min-height: calc(100vh - 200px);
//   overflow-y: auto;
//   background-color: #000000;
//   font-family: M;
  
//   &::-webkit-scrollbar {
//     width: 8px;
//   }
  
//   &::-webkit-scrollbar-track {
//     background: rgb(50, 55, 56);
//   }
  
//   &::-webkit-scrollbar-thumb {
//     background: rgb(240, 156, 6);
//     border-radius: 4px;
//   }
  
//   &::-webkit-scrollbar-thumb:hover {
//     background: rgb(220, 136, 6);
//   }
  
//   @keyframes fadeIn {
//     from { opacity: 0; }
//     to { opacity: 1; }
//   }
// `;

// const MobileSportsUI = (props) => {
//   const { addBet } = useBetting();
//   const history = useHistory();
//   const [isLoading, setIsLoading] = useState(true)
//   const [mobileMatches, setMobileMatches] = useState([]);
//   const [activeTab, setActiveTab] = useState('in-play');
 

//   const handleTabClick = (tab) => {
//     setActiveTab(tab);
//     // setIsLoading(true);
//   };

//   useEffect(() => {
//     if (props.tab) {
//       setIsLoading(true)
//     }
//   }, [props.tab])


//   useEffect(() => {
//     const fetchAllMatches = async () => {
//       setIsLoading(true);
//       try {
//         // Parallel fetch for better performance
//         const token = localStorage.getItem('token');

// const [inPlayResponse, allMatchesResponse] = await Promise.all([
//   fetch('https://api.boss707.com/sports/allinplay', {
//     headers: {
//       'Authorization': `Bearer ${token}`,
//       'Content-Type': 'application/json'
//     }
//   }),
//   fetch('https://api.boss707.com/sports/all-matches', {
//     headers: {
//       'Authorization': `Bearer ${token}`,
//       'Content-Type': 'application/json'
//     }
//   })
// ]);
//         const inPlayData = await inPlayResponse.json();
//         const allMatchesData = await allMatchesResponse.json();
//         // console.log("mathes #####", allMatchesData)



//         // Filter cricket matches from both responses
//         const inPlayCricketData = inPlayData.find(sport => sport.id === "4")?.markets || [];
//         const allCricketData = allMatchesData.find(sport => sport.id === "4")?.markets || [];
//         const allSportsData = allMatchesData?.map((markets) => markets?.markets);
//         const soccerData = allMatchesData.find(sport => sport.id === "1")?.markets || [];
//         const tennisData = allMatchesData.find(sport => sport.id === "2")?.markets || [];
//         const wholeSportsDtaa = [...allSportsData[0], ...allSportsData[1], ...allSportsData[2]];
        
//         console.log("inPlayCricketData:", inPlayCricketData);
//         console.log("allCricketData:", allCricketData);
//         console.log("allSportsData:", allSportsData);
//         console.log("soccerData:", soccerData);
//         console.log("tennisData:", tennisData);
//         console.log("wholeSportsDtaa:", wholeSportsDtaa);

//         // Create a Map to store unique matches with in-play taking priority
//         const matchesMap = new Map();

//         // Process in-play matches first
//         inPlayCricketData.forEach(match => {
//           matchesMap.set(match.marketId, {
//             id: match.marketId,
//             team1: match.runners[0]?.runnerName || '',
//             team2: match.runners[1]?.runnerName || '',
//             status: 'In-Play',
//             isSuspended: match.stopBet,
//             inplay: true,
//             eventid:match?.version,
//             marketStartTime: match.marketStartTime,
//             odds: {
//               one: { back: '--', lay: '--' },
//               x: { back: '--', lay: '--' },
//               two: { back: '--', lay: '--' }
//             }
//           });
//         });

//         // Add non-duplicate matches from all-matches API
//         if (props.tab === "all-sports") {
//           wholeSportsDtaa.forEach(match => {
//             if (!matchesMap.has(match.marketId)) {
//               const utcDate = new Date(match.marketStartTime);
//               const istTime = new Intl.DateTimeFormat('en-IN', {
//                 hour: '2-digit',
//                 minute: '2-digit',
//                 hour12: true
//               }).format(utcDate);

//               matchesMap.set(match.marketId, {
//                 id: match.marketId,
//                 team1: match.runners[0]?.runnerName || '',
//                 team2: match.runners[1]?.runnerName || '',
//                 status: `${istTime}`,
//                 isSuspended: match.stopBet,
//                 inplay: false,
//                 eventid:match?.version,
//                 marketStartTime: match.marketStartTime,
//                 odds: {
//                   one: { back: '--', lay: '--' },
//                   x: { back: '--', lay: '--' },
//                   two: { back: '--', lay: '--' }
//                 }
//               });
//             }
//           });
//         }
//         else if (props.tab === "soccer") {
//           soccerData.forEach(match => {
//             if (!matchesMap.has(match.marketId)) {
//               const utcDate = new Date(match.marketStartTime);
//               const istTime = new Intl.DateTimeFormat('en-IN', {
//                 hour: '2-digit',
//                 minute: '2-digit',
//                 hour12: true
//               }).format(utcDate);

//               matchesMap.set(match.marketId, {
//                 id: match.marketId,
//                 team1: match.runners[0]?.runnerName || '',
//                 team2: match.runners[1]?.runnerName || '',
//                 status: `${istTime}`,
//                 isSuspended: match.stopBet,
//                 inplay: false,
//                 eventid:match?.version,
//                 marketStartTime: match.marketStartTime,
//                 odds: {
//                   one: { back: '--', lay: '--' },
//                   x: { back: '--', lay: '--' },
//                   two: { back: '--', lay: '--' }
//                 }
//               });
//             }
//           });
//         }
//         else if (props.tab === "tennis") {
//           tennisData.forEach(match => {
//             if (!matchesMap.has(match.marketId)) {
//               const utcDate = new Date(match.marketStartTime);
//               const istTime = new Intl.DateTimeFormat('en-IN', {
//                 hour: '2-digit',
//                 minute: '2-digit',
//                 hour12: true
//               }).format(utcDate);

//               matchesMap.set(match.marketId, {
//                 id: match.marketId,
//                 team1: match.runners[0]?.runnerName || '',
//                 team2: match.runners[1]?.runnerName || '',
//                 status: `${istTime}`,
//                 eventid:match?.version,
//                 isSuspended: match.stopBet,
//                 inplay: false,
//                 marketStartTime: match.marketStartTime,
//                 odds: {
//                   one: { back: '--', lay: '--' },
//                   x: { back: '--', lay: '--' },
//                   two: { back: '--', lay: '--' }
//                 }
//               });
//             }
//           });
//         }
//         else if (props.tab === "cricket") {
//           allCricketData.forEach(match => {
//             if (!matchesMap.has(match.marketId)) {
//               const utcDate = new Date(match.marketStartTime);
//               const istTime = new Intl.DateTimeFormat('en-IN', {
//                 hour: '2-digit',
//                 minute: '2-digit',
//                 hour12: true
//               }).format(utcDate);

//               matchesMap.set(match.marketId, {
//                 id: match.marketId,
//                 team1: match.runners[0]?.runnerName || '',
//                 team2: match.runners[1]?.runnerName || '',
//                 status: `${istTime}`,
//                 isSuspended: match.stopBet,
//                 inplay: false,
//                 eventid:match?.version,
//                 marketStartTime: match.marketStartTime,
//                 odds: {
//                   one: { back: '--', lay: '--' },
//                   x: { back: '--', lay: '--' },
//                   two: { back: '--', lay: '--' }
//                 }
//               });
//             }
//           });
//         }
//         else {
//           wholeSportsDtaa.forEach(match => {
//             if (!matchesMap.has(match.marketId)) {
//               const utcDate = new Date(match.marketStartTime);
//               const istTime = new Intl.DateTimeFormat('en-IN', {
//                 hour: '2-digit',
//                 minute: '2-digit',
//                 hour12: true
//               }).format(utcDate);

//               matchesMap.set(match.marketId, {
//                 id: match.marketId,
//                 team1: match.runners[0]?.runnerName || '',
//                 team2: match.runners[1]?.runnerName || '',
//                 status: `${istTime}`,
//                 isSuspended: match.stopBet,
//                 eventid:match?.version,
//                 inplay: false,
//                 marketStartTime: match.marketStartTime,
//                 odds: {
//                   one: { back: '--', lay: '--' },
//                   x: { back: '--', lay: '--' },
//                   two: { back: '--', lay: '--' }
//                 }
//               });
//             }
//           });
//         }

//         // Function to fetch and process odds for a single match
//         const fetchMatchOdds = async (matchId) => {
//           try {
//          const token = localStorage.getItem('token');
// const response = await fetch(`https://api.boss707.com/sports/market-odds?market_id=${matchId}`, {
//   headers: {
//     'Authorization': `Bearer ${token}`,
//     'Content-Type': 'application/json'
//   }
// });
//             const data = await response.json();

//             const marketOdds = data[0];
//             if (!marketOdds || !marketOdds.runners) return null;

//             const runners = marketOdds.runners;
//             let formattedOdds = {
//               one: { back: '--', lay: '--' },
//               x: { back: '--', lay: '--' },
//               two: { back: '--', lay: '--' }
//             };

//             if (runners.length === 2) {
//               formattedOdds.one = {
//                 back: runners[0].ex.availableToBack[0]?.price || '--',
//                 lay: runners[0].ex.availableToLay[0]?.price || '--'
//               };
//               formattedOdds.two = {
//                 back: runners[1].ex.availableToBack[0]?.price || '--',
//                 lay: runners[1].ex.availableToLay[0]?.price || '--'
//               };
//             } else if (runners.length === 3) {
//               formattedOdds.one = {
//                 back: runners[0].ex.availableToBack[0]?.price || '--',
//                 lay: runners[0].ex.availableToLay[0]?.price || '--'
//               };
//               formattedOdds.x = {
//                 back: runners[1].ex.availableToBack[0]?.price || '--',
//                 lay: runners[1].ex.availableToLay[0]?.price || '--'
//               };
//               formattedOdds.two = {
//                 back: runners[2].ex.availableToBack[0]?.price || '--',
//                 lay: runners[2].ex.availableToLay[0]?.price || '--'
//               };
//             }

//             return formattedOdds;
//           } catch (error) {
//             console.error('Error fetching odds:', error);
//             return null;
//           }
//           finally {

//           }
//         };

//         // Fetch odds for all matches and update them in the map
//         const matchesWithOdds = await Promise.all(
//           Array.from(matchesMap.entries()).map(async ([marketId, match]) => {
//             const odds = await fetchMatchOdds(marketId);
//             if (odds) {
//               match.odds = odds;
//             }
//             return match;
//           })
//         );

//         // Sort and set the matches
//         const sortedMatches = matchesWithOdds.sort((a, b) => {
//           if (a.inplay && !b.inplay) return -1;
//           if (!a.inplay && b.inplay) return 1;
//           return new Date(a.marketStartTime) - new Date(b.marketStartTime);
//         });

//         setMobileMatches(sortedMatches);


//       } catch (error) {
//         console.error('Error fetching matches:', error);

//       }
//       finally {
//         setIsLoading(false)
//       }
//     };


//     fetchAllMatches();

//     const interval = setInterval(fetchAllMatches, 30000);
//     setIsLoading(false)
//     return () => clearInterval(interval);
//   }, [props.tab]);

//   // Create dates for testing
//   const today = new Date();
//   const tomorrow = new Date(today);
//   tomorrow.setDate(tomorrow.getDate() + 1);

//   console.log("macthes", mobileMatches)
//   console.log("is loading", isLoading)

//   const mobileMatchesMap = mobileMatches?.map((data) => ({
//     id: data?.id,
//     team1: data?.team1,
//     team2: data?.team2,
//     status: data?.status,
//     isLive: true,
//     time: '14:30',
//     date: new Date(),
//     isSuspended: data?.isSuspended,
//     competition: 'International',
//     eventId:data.version
//   }))

 


//   const getMatchStatus = (match) => {
//     if (!match.date) return null;

//     if (activeTab === 'in-play' && match.isLive) {
//       return (
//         <>
//           {/* <StatusDot isLive={true} /> */}
//           <Status status="In-Play">In-Play</Status>
//         </>
//       );
//     } else if (activeTab === 'today') {
//       return (
//         <Status status="Not Started">{match.time}</Status>
//       );
//     } else if (activeTab === 'tomorrow') {
//       return (
//         <Status status="Not Started">Tomorrow {match.time}</Status>
//       );
//     }
//     return null;
//   };

//   const filteredMatches = mobileMatchesMap.filter(match => {
//     if (!match.date) return false;

//     const matchDate = new Date(match.date);
//     const today = new Date();
//     const tomorrow = new Date(today);
//     tomorrow.setDate(tomorrow.getDate() + 1);

//     // Reset time part for date comparison
//     matchDate.setHours(0, 0, 0, 0);
//     today.setHours(0, 0, 0, 0);
//     tomorrow.setHours(0, 0, 0, 0);

//     if (activeTab === 'in-play') {
//       return match.isLive;
//     } else if (activeTab === 'today') {
//       return !match.isLive &&
//         match.date.getDate() === today.getDate() &&
//         match.date.getMonth() === today.getMonth() &&
//         match.date.getYear() === today.getYear();
//     } else if (activeTab === 'tomorrow') {
//       return match.date.getDate() === tomorrow.getDate() &&
//         match.date.getMonth() === tomorrow.getMonth() &&
//         match.date.getYear() === tomorrow.getYear();
//     }
//     return false;
//   });



//   const handleMatchClick = (matchId) => {
//     // Find the match data from matches array
//     const selectedMatch = mobileMatches?.find(match => match.id === matchId);

//     // Push to history with match data in state
//     history.push({
//       pathname: `/match/fullmarket/event/${matchId}`,
//       state: {
//         matchData: {
//           ...selectedMatch,
//           matchId: matchId,
//           eventId:selectedMatch?.eventid,
//           matchTitle: `${selectedMatch.team1} v ${selectedMatch.team2}`,
//           competition: selectedMatch.competition,
//           status: selectedMatch.status,
//           isLive: selectedMatch.isLive,
//           isSuspended: selectedMatch.isSuspended
//         }
//       }
//     });
//   };

//   console.log("mobile macths $$$$$", mobileMatches);
//   console.log("props active tab", props.tab)

//   return (
//     <Container>
//       <TabContainer>
//         <TabButton
//           active={activeTab === 'in-play'}
//           onClick={() => handleTabClick('in-play')}
//         >
//           In-Play
//         </TabButton>
//         <TabButton
//           active={activeTab === 'today'}
//           onClick={() => handleTabClick('today')}
//         >
//           Today
//         </TabButton>
//         <TabButton
//           active={activeTab === 'tomorrow'}
//           onClick={() => handleTabClick('tomorrow')}
//         >
//           Tomorrow
//         </TabButton>
//       </TabContainer>
//       <ContentContainer>

//         <TabContent>
//           {mobileMatchesMap.map((match, index) => (
//             <Match key={index}>
//               <MatchInfo>
//                 <div style={{ display: 'flex', gap: "10px", alignItems: 'center' }}>
            
//                     <IconGroup>
//                       {/* <Icon><Play size={12} /></Icon>
//                   <Icon><RefreshCw size={12} /></Icon>
//                   <Icon><Flag size={12} /></Icon>
//                   <Icon><Info size={12} /></Icon> */}
//                       <img src='/assets/images/sports/cricket.png' style={{ width: "50px", height: "20px", objectFit: 'contain' }} />
//                       <img src='/assets/images/sports/livestream.png' style={{ width: "20px", height: "20px", objectFit: 'contain' }} />
//                       <img src='/assets/images/sports/watch.png' style={{ width: "20px", height: "20px", objectFit: 'contain' }} />
//                       <img src='/assets/images/sports/fancy.png' style={{ width: "20px", height: "20px", objectFit: 'contain' }} />
//                       <img src='/assets/images/sports/book.png' style={{ width: "20px", height: "20px", objectFit: 'contain' }} />

//                     </IconGroup>
                 
//                   {getMatchStatus(match)}
//                 </div>
//                 <div style={{ display: 'flex', gap: "0px", alignItems: 'center' }}>
//                   <StatusDot isLive={match?.status} />
//                   <MatchTitle onClick={() => handleMatchClick(match.id)}>
//                     {`${match.team1} v ${match.team2}`}
//                   </MatchTitle>
//                 </div>
//               </MatchInfo>
//             </Match>
//           ))}
//         </TabContent>
//       </ContentContainer>
//     </Container>

//   );
// };

// export default MobileSportsUI;
import React, { useEffect, useState } from 'react';
import styled from 'styled-components';
import { useBetting } from '../../../../../context/BettingContext';
import { useHistory } from 'react-router-dom';
// Local inline loader (replacing external LoadingSpinner)

// Styled Components (unchanged)
const Container = styled.div`
  width: 100%;
  background: rgb(18, 20, 24);
  font-family: 'Montserrat', sans-serif !important;
  margin-top: 10px;
  display: flex;
  flex-direction: column;
  height: 100vh;
`;

const TabContainer = styled.div`
  display: flex;
  gap: 2px;
  background: rgb(50, 55, 56);
`;

const TabButton = styled.button`
  padding: 8px 16px;
  background: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
  color: ${props => props.active ? '#000' : '#fff'};
  border: none;
  cursor: pointer;
  font-weight: 600;
  font-size: 10px;
  transition: all 0.2s ease;
  position: relative;

  &:hover {
    background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'rgba(240, 156, 6, 0.1)'};
    color: ${props => props.active ? '#000' : 'rgb(240, 156, 6)'};
  }

  &:after {
    content: '';
    position: absolute;
    bottom: 0; left: 0;
    width: 100%; height: 2px;
    background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
    transition: all 0.2s ease;
  }
`;

const ContentContainer = styled.div`
  flex: 1;
  background: #000;
  padding: 2px;
  border-radius: 0 0 8px 8px;
  display: flex;
  flex-direction: column;
`;

const TabContent = styled.div`
  overflow-y: auto;
  flex: 1;
  background: #000;

  &::-webkit-scrollbar { width: 8px; }
  &::-webkit-scrollbar-track { background: rgb(50, 55, 56); }
  &::-webkit-scrollbar-thumb {
    background: rgb(240, 156, 6);
    border-radius: 4px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: rgb(220, 136, 6);
  }
`;

const Match = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px;
  border-bottom: 1px solid rgb(50, 55, 56);
  background: #000;
`;

const MatchInfo = styled.div` flex: 1; `;

const TitleContainer = styled.div`
  display: flex;
  align-items: center;
`;

const StatusDot = styled.span`
  display: inline-block;
  width: 8px; height: 8px;
  background-color: ${props => props.isLive ? '#2ecc71' : '#95a5a6'};
  border-radius: 50%;
  margin-right: 8px;
  animation: ${props => props.isLive ? 'blink 1s ease-in-out infinite' : 'none'};
  @keyframes blink {
    0% { opacity: 0 } 50% { opacity: 1 } 100% { opacity: 0 }
  }
`;

const MatchTitle = styled.div`
  color: #fff;
  font-weight: bold;
  font-size: 11px;
  cursor: pointer;
  &:hover {
    text-decoration: underline;
    color: rgb(240, 156, 6);
  }
`;

const Status = styled.div`
  color: ${props => props.status === 'In-Play'
    ? 'rgb(240, 156, 6)'
    : props.status === 'Suspend'
    ? '#e74c3c'
    : '#ccc'};
  font-size: 10px;
  font-weight: bold;
  margin-top: 12px;
`;

const IconGroup = styled.div`
  display: flex;
  gap: 4px;
  margin-left: 8px;
`;

const PTE = styled.div`
  color: #fff;
  font-size: 12px;
  margin-right: 10px;
`;

// Inline spinner styles
const LoaderWrap = styled.div`
  flex: 1;
  display: flex;
  align-items: center;
  justify-content: center;
  background: #000;
  padding: 24px;
`;

const EmptyState = styled.div`
  color: #ffffff;
  text-align: center;
  padding: 24px 12px;
`;

const LoaderSpinner = styled.div`
  width: 28px;
  height: 28px;
  border: 3px solid rgba(255, 255, 255, 0.2);
  border-top-color: rgb(240, 156, 6);
  border-radius: 50%;
  animation: spin 0.8s linear infinite;

  @keyframes spin {
    to { transform: rotate(360deg); }
  }
`;


const MobileSportsUI = ({ tab: sportTab }) => {
  const { addBet } = useBetting();
  const history = useHistory();
  const [isLoading, setIsLoading] = useState(false);
  const [mobileMatches, setMobileMatches] = useState([]);
  const [activeTab, setActiveTab] = useState('in-play');

  const handleTabClick = (tab) => {
    setActiveTab(tab);
  };

  // fetch odds helper
  const fetchMatchOdds = async (matchId) => {
    try {
      const token = localStorage.getItem('token');
      const res = await fetch(
        `https://api.boss707.com/sports/market-odds?market_id=${matchId}`,
        {
          headers: {
            'Authorization': `Bearer ${token}`,
            'Content-Type': 'application/json'
          }
        }
      );
      const [marketOdds] = await res.json();
      if (!marketOdds?.runners) return null;

      const runners = marketOdds.runners;
      const formatted = {
        one: { back: '--', lay: '--' },
        x: { back: '--', lay: '--' },
        two: { back: '--', lay: '--' }
      };

      if (runners.length === 2) {
        formatted.one = {
          back: runners[0].ex.availableToBack[0]?.price || '--',
          lay: runners[0].ex.availableToLay[0]?.price || '--'
        };
        formatted.two = {
          back: runners[1].ex.availableToBack[0]?.price || '--',
          lay: runners[1].ex.availableToLay[0]?.price || '--'
        };
      } else if (runners.length === 3) {
        formatted.one = {
          back: runners[0].ex.availableToBack[0]?.price || '--',
          lay: runners[0].ex.availableToLay[0]?.price || '--'
        };
        formatted.x = {
          back: runners[1].ex.availableToBack[0]?.price || '--',
          lay: runners[1].ex.availableToLay[0]?.price || '--'
        };
        formatted.two = {
          back: runners[2].ex.availableToBack[0]?.price || '--',
          lay: runners[2].ex.availableToLay[0]?.price || '--'
        };
      }

      return formatted;
    } catch (err) {
      console.error('Error fetching odds:', err);
      return null;
    }
  };

  useEffect(() => {
    const fetchAllMatches = async () => {
      setIsLoading(true);
      try {
        const token = localStorage.getItem('token');
        let rawMarkets = [];

        if (activeTab === 'in-play') {
          // in-play
          if (sportTab === 'all-sports') {
            // For all-sports + in-play: call only the two aggregate endpoints
            const [inPlayRes, allMatchesRes] = await Promise.all([
              fetch('https://api.boss707.com/sports/allinplay', {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              }),
              fetch('https://api.boss707.com/sports/all-matches', {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              })
            ]);
            const inPlayData = await inPlayRes.json();
            const allMatchesData = await allMatchesRes.json();

            const collectMarkets = (arr) => Array.isArray(arr)
              ? arr.flatMap(s => s?.markets || [])
              : [];

            const inPlayMarkets = collectMarkets(inPlayData).map(m => ({ ...m, inplay: true }));
            const allMarkets = collectMarkets(allMatchesData);

            const map = new Map();
            inPlayMarkets.forEach(m => m?.marketId && map.set(m.marketId, m));
            allMarkets.forEach(m => {
              if (m?.marketId && !map.has(m.marketId)) map.set(m.marketId, m);
            });
            rawMarkets = Array.from(map.values());
          } else {
            // Per-sport in-play using sport IDs
            const tabToSportId = {
              'cricket': '4',
              'tennis': '2',
              'soccer': '1',
              'american-football': '6423',
              'baseball': '7511',
              'basketball': '7522',
              'boxing': '6',
              'darts': '3503',
              'gaelic-games': '2152880',
              'golf': '3',
              'greyhound-racing': '4339',
              'horse-racing': '7',
              'mma': '26420387',
              'motorsport': '8',
              'rugby-league': '1477',
              'rugby-union': '5',
              'snooker': '6422'
            };

            const fetchInplayById = async (sportId) => {
              const res = await fetch(`https://api.boss707.com/sports/inplayGameId/${sportId}`, {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              });
              const json = await res.json();
              const games = json?.games || json || [];
              const markets = Array.isArray(games)
                ? games.flatMap(g => g?.markets || [])
                : [];
              // tag as in-play explicitly
              return markets.map(m => ({ ...m, inplay: true }));
            };

            const sportId = tabToSportId[sportTab];
            const markets = sportId ? await fetchInplayById(sportId) : [];
            rawMarkets = markets || [];
          }
        } else {
          // today / tomorrow
          if (sportTab === 'all-sports') {
            const dateEndpoint = activeTab === 'today'
              ? 'matches-by-date/today'
              : 'matches-by-date/tomorrow';
            const res = await fetch(
              `https://api.boss707.com/sports/${dateEndpoint}`,
              { headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' } }
            );
            const data = await res.json();
            rawMarkets = data.flatMap(s => s.markets || []);
          } else {
            // sport-specific endpoints for today/tomorrow
            const tabToSportId = {
              'cricket': '4',
              'tennis': '2',
              'soccer': '1',
              'american-football': '6423',
              'baseball': '7511',
              'basketball': '7522',
              'boxing': '6',
              'darts': '3503',
              'gaelic-games': '2152880',
              'golf': '3',
              'greyhound-racing': '4339',
              'horse-racing': '7',
              'mma': '26420387',
              'motorsport': '8',
              'rugby-league': '1477',
              'rugby-union': '5',
              'snooker': '6422'
            };
            const sportId = tabToSportId[sportTab];
            const path = activeTab === 'today'
              ? `matches/today/${sportId}`
              : `matches/tomorrow/${sportId}`;
            const res = await fetch(
              `https://api.boss707.com/sports/${path}`,
              { headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' } }
            );
            const data = await res.json();
            rawMarkets = Array.isArray(data) ? data.flatMap(s => s?.markets || []) : (data?.markets || []);
          }
        }

        // map rawMarkets → our UI shape, then fetch odds
        const withOdds = await Promise.all(
          rawMarkets.map(async m => {
            const utcDate = new Date(m.marketStartTime);
            const timeStr = new Intl.DateTimeFormat('en-IN', {
              hour: '2-digit', minute: '2-digit', hour12: true
            }).format(utcDate);

            const match = {
              id: m.marketId,
              runners: m.runners,
              team1: m.runners[0]?.runnerName || '',
              team2: m.runners[1]?.runnerName || '',
              status: (m?.inplay ? 'In-Play' : timeStr),
              isLive: Boolean(m?.inplay),
              time: timeStr,
              date: utcDate,
              isSuspended: m.stopBet,
              eventid: m.version,
              odds: { one: { back: '--', lay: '--' }, x: { back: '--', lay: '--' }, two: { back: '--', lay: '--' } }
            };

            const odds = await fetchMatchOdds(match.id);
            if (odds) match.odds = odds;
            return match;
          })
        );

        // sort: in-play first, then by start time
        withOdds.sort((a, b) => {
          if (a.isLive && !b.isLive) return -1;
          if (!a.isLive && b.isLive) return 1;
          return new Date(a.date) - new Date(b.date);
        });

        setMobileMatches(withOdds);
      } catch (err) {
        console.error('Error fetching matches:', err);
      } finally {
        setIsLoading(false);
      }
    };

    fetchAllMatches();
  }, [sportTab, activeTab]);

  const handleMatchClick = m => {
    history.push({
      pathname: `/match/fullmarket/event/${m.id}`,
      state: {
        matchData: {
          ...m,
          matchTitle: `${m.team1} v ${m.team2}`
        }
      }
    });
  };

  return (
    <Container>
      <TabContainer>
        <TabButton active={activeTab==='in-play'} onClick={()=>handleTabClick('in-play')}>
          In-Play
        </TabButton>
        <TabButton active={activeTab==='today'} onClick={()=>handleTabClick('today')}>
          Today
        </TabButton>
        <TabButton active={activeTab==='tomorrow'} onClick={()=>handleTabClick('tomorrow')}>
          Tomorrow
        </TabButton>
      </TabContainer>

      <ContentContainer>
        {isLoading
          ? (
            <LoaderWrap>
              <LoaderSpinner />
            </LoaderWrap>
          ) : (
            <TabContent>
              {mobileMatches.length === 0 ? (
                <EmptyState>No matches found</EmptyState>
              ) : (
                mobileMatches.map((m,i) => (
                  <Match key={i}>
                    <MatchInfo>
                      <div style={{ display:'flex', alignItems:'center', gap:'8px' }}>
                        <IconGroup>
                          <img src='/assets/images/sports/cricket.png' style={{width:'20px',height:'20px'}}/>
                          <img src='/assets/images/sports/livestream.png' style={{width:'20px',height:'20px'}}/>
                          <img src='/assets/images/sports/watch.png' style={{width:'20px',height:'20px'}}/>
                        </IconGroup>
                        <Status status={m.status}>{m.status}</Status>
                      </div>
                      <div style={{ display:'flex', alignItems:'center', marginTop:'4px' }}>
                        <StatusDot isLive={m.isLive}/>
                        <MatchTitle onClick={()=>handleMatchClick(m)}>
                          {m.team1} v {m.team2}
                        </MatchTitle>
                      </div>
                    </MatchInfo>
                    <PTE>{m.odds.one.back}/{m.odds.one.lay}</PTE>
                  </Match>
                ))
              )}
            </TabContent>
          )
        }
      </ContentContainer>
    </Container>
  );
};

export default MobileSportsUI;
