import React, { useState } from 'react';
import styled from 'styled-components';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import {
  faBullseye,
  faFistRaised,
  faBasketball,
  faCircle,
  faCar
} from '@fortawesome/free-solid-svg-icons';
import CricketBettingUI from '../components/CricketUi';
import MobileSportsUI from './MobileHomeUi';

// Football SVG Icon Component
const FootballIcon = () => (
  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
    <path d="M12 15L9 12M9 12L12 9M9 12H15" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
  </svg>
);

// Cricket Icon
const CricketIcon = () => (
  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M7.3335 16.6667L17.3335 6.66675" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round"/>
    <path d="M12.3335 19.6667L15.3335 16.6667" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round"/>
    <path d="M4.3335 13.6667L7.3335 16.6667" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round"/>
    <circle cx="17.3335" cy="6.66675" r="2" stroke="currentColor" strokeWidth="1.5"/>
  </svg>
);

// Soccer/Football Icon
const SoccerIcon = () => (
  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="1.5"/>
    <path d="M12 2V6M12 6L7 10M12 6L17 10M7 10L5 16M7 10L12 12M17 10L19 16M17 10L12 12M5 16L12 12M19 16L12 12M5 16L9 20M19 16L15 20" stroke="currentColor" strokeWidth="1.5"/>
  </svg>
);

// Tennis Icon
const TennisIcon = () => (
  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="1.5"/>
    <path d="M12 2C14.5 4.5 15.5 8 15.5 12C15.5 16 14.5 19.5 12 22" stroke="currentColor" strokeWidth="1.5"/>
    <path d="M12 2C9.5 4.5 8.5 8 8.5 12C8.5 16 9.5 19.5 12 22" stroke="currentColor" strokeWidth="1.5"/>
  </svg>
);

// Multi Markets Icon
const MultiMarketsIcon = () => (
  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="4" y="4" width="6" height="6" rx="1" stroke="currentColor" strokeWidth="1.5"/>
    <rect x="4" y="14" width="6" height="6" rx="1" stroke="currentColor" strokeWidth="1.5"/>
    <rect x="14" y="4" width="6" height="6" rx="1" stroke="currentColor" strokeWidth="1.5"/>
    <rect x="14" y="14" width="6" height="6" rx="1" stroke="currentColor" strokeWidth="1.5"/>
  </svg>
);

const LayoutContainer = styled.div`
  width: 100%;
  background-color:rgb(18, 20, 24);
  min-height: 100vh;
  display: flex;
  flex-direction: column;
  position: relative;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const FixedHeader = styled.div`
  position: fixed;
  top: 62px;
  left: 0;
  right: 0;
  z-index: 100;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const TabContainer = styled.div`
  display: flex;
  background: rgb(50, 55, 56);
  overflow-x: auto;
  white-space: nowrap;
  -webkit-overflow-scrolling: touch;
  scrollbar-width: none;
  -ms-overflow-style: none;
  padding: 8px;
  font-family: 'Montserrat Alternates', sans-serif;
  
  &::-webkit-scrollbar {
    display: none;
  }
`;

const ScrollableContent = styled.div`
  margin-top: 70px; // Adjust this value based on your header height
  flex: 1;
  overflow-y: auto;
  height: calc(100vh - 60px);
  -webkit-overflow-scrolling: touch;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
  
  &::-webkit-scrollbar {
    width: 8px;
  }
  
  &::-webkit-scrollbar-track {
    background: rgb(50, 55, 56);
  }
  
  &::-webkit-scrollbar-thumb {
    background: rgb(240, 156, 6);
    border-radius: 4px;
  }
  
  &::-webkit-scrollbar-thumb:hover {
    background: rgb(220, 136, 6);
  }
`;

const TabContent = styled.div`
  height: 100%;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const TabButton = styled.div`
  display: inline-flex;
  align-items: center;
  gap: 8px;
  background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
  color: ${props => props.active ? '#000' : '#ffffff'};
  border: none;
  padding: 0.45rem 0.7rem;
  cursor: pointer;
  transition: all 0.3s ease;
  border-radius: 8px;
  flex-shrink: 0;
  font-weight: ${props => props.active ? 'bold' : 'normal'};
  font-family: 'Montserrat Alternates', sans-serif;
  font-size: 10px;
  
  img {
    width: 20px;
    height: 20px;
    filter: ${props => props.active ? 'brightness(0)' : 'brightness(1)'};
  }
  
  svg {
    width: 20px;
    height: 20px;
    color: ${props => props.active ? '#000' : 'rgb(240, 156, 6)'};
  }
  
  &:hover {
    background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'rgba(240, 156, 6, 0.1)'};
    color: ${props => props.active ? '#000' : 'rgb(240, 156, 6)'};
  }

  & + & {
    margin-left: 8px;
  }
`;

const ComingSoonContainer = styled.div`
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 3rem 1rem;
  color: #ffffff;
  text-align: center;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const ComingSoonText = styled.h2`
  font-size: 2rem;
  font-weight: 600;
  margin-bottom: 1rem;
  color: rgb(240, 156, 6);
  font-family: 'Montserrat Alternates', sans-serif;
`;

const ComingSoonSubtext = styled.p`
  font-size: 1rem;
  color: #ffffff;
  max-width: 400px;
  line-height: 1.5;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const NewsTickerContainer = styled.div`
  // background-color: rgb(50, 55, 56);
  color: white;
  padding: 8px 0;
  overflow: hidden;
  position: relative;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const NewsContent = styled.div`
  display: flex;
  align-items: center;
  white-space: nowrap;
  animation: ticker 20s linear infinite;
  font-family: 'Montserrat Alternates', sans-serif;
  
  @keyframes ticker {
    0% {
      transform: translateX(100%);
    }
    100% {
      transform: translateX(-100%);
    }
  }
`;

const NewsItem = styled.span`
  display: inline-flex;
  align-items: center;
  margin-right: 24px;
  font-size: 12px;
  color: #fff;
  font-family: 'Montserrat Alternates', sans-serif;
  
  &::before {
    content: "•";
    color: rgb(240, 156, 6);
    margin-right: 8px;
  }
`;

const LiveIndicator = styled.span`
  color: rgb(240, 156, 6);
  font-weight: 600;
  margin-right: 8px;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const SportsMobileView = () => {
  const [activeTab, setActiveTab] = useState('all-sports');

  const tabs = [
    { 
      id: 'all-sports', 
      label: 'All Sports', 
      icon: faBullseye, 
      type: 'icon' 
    },
    { 
      id: 'soccer', 
      label: 'Soccer', 
      icon: '/assets/images/sports-matches/football.svg',
      type: 'image'
    },
    { 
      id: 'tennis', 
      label: 'Tennis', 
      icon: '/assets/images/sports-matches/tennis.svg',
      type: 'image'
    },
    { 
      id: 'cricket', 
      label: 'Cricket', 
      icon: '/assets/images/sports-matches/cricket.svg',
      type: 'image'
    },
    { 
      id: 'mma', 
      label: 'Mixed Martial Arts', 
      icon: '/assets/images/sports-matches/mma.svg',
      type: 'image'
    },
    { 
      id: 'golf', 
      label: 'Golf', 
      icon: '/assets/images/sports-matches/golf.svg',
      type: 'image'
    },
    { 
      id: 'boxing', 
      label: 'Boxing', 
      icon: faFistRaised,
      type: 'icon'
    },
    { 
      id: 'american-football', 
      label: 'American Football', 
      icon: '/assets/images/sports-matches/american.svg',
      type: 'image'
    },
    { 
      id: 'baseball', 
      label: 'Baseball', 
      icon: '/assets/images/sports-matches/baseball.svg',
      type: 'image'
    },
    { 
      id: 'basketball', 
      label: 'Basketball', 
      icon: faBasketball,
      type: 'icon'
    },
    { 
      id: 'rugby-league', 
      label: 'Rugby League', 
      icon: faCircle,
      type: 'icon'
    },
    { 
      id: 'rugby-union', 
      label: 'Rugby Union', 
      icon: '/assets/images/sports-matches/rughbyunion.svg',
      type: 'image'
    },
    { 
      id: 'horse-racing', 
      label: 'Horse Racing', 
      icon: '/assets/images/sports-matches/horse.svg',
      type: 'image'
    },
    { 
      id: 'greyhound-racing', 
      label: 'Greyhound Racing', 
      icon: '/assets/images/sports-matches/grey.svg',
      type: 'image'
    },
    { 
      id: 'motorsport', 
      label: 'Motor Sport', 
      icon: faCar,
      type: 'icon'
    },
    { 
      id: 'snooker', 
      label: 'Snooker', 
      icon: '/assets/images/sports-matches/snooker.svg',
      type: 'image'
    },
    { 
      id: 'darts', 
      label: 'Darts', 
      icon: '/assets/images/sports-matches/dart.svg',
      type: 'image'
    },
    { 
      id: 'gaelic-games', 
      label: 'Gaelic Games', 
      icon: faCircle,
      type: 'icon'
    }
  ];

  const newsItems = [
  'Big Bash League 2024-25 is Live! Scratch to Unlock Incredible Rewards!'
  ];

  return (
    <LayoutContainer>
      <FixedHeader>
        <TabContainer>
          {tabs.map(tab => (
            <TabButton
              key={tab.id}
              active={activeTab === tab.id}
              onClick={() => setActiveTab(tab.id)}
            >
              {tab.type === 'icon' ? (
                <FontAwesomeIcon icon={tab.icon} />
              ) : (
                <img src={tab.icon} alt={tab.label} />
              )}
              {tab.label}
            </TabButton>
          ))}
        </TabContainer>
        <NewsTickerContainer>
          <NewsContent>
            {newsItems.map((news, index) => (
              <NewsItem key={index}>
                <LiveIndicator>LIVE</LiveIndicator>
                {news}
              </NewsItem>
            ))}
          </NewsContent>
        </NewsTickerContainer>
      </FixedHeader>

      <ScrollableContent>
        <TabContent>
          {activeTab === 'all-sports' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'cricket' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'soccer' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'tennis' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'mma' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'golf' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'boxing' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'american-football' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'baseball' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'basketball' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'rugby-league' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'rugby-union' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'horse-racing' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'greyhound-racing' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'motorsport' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'snooker' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'darts' && <MobileSportsUI tab={activeTab} />}
          {activeTab === 'gaelic-games' && <MobileSportsUI tab={activeTab} />}
        </TabContent>
      </ScrollableContent>
    </LayoutContainer>
  );
};

export default SportsMobileView;