import React, { useState, useMemo, useEffect } from 'react';
import { useLocation, useParams, useHistory } from 'react-router-dom';
import styled from 'styled-components';
import BetSlip from '../../BetSlip';
import CricketSchedule from '../../Today';
import SportsScheduleTomorrow from '../../Tomorrow';
import CricketBettingUI from '..';
import TabSwitcher from '../../TabSwitcher';
import MiddleDetailBettingUi from './Middle';
import LiveStreamFrame from '../../LiveStreamFrame';
import BettingTable from '../../MyBets';
import BettingHistoryTable from '../../BettingHistoryTable';
import { useBetting } from '../../../../../../context/BettingContext';
import { ExposureProvider } from '../../../../../../hooks/useExposure';
import SideMenu, { SPORT_ID_MAP } from './SideMenu';
import { useCallback } from 'react';

// Styled Components
const LayoutContainer = styled.div`
  display: flex;
  height: 100vh;
  width: 100%;
  overflow: hidden;
  font-family: 'Montserrat Alternates', sans-serif;
  background-color: #000000;
`;

const MainContent = styled.div`
  flex: 0 0 55%;
  background-color: #000000;
  display: flex;
  flex-direction: column;
  height: 100vh;
  min-height: 100vh;
  overflow: hidden;
  margin-bottom: 19px;
  font-family: 'Montserrat Alternates', sans-serif;
  border-bottom: 1px solid rgb(240, 156, 6);
`;

const ContentWrapper = styled.div`
  flex: 1;
  min-height: calc(100vh - 200px);
  overflow-y: auto;
  display: flex;
  flex-direction: column;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;

  &::-webkit-scrollbar {
    width: 3px;
  }
  
  &::-webkit-scrollbar-thumb {
    background-color: rgb(240, 156, 6);
    border-radius: 2px;
  }
`;

const Header = styled.div`
  background: #000000;
  position: relative;
  width: 100%;
  height: 200px;

  font-family: 'Montserrat Alternates', sans-serif;
`;

const BannerImage = styled.img`
  width: 100%
  height: 100%;
  object-fit: cover;
  object-position: center;
  // transition: transform 0.5s ease;
  
`;

const BannerOverlay = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  // background: rgba(0, 0, 0, 0.7);
  pointer-events: none;
`;

const Section = styled.div`
  flex: ${props => props.width};
  background-color: #000000;
  min-height: 100vh;
  height: 100vh;
  // border: ${props => props.borderLeft ? `1px solid ${props.borderLeft}` : 'none'};
  overflow-x: hidden;
  overflow-y: ${props => (props.scrollable ? 'auto' : 'hidden')};
  border-right: 1px solid rgb(240, 156, 6);
  font-family: 'Montserrat Alternates', sans-serif;

  &::-webkit-scrollbar {
    width: 3px;
  }
  
  &::-webkit-scrollbar-thumb {
    background-color: rgb(240, 156, 6);
    border-radius: 2px;
  }
`;

const TabContent = styled.div`
  animation: fadeIn 0.3s ease;
  flex: 1;
  margin-bottom: 12px;
  min-height: calc(100vh - 300px);
  overflow-y: auto;
  background-color: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
    z-index: 1;
  
  &::-webkit-scrollbar {
    width: 3px;
  }
  
  &::-webkit-scrollbar-thumb {
    background-color: rgb(240, 156, 6);
    border-radius: 2px;
  }
  
  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
`;

const MatchTitle = styled.div`
  color: #ffffff;
  font-size: 10px;
  padding: 16px;
  text-align: center;
  margin-bottom: 12px;
  flex-shrink: 0;
  font-family: 'Montserrat Alternates', sans-serif;
  background-color: rgb(50, 55, 56);
`;

const MatchTitle2 = styled.div`
  color: rgb(240, 156, 6);
  font-size: 14px;
  font-weight: bold;
  text-align: center;
  flex-shrink: 0;
  font-family: 'Montserrat Alternates', sans-serif;
`;


// Memoized Menu Component
const CricketBetUiComponent = () => {
  const location = useLocation();
  const [isLoading, setIsLoading] = useState(true);
  const history = useHistory();
  const { tab } = useParams();
  const [activeTab, setActiveTab] = useState('in-play');
  const [sideMenutab, setSideMenuTab] = useState('all-sports');
  const matchDataIS = location.state?.matchData;
  const { isMatchClicked } = useBetting()

  console.log("maamthed data is is", matchDataIS)
  useEffect(() => {
    if (matchDataIS) {
      setIsLoading(false);
    }
  }, [matchDataIS, tab, isMatchClicked]);

  useEffect(() => {
    if (tab) {
      setActiveTab(tab);
    }
  }, [tab]);

  const handleTabChange = (tab) => {
    console.log("tab value", tab)
    setActiveTab(tab);
  };
  const handleSideTabChange = (tab) => {
    console.log("tab value", tab)
    setSideMenuTab(tab);
  };

  const [shouldShowLiveStream, setShouldShowLiveStream] = useState(true);
  const [inplayMarkets, setInplayMarkets] = useState([]);
  const [isFetching, setIsFetching] = useState(false);

  useEffect(() => {
    const path = location.pathname;
    const excludedPaths = [
      '/sports/markets/in-play',
      '/sports/markets/today',
      '/sports/markets/tomorrow',
      '/sports/markets/history'
    ];

    setShouldShowLiveStream(!excludedPaths.includes(path));
  }, [location.pathname]);

  const fetchInplayBySport = useCallback(async (selectedTabId) => {
    setIsFetching(true);
    try {
      const token = localStorage.getItem('token');
      const sportId = SPORT_ID_MAP[selectedTabId];
      if (!sportId && selectedTabId !== 'all-sports') {
        setInplayMarkets([]);
        return;
      }

      const fetchOne = async (id) => {
        const res = await fetch(`https://api.boss707.com/sports/inplayGameId/${id}`, {
          headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
        });
        const json = await res.json();
        const games = json?.games || json || [];
        const markets = Array.isArray(games) ? games.flatMap(g => g?.markets || []) : [];
        return markets.map(m => ({ ...m, inplay: true }));
      };

      let markets = [];
      if (selectedTabId === 'all-sports') {
        // Use aggregate endpoints and merge (in-play preferred)
        const [inPlayRes, allMatchesRes] = await Promise.all([
          fetch('https://api.boss707.com/sports/allinplay', {
            headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
          }),
          fetch('https://api.boss707.com/sports/all-matches', {
            headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
          })
        ]);
        const inPlayData = await inPlayRes.json();
        const allMatchesData = await allMatchesRes.json();

        const collectMarkets = (arr) => Array.isArray(arr)
          ? arr.flatMap(s => s?.markets || [])
          : [];

        const inPlayMarkets = collectMarkets(inPlayData).map(m => ({ ...m, inplay: true }));
        const allMarkets = collectMarkets(allMatchesData);

        const map = new Map();
        inPlayMarkets.forEach(m => m?.marketId && map.set(m.marketId, m));
        allMarkets.forEach(m => {
          if (m?.marketId && !map.has(m.marketId)) map.set(m.marketId, m);
        });
        markets = Array.from(map.values());
      } else {
        markets = await fetchOne(sportId);
      }

      // map markets to lightweight list for potential header display
      const mapped = markets.map(m => ({
        id: m.marketId,
        team1: m.runners?.[0]?.runnerName || '',
        team2: m.runners?.[1]?.runnerName || '',
        inplay: Boolean(m.inplay),
        time: m.marketStartTime
      }));
      setInplayMarkets(mapped);
    } catch (e) {
      console.error('Failed to fetch inplay markets (web)', e);
      setInplayMarkets([]);
    } finally {
      setIsFetching(false);
    }
  }, []);

  useEffect(() => {
    if (activeTab === 'in-play') {
      fetchInplayBySport(sideMenutab);
    }
  }, [activeTab, sideMenutab, fetchInplayBySport]);

  useEffect(() => {
    if (matchDataIS) {
      setIsLoading(false);
    }
  }, [matchDataIS, tab, isMatchClicked]);

  useEffect(() => {
    if (tab) {
      setActiveTab(tab);
    }
  }, [tab]);

  const { matchData } = location.state || {};
  const renderMiddleContent = () => {
    switch (activeTab) {
      case 'in-play':
        return (
          <TabContent>
            <CricketBettingUI upperTab={activeTab} tab={sideMenutab} />
          </TabContent>
        );
      case 'today':
        return (
          <TabContent>
            <CricketBettingUI upperTab={activeTab} tab={sideMenutab} />
          </TabContent>
        );
      case 'tomorrow':
        return (
          <TabContent>
            <CricketBettingUI upperTab={activeTab} tab={sideMenutab} />
          </TabContent>
        );
      case 'history':
        return (
          <TabContent>
            <BettingHistoryTable />
          </TabContent>
        );
      default:
        return (
          <TabContent>
            <MiddleDetailBettingUi matchData={matchData} />
          </TabContent>
        );
    }
  };

  const middleSection = useMemo(() => (
    <Section width="0 0 70%" bg="#000000">
      {renderMiddleContent()}
    </Section>
  ), [activeTab]);

  const rightSection = useMemo(() => (
    <Section borderLeft="rgb(240, 156, 6)" width="0 0 30%" scrollable>
      {shouldShowLiveStream && <LiveStreamFrame id={matchDataIS?.eventId} />}
      <BetSlip />
      <BettingTable />
    </Section>
  ), [shouldShowLiveStream, matchDataIS?.eventId]);
  const rightSectionHistory = useMemo(() => (
    <Section width="0 0 30%" scrollable>
      <LiveStreamFrame />
      <BetSlip />

    </Section>
  ), []);



  useEffect(() => {
    if (!matchData) {
      // Handle case when no match data is available
      // Maybe redirect back or show error
    }
  }, [matchData]);

  const handleTabClick = (tab) => {
    setActiveTab(tab);

    history.push(`/sports/markets/${tab}`);
  };

  return (
    <LayoutContainer>
      <SideMenu
        activeTab={sideMenutab}
        onTabChange={handleSideTabChange}
      />

      <MainContent>
        <TabSwitcher
          activeTab={activeTab}
          onTabClick={handleTabClick}
        />
        {
          !matchData && (<Header>
            <BannerImage
              src="/assets/images/sport.jpg"
              alt="Sports Banner"
              loading="lazy"
            />
            <BannerOverlay />
          </Header>)
        }
        <div>

          <ContentWrapper style={{ 
  maxHeight: '400px', // Set a fixed height to enable scrolling
  overflowY: 'auto', // Enable vertical scrolling
  width: '100%' // Ensure full width
}}>
  {matchData && (
    <div style={{
      padding: '12px',
      width: "100%",
      display: 'flex',
      justifyContent: 'space-between',
      backgroundColor: 'rgb(50, 55, 56)',
      borderBottom: '1px solid rgb(240, 156, 6)'
    }}>
      <MatchTitle2>
        Live Score
      </MatchTitle2>

      <MatchTitle2>
        {matchData.team1} vs {matchData.team2}
      </MatchTitle2>
    </div>
  )}
  {renderMiddleContent()}
</ContentWrapper>
        </div>
      </MainContent>

      {rightSection}
    </LayoutContainer>
  );
};

export default CricketBetUiComponent;