import React, { useState } from 'react';
import styled from 'styled-components';
import { useBetting } from '../../../../../../../context/BettingContext';
import { sendNotfication } from '../../../../../../../Helper';

const Container = styled.div`
  width: 100%;
  background-color: #000000;
   font-family: 'Montserrat Alternates', sans-serif;
`;
const StatusBar = styled.div`
  background: rgb(50, 55, 56);
  color: white;
  padding: 12px 16px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-size: 12px;
  font-weight: bold;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
  position: relative;
   font-family: 'Montserrat Alternates', sans-serif;
  
  &::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: rgb(240, 156, 6);
  }
`;
const StatusTitle = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  font-weight: bold;
   font-family: 'Montserrat Alternates', sans-serif;
  
  svg {
    width: 18px;
    height: 18px;
    fill: rgb(240, 156, 6);
  }
`;
const StatusInfo = styled.div`
  display: flex;
  align-items: center;
  gap: 12px;
  font-size: 10px;
  color: #cccccc;
   font-family: 'Montserrat Alternates', sans-serif;
`;
const TabContainer = styled.div`
  display: flex;
  background: rgb(50, 55, 56);
  overflow-x: auto;
  white-space: nowrap;
  -webkit-overflow-scrolling: touch;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const Tab = styled.div`
  padding: 10px 15px;
  color: white;
  font-size: 10px;
  font-weight: bold;
  cursor: pointer;
  background: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
  border-bottom: 2px solid ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
   font-family: 'Montserrat Alternates', sans-serif;
`;

const MarketContainer = styled.div`
  display: flex;
  flex-direction: column;
  gap: 8px;
//   padding: 8px;
  background: #000000;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const MarketRow = styled.div`
  display: flex;
  flex-direction: column;
  background: ${props => props.selected === 'no' ? '#1a1a1a' : props.selected === 'yes' ? '#1a1a1a' : '#000000'};
  border-radius: 4px;
  overflow: hidden;
  transition: background-color 0.3s ease;
  position: relative;
   font-family: 'Montserrat Alternates', sans-serif;
  margin-bottom: 8px;
  border: 1px solid rgb(50, 55, 56);
`;

const MarketHeader = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 8px 12px;
  background: rgb(50, 55, 56);
  border-bottom: 1px solid rgb(50, 55, 56);
   font-family: 'Montserrat Alternates', sans-serif;
`;

const MarketTitle = styled.div`
  font-size: 11px;
  color: white;
  display: flex;
  align-items: center;
  gap: 8px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const InfoIcon = styled.span`
  color: #95a5a6;
  font-size: 16px;
`;

const OddsContainer = styled.div`
  display: grid;
  grid-template-columns: 1fr 90px 90px; /* match bookmaker sizing */
  gap: 0px;
  position: relative;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const OddsContainerHeader = styled.div`
  display: grid;
  grid-template-columns: 1fr 90px 90px; /* match bookmaker sizing */
  gap: 0px;
  position: relative;
  padding: 4px 0px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const OddsBox = styled.div`
  display: flex;
  width: 90px; /* fixed width to mirror bookmaker */
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 8px;
  background: ${props => (props.type === 'no' ? '#FFB6C1' : '#72BBEF')};
  cursor: pointer;
  transition: background-color 0.2s ease;
   font-family: 'Montserrat Alternates', sans-serif;

  .odds {
    font-weight: bold;
    font-size: 10px; /* match bookmaker */
    color: black;
  }

  .volume {
    font-size: 8px; /* match bookmaker */
    color: black;
  }
`;

const BetSlip = styled.div`
  background: #1a1a1a;
  padding: 12px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const BetInputContainer = styled.div`
  display: flex;
  gap: 8px;
  margin-bottom: 12px;
`;

const OddsDisplay = styled.div`
//   background: #1a1a1a;
  padding: 8px 16px;
  border: 1px solid rgb(50, 55, 56);
  border-radius: 4px;
  font-size: 12px;
  color: white;
  min-width: 100px;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
   font-family: 'Montserrat Alternates', sans-serif;

  .odds {
    font-weight: bold;
    font-size: 12px;
  }

  .volume {
    font-size: 8px;
    color: #cccccc;
    margin-top: 2px;
  }
`;

const AmountContainer = styled.div`
  flex: 1;
  display: flex;
  border: 1px solid rgb(50, 55, 56);
  border-radius: 4px;
  overflow: hidden;
  background: #1a1a1a;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AdjustButton = styled.div`
  width: 40px;
  border: none;
  background: rgb(50, 55, 56);
  color: white;
  font-size: 18px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AmountInput = styled.div`
  flex: 1;
  padding: 8px;
  text-align: center;
  font-size: 16px;
  color: white;
  min-width: 80px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const QuickAmounts = styled.div`
  display: grid;
  grid-template-columns: repeat(6, 1fr);
  gap: 4px;
  margin-bottom: 12px;
`;

const QuickAmount = styled.div`
  padding: 6px;
  background: #1a1a1a;
  border: 1px solid rgb(50, 55, 56);
  border-radius: 2px;
  font-size: 10px;
  cursor: pointer;
  text-align: center;
  color: white !important;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const Numpad = styled.div`
  display: grid;
  grid-template-columns: repeat(7, 1fr);
  gap: 4px;
  margin-bottom: 12px;
  color: white !important;
  text-align: center;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const NumpadButton = styled.div`
  padding: 12px;
  background: #1a1a1a;
  border: 1px solid rgb(50, 55, 56);
  border-radius: 2px;
  font-size: 12px;
  text-align: center;
  cursor: pointer;
  color: white;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const ActionButtons = styled.div`
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 8px;
  text-align: center;

`;

const Button = styled.div`
  padding: 12px;
  border-radius: 4px;
  text-align: center;
  font-size: 12px;
  cursor: pointer;
  border: 1px solid ${props => props.variant === 'primary' ? 'rgb(240, 156, 6)' : 'rgb(50, 55, 56)'};
  background: ${props => props.variant === 'primary' ? 'rgb(240, 156, 6)' : '#1a1a1a'};
  color: ${props => props.variant === 'primary' ? 'black' : 'white'};
  font-weight: ${props => props.variant === 'primary' ? 'bold' : 'normal'};
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AcceptOddsContainer = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  margin-top: 12px;
  font-size: 10px;
  color: white;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const StatusOverlay = styled.div`
  position: absolute;
  top: 0;
  left: calc(100% - 180px); /* cover the two right odds boxes (2 x 90px) */
  right: 0;
  bottom: 0;
  background: linear-gradient(to right, rgba(200, 200, 200, 0.85), rgba(180, 180, 180, 0.9));
  box-shadow: inset 0 0 20px rgba(160, 160, 160, 0.4), inset 0 0 40px rgba(140, 140, 140, 0.2);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 1;
  backdrop-filter: blur(1px);
  
  &::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(80, 80, 80, 0.15);
    z-index: -1;
  }

  &::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(
      45deg,
      rgba(120, 120, 120, 0.1),
      rgba(100, 100, 100, 0.2)
    );
    z-index: -2;
  }
`;

const StatusText = styled.span`
  color: white !important;
  font-weight: bold;
  font-size: 12px;
  text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
   font-family: 'Montserrat Alternates', sans-serif;
`;

const handleAmountChange = (currentAmount, change) => {
    const newAmount = Number(currentAmount) + change;
    return newAmount < 0 ? '0' : String(newAmount);
};

const FancyBetMobile = ({ data }) => {
    const [activeTab, setActiveTab] = useState('All');
    const [selectedBets, setSelectedBets] = useState({});
    const [betAmounts, setBetAmounts] = useState({});
    const [acceptAnyOdds, setAcceptAnyOdds] = useState({});
    const { placeBets } = useBetting();

    const tabs = ['All', 'Fancy', 'Ball by Ball', 'Khadda', 'Lottery', 'Odd/Even'];

    const markets = [
        { title: '20 Over SA', no: { odds: 59, volume: 140 }, yes: { odds: 59, volume: 50 }, status: 'active' },
        { title: '4th Wkt SA', no: { odds: 85, volume: 110 }, yes: { odds: 85, volume: 90 }, status: 'suspended' },
        { title: '4th Wkt Pship Boundaries SA', no: { odds: 5, volume: 100 }, yes: { odds: 6, volume: 100 }, status: 'ball_running' },
        { title: 'R Ricketon Runs', no: { odds: 45, volume: 110 }, yes: { odds: 45, volume: 90 }, status: 'active' },
        { title: 'Total Match Boundaries', no: { odds: 32, volume: 200 }, yes: { odds: 33, volume: 180 }, status: 'ball_running' },
        { title: '1st 6 Overs Runs SA', no: { odds: 92, volume: 150 }, yes: { odds: 93, volume: 130 }, status: 'active' },
        { title: 'D Miller Runs', no: { odds: 28, volume: 120 }, yes: { odds: 29, volume: 100 }, status: 'suspended' },
        { title: 'H Klaasen Runs', no: { odds: 41, volume: 160 }, yes: { odds: 42, volume: 140 }, status: 'active' },
        { title: 'Total Match Sixes', no: { odds: 15, volume: 180 }, yes: { odds: 16, volume: 160 }, status: 'ball_running' },
        { title: 'Total Match Wickets', no: { odds: 12, volume: 130 }, yes: { odds: 13, volume: 120 }, status: 'suspended' },
        { title: '1st Innings Score', no: { odds: 165, volume: 250 }, yes: { odds: 166, volume: 230 }, status: 'active' },
        { title: 'Highest Over Runs', no: { odds: 19, volume: 140 }, yes: { odds: 20, volume: 120 }, status: 'ball_running' }
    ];

    const quickAmounts = [100, 1000, 2000, 5000, 50000, 100000];

    const handleOddsClick = (market, type) => {
        const marketKey = `${market.title}-${type}`;
        const oppositeType = type === 'no' ? 'yes' : 'no';
        const oppositeKey = `${market.title}-${oppositeType}`;

        setSelectedBets(prev => {
            const newBets = { ...prev };
            delete newBets[oppositeKey];

            if (newBets[marketKey]) {
                delete newBets[marketKey];
            } else {
                newBets[marketKey] = { market, type };
            }

            return newBets;
        });

        if (!betAmounts[marketKey]) {
            setBetAmounts(prev => ({
                ...prev,
                [marketKey]: '100'
            }));
        }
    };

    return (
        <Container>
            <StatusBar>
                <StatusTitle>
                    <svg viewBox="0 0 24 24">
                        <path d="M3.5,18.5L9.5,12.5L13.5,16.5L22,6.92L20.59,5.5L13.5,13.5L9.5,9.5L2,17L3.5,18.5Z"/>
                    </svg>
                    Fancy Bet
                </StatusTitle>
                <StatusInfo>
                    <span>Active Markets: 8</span>
                    <span>•</span>
                    <span>Total Volume: ₹2.4M</span>
                </StatusInfo>
            </StatusBar>
            <TabContainer>
                {tabs.map(tab => (
                    <Tab
                        key={tab}
                        active={activeTab === tab}
                        onClick={() => setActiveTab(tab)}
                    >
                        {tab}
                    </Tab>
                ))}
            </TabContainer>

            <OddsContainerHeader>
                <div style={{ width: '100%', textAlign: 'center', color: 'white', fontSize: '10px', fontWeight: 'bold', padding: '8px 0',}}></div>
                <div style={{ width: '100%', textAlign: 'center', color: 'white', fontSize: '10px', fontWeight: 'bold', padding: '8px 0',}}>No</div>
                <div style={{ width: '100%', textAlign: 'center', color: 'white', fontSize: '10px', fontWeight: 'bold', padding: '8px 0',}}>Yes</div>
            </OddsContainerHeader>

            <MarketContainer>
                {markets.map((market, index) => {
                    const noKey = `${market.title}-no`;
                    const yesKey = `${market.title}-yes`;
                    const selectedType = selectedBets[noKey] ? 'no' : selectedBets[yesKey] ? 'yes' : null;

                    return (
                        <React.Fragment key={index}>

                            <MarketRow selected={selectedType}>
                                <MarketHeader>
                                    <MarketTitle>
                                        <span style={{ color: 'white', fontSize: '11px',}}>Market</span>
                                    </MarketTitle>
                                </MarketHeader>
                                <OddsContainer>
                                    <div style={{ width: '100%', backgroundColor: 'transparent', padding: '8px 12px', display: 'flex', alignItems: 'center', gap: '8px' }}>
                                        <span style={{ color: 'white', fontSize: '11px',}}>{market.title}</span>
                                        <span style={{ color: '#cccccc', fontSize: '12px',}}>ⓘ</span>
                                    </div>

                                    <OddsBox
                                        type="no"
                                        selected={selectedBets[noKey]}
                                        onClick={() => market.status === 'active' && handleOddsClick(market, 'no')}
                                    >
                                        <span className="odds">{market.no.odds}</span>
                                        <span className="volume">{market.no.volume}</span>
                                    </OddsBox>
                                    <OddsBox
                                        type="yes"
                                        selected={selectedBets[yesKey]}
                                        onClick={() => market.status === 'active' && handleOddsClick(market, 'yes')}
                                    >
                                        <span className="odds">{market.yes.odds}</span>
                                        <span className="volume">{market.yes.volume}</span>
                                    </OddsBox>
                                    
                                    {market.status !== 'active' && (
                                        <StatusOverlay>
                                            <StatusText>
                                                {market.status === 'suspended' ? 'SUSPENDED' : 'BALL RUNNING'}
                                            </StatusText>
                                        </StatusOverlay>
                                    )}
                                </OddsContainer>
                            </MarketRow>

                            {selectedBets[noKey] && (
                                <BetSlip type="no">
                                    <BetInputContainer>
                                        <OddsDisplay>
                                            {/* <span className="odds">{market.no.odds}</span>
                                            <span className="volume">{market.no.volume}</span> */}

                                            {`${market.no.odds}/${market.no.volume}`}
                                        </OddsDisplay>
                                        <AmountContainer>
                                            <AdjustButton onClick={() => {
                                                setBetAmounts(prev => ({
                                                    ...prev,
                                                    [noKey]: handleAmountChange(prev[noKey] || 0, -100)
                                                }));
                                            }}>-</AdjustButton>
                                            <AmountInput>{betAmounts[noKey]}</AmountInput>
                                            <AdjustButton onClick={() => {
                                                setBetAmounts(prev => ({
                                                    ...prev,
                                                    [noKey]: handleAmountChange(prev[noKey] || 0, 100)
                                                }));
                                            }}>+</AdjustButton>
                                        </AmountContainer>
                                    </BetInputContainer>

                                    <QuickAmounts>
                                        {quickAmounts.map(amount => (
                                            <QuickAmount
                                                key={amount}
                                                onClick={() => setBetAmounts(prev => ({
                                                    ...prev,
                                                    [noKey]: String(amount)
                                                }))}
                                            >
                                                {amount}
                                            </QuickAmount>
                                        ))}
                                    </QuickAmounts>

                                    <Numpad>
                                        {[1, 2, 3, 4, 5, 6, 7, 8, 9, 0, '00', '×'].map((num, i) => (
                                            <NumpadButton
                                                key={i}
                                                onClick={() => {
                                                    if (num === '×') {
                                                        setBetAmounts(prev => ({ ...prev, [noKey]: '0' }));
                                                    } else {
                                                        setBetAmounts(prev => ({
                                                            ...prev,
                                                            [noKey]: prev[noKey] === '0' ?
                                                                String(num) :
                                                                String(Number(prev[noKey] + num) || 0) // Ensures valid number or defaults to 0
                                                        }));
                                                    }
                                                }}
                                            >
                                                {num}
                                            </NumpadButton>
                                        ))}
                                    </Numpad>

                                    <ActionButtons>
                                        <Button onClick={() => {
                                            setSelectedBets(prev => {
                                                const newBets = { ...prev };
                                                delete newBets[noKey];
                                                return newBets;
                                            });
                                        }}>Cancel</Button>
                                        <Button
                                          variant="primary"
                                          onClick={async () => {
                                            const stake = parseFloat(betAmounts[noKey] || '0');
                                            const oddsNum = parseFloat(market.no.odds || '0');
                                            if (!stake || stake < 4 || !oddsNum || oddsNum <= 0) {
                                              
                                               sendNotfication('Enter valid stake (>=4) and odds (>0).', 'error', 'bottom-left')
                                              return;
                                            }
                                            if (!data || !data.id || !data.team1 || !data.team2) {
                                             
                                                sendNotfication('Match data missing', 'error', 'bottom-left')
                                              return;
                                            }

                                            const betRow = {
                                              market: 'FAN',
                                              matchId: data.id,
                                              matchTitle: `${data.team1} v ${data.team2}`,
                                              selectionName: `${market.title} - No`,
                                              category: 'fancy',
                                              type: 'lay',
                                              odds: oddsNum,
                                              stake: stake,
                                              liability: stake * (oddsNum / 100),
                                            };

                                            const result = await placeBets([betRow]);
                                            if (result?.confirmed?.length > 0) {
                                               sendNotfication('Bets placed successfully!', 'success', 'bottom-left')
                                              
                                              setSelectedBets(prev => { const p = { ...prev }; delete p[noKey]; return p; });
                                            } else {
                                            sendNotfication(result?.errors?.[0]?.message || 'Bet placement failed', 'error', 'bottom-left');
                                            }
                                          }}
                                        >
                                          Place Bet
                                        </Button>
                                    </ActionButtons>

                                    <AcceptOddsContainer>
                                        <input
                                            type="checkbox"
                                            checked={acceptAnyOdds[noKey] || false}
                                            onChange={() => setAcceptAnyOdds(prev => ({
                                                ...prev,
                                                [noKey]: !prev[noKey]
                                            }))}
                                        />
                                        <span>Accept Any Odds</span>
                                    </AcceptOddsContainer>
                                </BetSlip>
                            )}

                            {selectedBets[yesKey] && (
                                <BetSlip type="yes">
                                    <BetInputContainer>
                                        <OddsDisplay>
                                        
                                            {`${market.yes.odds}/${market.yes.volume}`}
                                        </OddsDisplay>
                                        <AmountContainer>
                                            <AdjustButton onClick={() => {
                                                setBetAmounts(prev => ({
                                                    ...prev,
                                                    [yesKey]: handleAmountChange(prev[yesKey] || 0, -100)
                                                }));
                                            }}>-</AdjustButton>
                                            <AmountInput>{betAmounts[yesKey]}</AmountInput>
                                            <AdjustButton onClick={() => {
                                                setBetAmounts(prev => ({
                                                    ...prev,
                                                    [yesKey]: handleAmountChange(prev[yesKey] || 0, 100)
                                                }));
                                            }}>+</AdjustButton>
                                        </AmountContainer>
                                    </BetInputContainer>

                                    <QuickAmounts>
                                        {quickAmounts.map(amount => (
                                            <QuickAmount
                                                key={amount}
                                                onClick={() => setBetAmounts(prev => ({
                                                    ...prev,
                                                    [yesKey]: String(amount)
                                                }))}
                                            >
                                                {amount}
                                            </QuickAmount>
                                        ))}
                                    </QuickAmounts>

                                    <Numpad>
                                        {[1, 2, 3, 4, 5, 6, 7, 8, 9, 0, '00', '×'].map((num, i) => (
                                            <NumpadButton
                                                key={i}
                                                onClick={() => {
                                                    if (num === '×') {
                                                        setBetAmounts(prev => ({ ...prev, [yesKey]: '0' }));
                                                    } else {
                                                        setBetAmounts(prev => ({
                                                            ...prev,
                                                            [yesKey]: prev[yesKey] === '0' ?
                                                                String(num) :
                                                                String(Number(prev[yesKey] + num) || 0) // Ensures valid number or defaults to 0
                                                        }));
                                                    }
                                                }}
                                            >
                                                {num}
                                            </NumpadButton>
                                        ))}
                                    </Numpad>

                                    <ActionButtons>
                                        <Button onClick={() => {
                                            setSelectedBets(prev => {
                                                const newBets = { ...prev };
                                                delete newBets[yesKey];
                                                return newBets;
                                            });
                                        }}>Cancel</Button>
                                        <Button
                                          variant="primary"
                                          onClick={async () => {
                                            const stake = parseFloat(betAmounts[yesKey] || '0');
                                            const oddsNum = parseFloat(market.yes.odds || '0');
                                            if (!stake || stake < 4 || !oddsNum || oddsNum <= 0) {
                                              alert('Enter valid stake (>=4) and odds (>0).');
                                              return;
                                            }
                                            if (!data || !data.id || !data.team1 || !data.team2) {
                                              alert('Match data missing');
                                              return;
                                            }

                                            const betRow = {
                                              market: 'FAN',
                                              matchId: data.id,
                                              matchTitle: `${data.team1} v ${data.team2}`,
                                              selectionName: `${market.title} - Yes`,
                                              category: 'fancy',
                                              type: 'back',
                                              odds: oddsNum,
                                              stake: stake,
                                              liability: stake * (oddsNum / 100),
                                            };

                                            const result = await placeBets([betRow]);
                                            if (result?.confirmed?.length > 0) {
                                              alert('Bet placed successfully!');
                                              setSelectedBets(prev => { const p = { ...prev }; delete p[yesKey]; return p; });
                                            } else {
                                              alert(result?.errors?.[0]?.message || 'Bet placement failed');
                                            }
                                          }}
                                        >
                                          Place Bet
                                        </Button>
                                    </ActionButtons>

                                    <AcceptOddsContainer>
                                        <input
                                            type="checkbox"
                                            checked={acceptAnyOdds[yesKey] || false}
                                            onChange={() => setAcceptAnyOdds(prev => ({
                                                ...prev,
                                                [yesKey]: !prev[yesKey]
                                            }))}
                                        />
                                        <span>Accept Any Odds</span>
                                    </AcceptOddsContainer>
                                </BetSlip>
                            )}
                        </React.Fragment>
                    );
                })}
            </MarketContainer>
        </Container>
    );
};

export default FancyBetMobile;