import React from 'react'
import styled from 'styled-components'
import { useBetting } from '../../../../../context/BettingContext'

// Define styled components outside of the main component
const StyledTable = styled.table`
  width: 100%;
  border-collapse: collapse;
  font-family: 'Montserrat Alternates', sans-serif;
  background: #000000;

  @media (max-width: 768px) {
    border-collapse: separate;
    border-spacing: 0;
  }
`

const StyledHeader = styled.div`
  background: rgb(50, 55, 56);
  color: rgb(240, 156, 6);
  padding: 14px 8px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-size: 14px;
  font-weight: bold;
  font-family: 'Montserrat Alternates', sans-serif;
`

const StyledTableHeader = styled.thead`
  background-color: rgb(50, 55, 56);
  color: #ffffff;
  font-family: 'Montserrat Alternates', sans-serif;

  @media (max-width: 768px) {
    display: none;
  }
`

const StyledTableHeaderCell = styled.th`
  padding: 3px 16px;
  text-align: left;
  font-weight: bold;
  color: #ffffff !important;
  font-family: 'Montserrat Alternates', sans-serif;
`

const StyledTableRow = styled.tr`
  background-color: #000000;
  margin-left:4px;
  border-bottom: 1px solid rgb(50, 55, 56);
  font-family: 'Montserrat Alternates', sans-serif;

  @media (max-width: 768px) {
    display: block;
    margin: 8px 8px 12px 8px;
    border: 1px solid rgb(50, 55, 56);
    border-radius: 6px;
    overflow: hidden;
  }
`

const StyledTableCell = styled.td`
  padding: 2px 10px;
  color: #ffffff;
  font-family: 'Montserrat Alternates', sans-serif;

  @media (max-width: 768px) {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 12px;
    border-bottom: 1px solid rgb(50, 55, 56);
    font-size: 12px;
    min-width: 0;
    gap: 8px;

    &:last-child {
      border-bottom: none;
    }

    &::before {
      content: attr(data-label);
      color: rgb(240, 156, 6);
      font-weight: 600;
      margin-right: 12px;
      text-transform: none;
      flex: 0 0 auto;
    }
  }
`

const CellValue = styled.span`
  display: block;
  max-width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;

  @media (max-width: 768px) {
    flex: 1 1 auto;
    min-width: 0;
    text-align: right;
  }
`

function BettingTable() {
    const { placedBets } = useBetting();
    console.log('BettingTable: placedBets:', placedBets);

    return (
        <div style={{ width: '100%', background: '#000000', marginLeft: '3px' }}>
            <StyledHeader>My Bets</StyledHeader>

            <StyledTable>
                <StyledTableHeader>
                    <tr>
                        <StyledTableHeaderCell>Selection</StyledTableHeaderCell>
                        <StyledTableHeaderCell>Odds</StyledTableHeaderCell>
                        <StyledTableHeaderCell>Stake</StyledTableHeaderCell>
                    </tr>
                </StyledTableHeader>
                <tbody>
                    {placedBets.map((bet) => (
                        <StyledTableRow key={bet.id} type={bet.type}>
                            <StyledTableCell data-label="Selection" style={{ marginLeft: '4px' }}>
                                <CellValue title={bet.selectionName}>{bet.selectionName}</CellValue>
                            </StyledTableCell>
                            <StyledTableCell data-label="Odds" style={{ marginLeft: '4px' }}>{bet.odds.toFixed(2)}</StyledTableCell>
                            <StyledTableCell data-label="Stake" style={{ marginLeft: '4px' }}>{bet.stake}</StyledTableCell>
                        </StyledTableRow>
                    ))}
                </tbody>
            </StyledTable>
        </div>
    )
}

export default BettingTable

