import React from 'react';
import styled from 'styled-components';
import { useHistory } from 'react-router-dom';
import { History } from 'lucide-react';
import { useExposure } from '../../../../../hooks/useExposure';

const TabContainer = styled.div`
  display: flex;
  gap: 4px;
  background: #000000;
  height: 48px;
  padding: 0 16px;
  align-items: center;
  border-bottom: 1px solid rgb(50, 55, 56);
`;

const TabButton = styled.button`
  padding: 12px 20px;
  background: ${props => props.active ? 'rgb(50, 55, 56)' : 'transparent'};
  color: ${props => props.active ? 'rgb(240, 156, 6)' : '#cccccc'};
  border: none;
  cursor: pointer;
  font-weight: bold;
  font-size: 14px;
  font-family: 'Montserrat Alternates', sans-serif;
  transition: all 0.3s ease;
  border-radius: 8px 8px 0 0;
  position: relative;
  min-width: 80px;

  &:hover {
    background-color: ${props => props.active ? 'rgb(60, 65, 66)' : 'rgb(50, 55, 56)'};
    color: ${props => props.active ? 'rgb(240, 156, 6)' : '#ffffff'};
  }

  &:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background-color: ${props => props.active ? 'rgb(240, 156, 6)' : 'transparent'};
    border-radius: 8px 8px 0 0;
    transition: all 0.3s ease;
  }
`;

const HistoryButton = styled.button`
  background: transparent;
  border: none;
  color: #cccccc;
  cursor: pointer;
  padding: 8px;
  margin-left: auto;
  display: flex;
  align-items: center;
  transition: color 0.2s ease;
  font-family: 'Montserrat Alternates', sans-serif;

  &:hover {
    color: 'rgb(240, 156, 6)';
  }
`;

const ExposureText = styled.span`
  color: 'rgb(240, 156, 6)';
  margin-left: auto;
  margin-right: 16px;
  font-size: 14px;
  font-weight: bold;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const TabSwitcher = ({ activeTab, onTabClick }) => {
  const history = useHistory();
  const { exposure ,totalExposure} = useExposure();
  
  const handleHistoryClick = () => {
    history.push('/sports/markets/history');
  };

  return (
    <TabContainer>
      <TabButton 
        active={activeTab === 'in-play'}
        onClick={() => onTabClick('in-play')}
      >
        In-Play
      </TabButton>
      <TabButton
        active={activeTab === 'today'}
        onClick={() => onTabClick('today')}
      >
        Today
      </TabButton>
      <TabButton
        active={activeTab === 'tomorrow'}
        onClick={() => onTabClick('tomorrow')}
      >
        Tomorrow
      </TabButton> 
      <ExposureText>Exposure: {totalExposure}</ExposureText>
      <HistoryButton onClick={handleHistoryClick}>
        <History size={20} />
      </HistoryButton>
    </TabContainer>
  );
};

export default TabSwitcher;





