import React, { useState, useEffect } from 'react';
import PropTypes from "prop-types";
import { connect } from "react-redux";
import Cookies from "js-cookie";
import SidebarHello from '../Components/HelloGameLayoutComponent/SidebarHello';
import Header from '../Components/HelloGameLayoutComponent/HederHello';
import styled from 'styled-components';
import { Event, decode, encode, wait, isMobile, sendNotfication, getUID } from "../../Helper";
import WalletAlert from "../../App/Components/User/Wallet/Alert";
import C from "../../Constant";
import storage from "../../Storage"
import UserHeader from './Parts/Header/Header-User';
import GuestHeader from './Parts/Header/Header-Guest';
import socket from "../../Socket";
import MobileMenu from './Parts/Menu/MobileMenu';
import HelloFooter from '../Components/HelloGameLayoutComponent/HelloFooter';
import SkylaSidebar from '../Components/SkylaSiebar';
import { useSidebar } from '../../context/SidebarContext';
import BottomNavigation from '../Components/SkylaBottomTab';
import { useLocation } from 'react-router-dom';

// Always initialize coin to INR if not set
if (!storage.getKey('coin') || storage.getKey('coin') !== 'INR') {
  storage.setKey('coin', 'INR');
}

const SIDEBAR_WIDTH = 245;
const HEADER_HEIGHT = 60;

const AppContainer = styled.div`
  // display: flex;
  // background: rgb(18, 20, 24);
  color: white;
  font-family: Arial, sans-serif;
`;

const MainArea = styled.div`
  flex: 1;
  padding-top:60px;
  min-height: 100vh;
  width: ${props => (props.$isSmallScreen || props.$isSportsRoute) ? '100vw' : `calc(100vw - ${SIDEBAR_WIDTH}px)`};
  overflow-x: hidden;
  z-index:-1;
  margin: ${props => {
    if (props.$isSportsRoute || props.$isSmallScreen) {
      return '0px';
    }
    return props.$isCollapsed ? '0px 120px 0px 170px' : '0px 20px 0px 250px';
  }};
`;

const ContentContainer = styled.div`
  padding: 0px 24px;
  margin-top: 20px;
  min-height: calc(100vh - ${HEADER_HEIGHT}px);

  @media (max-width: 768px) {
    padding: 4px 10px;
    margin-top: 5px;
  }
`;

const HeaderMainConatiner = styled.div`
position:fixed;
top: 0;
// left: ${props => props.isSmallScreen ? '0px' : props.isCollapsed ? '80px' : '239px'};
left:0;
right: 0;
z-index: 666;
  width: 100% !important;
`;

const Index = ({ get_wallet, content }) => {
  const [auth, setAuth] = useState(false);
  const { isCollapsed } = useSidebar();
  const [isCollapsedMobile, setIsCollapsedMobile] = useState(false);
  const [isSmallScreen, setIsSmallScreen] = useState(window.innerWidth <= 768);
  const [header, setHeader] = useState(<GuestHeader />);

  const uid = getUID();

  const getUserInfo = (data) => {
    if (data.status) {
      // you can handle user info here if needed
    }
  };

  const location = useLocation();
  const isSportsRoute = () => {
    const path = location.pathname;
    return path.startsWith('/sports/') || path.startsWith('/match/');
  };

  useEffect(() => {
    if (uid) {
      socket.on(C.USER_INFO, (data) => getUserInfo(decode(data)));
      socket.emit(C.USER_INFO, encode({
        id: uid,
        coin: storage.getKey('coin') || '',
        rate: null,
        game: 'all',
        first: true
      }));
    }
  }, [uid]);

  useEffect(() => {
    scrollToTop();

    const handleResize = () => {
      setIsSmallScreen(window.innerWidth <= 768);
    };

    const handleRouteChange = () => {
      scrollToTop();
    };

    socket.on(C.ONLINE, (status) => onlineUser(decode(status)));

    Event.on('showAuthModal', () => {
      sendNotfication("Please Login or Register!", 'success', 'bottom-left', true);
    });

    const sessionCookie = Cookies.get("session");
    if (sessionCookie) {
      socket.emit(C.ONLINE, encode({
        jwt_token: storage.getKey('jwt_token'),
        user_token: storage.getKey('user_token'),
        security_key: storage.getKey('security_key'),
        secret_user: storage.getKey('secret_user'),
        secret_realtime: storage.getKey('secret_realtime'),
        client_system: storage.getKey('client_system'),
        token_key: storage.getKey('token_key'),
        secret_token: storage.getKey('secret_token')
      }));
    }

    window.addEventListener('resize', handleResize);
    window.addEventListener('popstate', handleRouteChange);

    return () => {
      window.removeEventListener('resize', handleResize);
      window.removeEventListener('popstate', handleRouteChange);
      socket.off(C.ONLINE);
      socket.off(C.USER_INFO);
      // Event.off('showAuthModal');
    };
  }, [content]);

  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: 'instant' });
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  };

  const onlineUser = (data) => {
    wait(500).then(() => {
      if (data.status === true) {
        storage.setKey('logged', true);
        Cookies.set("uid", data.id, { expires: 14 });
        Cookies.set("auth", true, { expires: 14 });
        storage.setKey('name', data.name);
        storage.setKey('email', data.email);
        storage.setKey('credit', data.credit);
        storage.setKey('avatar', data.avatar);
        storage.setKey('friends', data.friends);
        storage.setKey('room', data.room);

        wait(100).then(() => {
          setHeader(
            <UserHeader
              isCollapsedMobile={isCollapsedMobile}
              setIsCollapsedMobile={setIsCollapsedMobile}
            />
          );
        });
      } else {
        wait(1000).then(() => {
          localStorage.clear();
          setHeader(<GuestHeader />);
        });
      }
    });
  };

  return (
    <>
      <AppContainer>
        <MainArea $isSmallScreen={isSmallScreen} $isCollapsed={isCollapsed} $isSportsRoute={isSportsRoute()}>
          <HeaderMainConatiner>
            {header}
          </HeaderMainConatiner>
          <ContentContainer>
            {content}
          </ContentContainer>
        </MainArea>
      </AppContainer>
      <HelloFooter />
      <BottomNavigation />
    </>
  );
};

Index.propTypes = {
  get_wallet: PropTypes.string,
  content: PropTypes.node,
};

const mapStateToProps = state => ({
  get_wallet: state.items.get_wallet
});

export default connect(mapStateToProps)(Index);
