import React from 'react';
import styled from 'styled-components';

const StyledSVG = styled.svg`
  width: ${props => props.size || '23px'};
  height: ${props => props.size || '23px'};
  fill: ${props => props.fill || 'currentColor'};
  flex: none;
`;

const SkylaLivecasino = ({ size, fill, className }) => {
  return (
    <StyledSVG 
      viewBox="0 0 32 32"
      className={`icon flex-none ${className || ''}`}
      size={size}
      fill={fill}
    >
      <path d="M27.5683 12.516C27.5683 10.9239 27.5737 10.3703 27.5655 8.7791C27.5601 7.63475 26.6057 6.59535 25.4677 6.52931C24.6671 6.48317 23.862 6.5076 23.0587 6.49946C22.9701 6.49946 22.8823 6.49946 22.7774 6.49946C22.7774 6.31039 22.7792 6.15841 22.7774 6.00644C22.772 5.67806 22.7828 5.34697 22.753 5.0204C22.6987 4.4333 22.2355 4.0208 21.6475 4.00451C20.932 3.98461 20.4308 4.3356 20.3566 4.96432C20.306 5.38768 20.3295 5.81828 20.3204 6.24707C20.3186 6.32667 20.3204 6.40718 20.3204 6.48317H11.6388C11.6388 6.29411 11.6406 6.11861 11.6388 5.94492C11.6343 5.60117 11.6687 5.25018 11.6117 4.91456C11.5031 4.28495 10.9432 3.93848 10.2267 4.00904C9.63689 4.06603 9.2099 4.54276 9.20267 5.16062C9.19724 5.59574 9.20176 6.02996 9.20176 6.49946C8.43284 6.49946 7.69828 6.49584 6.96464 6.50217C6.74391 6.50398 6.51776 6.5085 6.30336 6.55464C5.18254 6.79165 4.42899 7.73879 4.42899 8.89308C4.42808 14.2801 4.44075 19.668 4.41994 25.055C4.41451 26.4255 5.51182 27.5246 6.8977 27.5201C12.9659 27.4984 19.0341 27.4984 25.1032 27.5201C26.4872 27.5246 27.5891 26.4228 27.58 25.0541C27.5547 21.2203 27.571 16.3489 27.571 12.5151L27.5683 12.516ZM21.0206 16.6022C20.4733 17.1341 19.9269 17.6651 19.3932 18.2088C19.3172 18.2857 19.2566 18.4341 19.2729 18.5363C19.3887 19.3061 19.5171 20.0751 19.6574 20.8413C19.7306 21.2429 19.6239 21.5749 19.3082 21.8201C18.9879 22.067 18.6297 22.0788 18.2715 21.8924C17.5885 21.5387 16.9037 21.185 16.2261 20.8205C16.0615 20.7309 15.9339 20.7309 15.7693 20.8205C15.1243 21.1687 14.4694 21.498 13.8235 21.8436C13.4462 22.0453 13.0708 22.1023 12.7108 21.8382C12.358 21.5785 12.2648 21.2212 12.3462 20.7897C12.4873 20.0524 12.6068 19.3097 12.7162 18.567C12.7325 18.4549 12.6809 18.2939 12.6022 18.2133C12.0821 17.6814 11.5493 17.1613 11.0119 16.6465C10.6944 16.3435 10.5243 15.9916 10.6663 15.561C10.8129 15.115 11.1747 14.9513 11.6189 14.8934C12.3634 14.7966 13.107 14.6826 13.8479 14.5578C13.9393 14.5424 14.0406 14.4329 14.0876 14.3407C14.435 13.6649 14.7706 12.9819 15.108 12.3017C15.2935 11.9271 15.5721 11.6946 16.019 11.6928C16.4315 11.7055 16.702 11.9353 16.882 12.3007C17.214 12.9738 17.5532 13.6441 17.8816 14.319C17.9603 14.4818 18.0553 14.5578 18.2498 14.5822C18.9861 14.6736 19.7189 14.7939 20.4534 14.9024C20.865 14.963 21.1925 15.1476 21.3264 15.5592C21.4585 15.9654 21.3201 16.3118 21.0179 16.604L21.0197 16.6031L21.0206 16.6022Z" />
    </StyledSVG>
  );
};

export default SkylaLivecasino;