import React from 'react';
import styled from 'styled-components';

const StyledSVG = styled.svg`
  width: ${props => props.size || '24px'};
  height: ${props => props.size || '24px'};
  flex: none;
  transition: transform 0.2s ease;
  
  & path {
    fill: ${props => props.fill || 'currentColor'};
  }
`;

const SkylaSlot = ({ size, fill, className }) => {
  return (
    <StyledSVG 
      viewBox="0 0 32 32"
      xmlns="http://www.w3.org/2000/svg"
      size={size}
      fill={fill}
      className={className}
    >
      <path d="M21.6586 6.02637C22.872 6.02637 23.9549 7.46958 24.6628 9.72807L24.6718 9.7272L24.7842 10.1452C25.6801 13.69 25.618 18.6796 24.4001 23.0292C23.7004 24.8488 22.7299 25.9746 21.6577 25.9746L21.5921 25.9703L21.593 25.9746L10.241 25.9677C9.239 25.8705 8.33505 24.7881 7.67035 23.0856L7.66046 23.0847C6.69355 18.7282 6.64228 13.5529 7.34925 9.98046L7.44369 9.53552H7.44819C8.14346 7.42795 9.17334 6.07667 10.3255 6.0281V6.02637H21.6586ZM6.95169 9.53466C6.27081 11.7524 5.9569 14.0508 6.01267 16.4281C6.06304 18.6363 6.41112 20.7464 7.05693 22.7586L7.16486 23.0821H6.51906C5.55575 23.0821 4.8182 21.6805 4.42514 19.6814C3.40336 19.174 2.6748 17.8461 2.6748 16.2884C2.6748 14.7516 3.38357 13.4402 4.38286 12.9163C4.76423 10.8929 5.52067 9.53379 6.52086 9.53379H6.95349L6.95169 9.53466ZM25.5406 9.72893C26.477 9.84342 27.2856 11.0924 27.7236 13.0109C28.6392 13.5833 29.2725 14.8366 29.2725 16.2884C29.2725 17.7178 28.659 18.9546 27.7686 19.54C27.3656 21.4628 26.5975 22.7603 25.6935 22.9902L25.5415 23.0179L25.5397 23.0275L24.8544 23.0283L25.0136 22.6337C25.7214 20.782 26.1217 18.7664 26.2116 16.5868C26.3106 14.2034 25.9499 11.918 25.1287 9.72807H25.5397L25.5406 9.7272V9.72893ZM13.7668 12.0559L13.4529 12.1722L12.9906 12.3742C12.8629 12.3985 12.7864 12.3274 12.7603 12.1609C12.7343 11.9944 12.6191 11.9068 12.415 11.8998C12.0309 11.8998 11.7134 11.9172 11.4633 11.9527C11.2484 11.9822 11.1377 12.0837 11.1296 12.2554L11.1341 12.3474L11.0307 15.3092C11.0181 15.4289 11.0307 15.5174 11.0694 15.5764C11.0955 15.6163 11.1332 15.6414 11.1818 15.6544L11.2646 15.6631L12.4572 15.6397C12.5265 15.6605 12.5859 15.6501 12.6389 15.6085C12.6731 15.5816 12.7046 15.5391 12.7325 15.4844L12.7702 15.3916L12.9276 15.1288C13.0725 14.8843 13.2649 14.7134 13.5042 14.6171C13.7039 14.5373 13.9737 14.5243 14.3155 14.5772L14.5296 14.6171L16.2592 15.0967C16.7008 15.1644 17.1389 15.1644 17.5724 15.0967C18.0059 15.0291 18.4098 14.8895 18.784 14.6796C18.6535 14.8305 18.4629 15.0022 18.2128 15.1922C17.9628 15.3821 17.6507 15.5929 17.2792 15.8227C17.0453 15.9354 16.8016 16.0655 16.5479 16.2147C16.2943 16.3639 16.0307 16.5313 15.7582 16.7169C15.4713 16.9294 15.2212 17.1453 15.0108 17.3656C14.8003 17.5859 14.6276 17.8088 14.4936 18.0352C14.3191 18.3023 14.1806 18.612 14.0825 18.9632C13.9845 19.3145 13.9233 19.7091 13.9008 20.1454C13.8856 20.2607 13.9035 20.3466 13.9539 20.403C13.9917 20.4455 14.0484 20.4698 14.1239 20.4784L14.2058 20.481L18.3936 20.4888C18.5843 20.5071 18.7165 20.4993 18.7903 20.4663C18.846 20.442 18.8703 20.4012 18.8613 20.3475L18.8415 20.2885L18.7696 19.9129C18.7372 19.658 18.7228 19.3735 18.7273 19.0595C18.7318 18.7455 18.7534 18.4012 18.7948 18.0274C18.8388 17.7039 18.9027 17.3865 18.9845 17.0777C19.0664 16.7689 19.1662 16.4671 19.2832 16.1731C19.4037 15.8522 19.5386 15.5347 19.6879 15.2234C19.8372 14.912 20.0018 14.605 20.179 14.3032C20.2807 14.1011 20.4264 13.8643 20.617 13.5928C20.8077 13.3214 21.0425 13.0161 21.3213 12.6761C21.3861 12.6119 21.4185 12.5546 21.4185 12.5061C21.4185 12.4731 21.4041 12.4428 21.3762 12.4159L21.3231 12.3786L21.0704 12.265L20.5505 11.9536C20.4785 11.9059 20.4174 11.8885 20.3634 11.899C20.3094 11.9094 20.2654 11.9493 20.2303 12.0178C20.1664 12.0993 20.0837 12.167 19.9793 12.219C19.875 12.271 19.7509 12.3075 19.6061 12.33C19.41 12.3612 19.2148 12.3777 19.0187 12.3794C18.8226 12.3812 18.6266 12.3673 18.4296 12.3378C17.5292 12.1687 16.6855 12.0143 15.8994 11.8747C15.2113 11.7524 14.5026 11.814 13.7731 12.0577H13.7686L13.7668 12.0559Z" />
    </StyledSVG>
  );
};

export default SkylaSlot;