class LocalStorageService {
    ls = window.localStorage;

    // Set a key-value pair in localStorage
    setKey(key, value) {
        try {
            this.ls.setItem(key, value);
            return true;
        } catch (e) {
            console.error('Error setting localStorage key:', e);
            return false;
        }
    }

    // Get a value by key from localStorage
    getKey(key) {
        try {
            let value = this.ls.getItem(key);
            return value;
        } catch (e) {
            console.error('Error getting localStorage key:', e);
            return null;
        }
    }

    // Remove a key from localStorage
    removeKey(key) {
        try {
            this.ls.removeItem(key);
            return true;
        } catch (e) {
            console.error('Error removing localStorage key:', e);
            return false;
        }
    }

    // Get all keys stored in localStorage
    getAllKeys() {
        try {
            const keys = [];
            for (let i = 0; i < this.ls.length; i++) {
                keys.push(this.ls.key(i));
            }
            return keys;
        } catch (e) {
            console.error('Error retrieving all localStorage keys:', e);
            return [];
        }
    }
}

export default new LocalStorageService();