
const API_ROOT = 'https://api.boss707.com';
export const fetchMatchExposure = async (userId, matchId) => {
  const token = localStorage.getItem('token');
  const response = await fetch(`${API_ROOT}/exposures/${userId}/${matchId}`, {
    headers: {
      'Authorization': `Bearer ${token}`,
    },
  });
  const data = await response.json();
  if (!data.success) throw new Error('Failed to fetch exposures');
  return data.exposures;
};
