import React, { createContext, useContext, useState, useEffect } from 'react';
import { Event } from '../Helper';
import storage from '../Storage';

// Create the context
const EventContext = createContext();

// Provider component
export const EventProvider = ({ children }) => {
  // Initialize avatarUrl with default URL if nothing valid in localStorage
  const [avatarUrl, setAvatarUrl] = useState(() => {
    const storedAvatar = storage.getKey('avatarUrl');
    const defaultUrl = '//img2.distributedresourcestorage.com/avatar/57268122/s?t=0';
    
    // Check if storedAvatar exists and is a valid URL
    if (storedAvatar && storedAvatar !== 'http://localhost:3005/uploads/avatar.png') {
     
      return storedAvatar;
    }
   
    return defaultUrl;
  });

  // Listen for avatar updates
//   useEffect(() => {

//       if (newAvatarUrl && newAvatarUrl !== avatarUrl) {
//         console.log('Avatar updated to:', newAvatarUrl);
//         setAvatarUrl(newAvatarUrl);
//         storage.setKey('avatar', newAvatarUrl);
//       }
  
//   }, [avatarUrl]); // Added avatarUrl as dependency

  // Function to update avatar
  const updateAvatar = (newAvatarUrl) => {
    if (newAvatarUrl && newAvatarUrl !== avatarUrl) {
    
      setAvatarUrl(newAvatarUrl);
      storage.setKey('avatarUrl', newAvatarUrl);
    
    }
  };

  // Context value
  const value = {
    avatarUrl,
    updateAvatar
  };

  // Log current avatar URL on render
  useEffect(() => {
   
  }, [avatarUrl]);

  return (
    <EventContext.Provider value={value}>
      {children}
    </EventContext.Provider>
  );
};

// Custom hook to use the context
export const useEvent = () => {
  const context = useContext(EventContext);
  if (context === undefined) {
    throw new Error('useEvent must be used within an EventProvider');
  }
  return context;
};

export default EventContext;