var _ = require("lodash");
var axios = require("axios");
var qs = require("qs");
var md5 = require("md5");

const PID = 3064;
const VERSION = 3;
const TOKEN = "fb216c4fead6630de2551643267d5ab0";
const CALLBACK = "http://api-transfer-wallet.8provider.com/callback_handler";

const EVO = {};

function makeExpired(add) {
    var d = new Date();
    var m = d.getMonth();
    var d = parseFloat(d.getDay()) + add;
    return `2021-${m}-${d}`;
}

function queryString(obj) {
    var v = _.values(obj);
    v = _.toString(v);
    v = _.replace(v, ",", "*");
    return v;
}

function makeSignature(param) {
    const args = queryString(param);
    let parts = [PID, VERSION, args, TOKEN];
    var beforeHash = parts.join("*");
        beforeHash = _.toString(beforeHash)
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = _.replace(beforeHash, ',', '*');
        beforeHash = beforeHash.trim();
    return md5(beforeHash);
}

EVO.register = function (name, currency, callback) {
    let data = {
        project: PID,
        version: VERSION,
        user_name: name,
        currency: currency,
    };
    var sig = makeSignature({ name, currency });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/User/registerWithName?signature=${sig}`,
       method:'POST',
        data: qs.stringify(data),
    }).then(function (req) {
        var response = req.data;
        callback(response.user_id);
    });
};

EVO.switchCurrency = function (uid, currency, callback) {
    let data = {
        project: PID,
        version: VERSION,
        user_id: uid,
        to_currency: currency,
    };
    var sig = makeSignature({ uid, currency });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/User/switchCurrency?signature=${sig}`,
        method:'POST',
        data: qs.stringify(data),
    }).then(function (req) {
        var response = req.data;
        callback(response);
    });
};

EVO.getInfo = function (uid, callback) {
    let data = {
        project: PID,
        version: VERSION,
        user_id: uid,
    };

    var sig = makeSignature({ uid });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/User/infoById?signature=${sig}`,
       method:'POST',
        data: qs.stringify(data),
    }).then(function (req) {
        var response = req.data;
        callback(response);
    });
};

EVO.getTransactions = function (uid, type, callback) {
    let data = {
        project: PID,
        version: VERSION,
        user_id: uid,
        type: type,
    };
    var sig = makeSignature({ uid, type });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/Finance/gettransactions?signature=${sig}`,
       method:'POST',
        data: qs.stringify(data),
    }).then(function (req) {
        var response = req.data;
        callback(response);
    });
};

EVO.getEvents = function (uid, gid, callback) {
    let data = {
        project: PID,
        version: VERSION,
        user_id: uid,
        game_id: gid,
    };

    var sig = makeSignature({ uid, gid });

    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/Game/getEvents?signature=${sig}`,
       method:'POST',
        data: qs.stringify(data),
    }).then(function (req) {
        var response = req.data;
        callback(response);
    });
};

EVO.getLink = function (uid, gid, callback) {
    var o = 1;
  
    var sig = makeSignature({ uid, gid, o })
    
    var url = `http://api-transfer-wallet.8provider.com/Game/getIFrameURLAdvanced?project=${PID}&version=${VERSION}&signature=${sig}&fun_mode=0&denomination=1.00&return_url_info=1&settings[https]=1&user_id=${uid}&game=${gid}`;


        axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
            url: url,
            method:'GET'
        })
        .then(function (req) {
            return callback(req.data.link);
        })
        .catch(function (e) {
            console.log("Error on Sending Request Slots", e);
        });
};

EVO.deposit = function (uid, amount, currency, callback) {
    var tid = Math.floor(Math.random() * 500000);
    var sig = makeSignature({ tid, uid, amount, currency });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/Finance/deposit?project=${PID}&version=${VERSION}&wl_transaction_id=${tid}&user_id=${uid}&sum=${amount}&currency=${currency}&signature=${sig}`,
        method:'GET'
    })
        .then(function (req) {
            var response = req.data;
            callback(response);
        })
        .catch(function (error) {
            console.log(error);
        });
};

EVO.withdrawal = function (uid, amount, currency, callback) {
    var tid = Math.floor(Math.random() * 500000);
    var sig = makeSignature({ tid, uid, amount, currency });
    axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
        url: `http://api-transfer-wallet.8provider.com/Finance/withdrawal?project=${PID}&version=${VERSION}&wl_transaction_id=${tid}&user_id=${uid}&sum=${amount}&currency=${currency}&signature=${sig}`,
        method:'GET'
    })
        .then(function (req) {
            var response = req.data;
            callback(response);
        })
        .catch(function (error) {
            console.log(error);
        });
};

//Export EVO Module
module.exports = EVO;