import axios from 'axios';

const API_URL = 'https://libretranslate.de/translate';
const API_KEY = 'c05e27cd-0f27-420e-b6fc-c0a27dee2230'; // Replace with your actual API key

export const translateText = async (text, targetLang) => {
  try {
    const response = await axios.post(
      API_URL,
      {
        q: text,
        source: 'en', // Assuming the source text is in English
        target: targetLang,
        format: 'text'
      },
      {
        headers: {
          'Authorization': `Bearer ${API_KEY}`
        }
      }
    );
    return response.data.translatedText;
  } catch (error) {
    console.error('Translation error:', error);
    return text; // Fallback to original text in case of error
  }
};
