import { initializeApp } from 'firebase/app';
import { getMessaging, getToken as getFCMToken, onMessage } from 'firebase/messaging'; // Renamed getToken to getFCMToken
import firebaseConfig from '../firebase-config';
import axios from 'axios';

const app = initializeApp(firebaseConfig);
const messaging = getMessaging(app);


export const getToken = async () => {
    try {
        // First check if service worker is registered
        if (!('serviceWorker' in navigator)) {
            throw new Error('Service Worker not supported');
        }

        // // Register service worker if not already registered
        // const registration = await navigator.serviceWorker.register('/firebase-messaging-sw.js');
        // await registration.update(); // Ensure latest version

        const permission = await Notification.requestPermission();
        if (permission !== "granted") {
            throw new Error('Notification permission denied');
        }

        const token = await getFCMToken(messaging, {
            vapidKey: "BD4zRY-9w-J4qkM_QegaPj1ETa6mD3unwfdj7enBuF6zjclIua38-e4dxDcK8QW4FDEl4A0Ecu5q5gvxVeDom9E"
        });

        if (!token) {
            throw new Error('Failed to get FCM token');
        }

        return token;
    } catch (error) {
        console.error('FCM token error:', error);
        throw error;
    }
};

export const onMessageListener = (callback) => {
    // Handle foreground messages
    return onMessage(messaging, (payload) => {
        console.log('Received foreground message:', payload);
        
        // Show notification even when app is in foreground
        if (Notification.permission === "granted") {
            const notification = new Notification(payload.notification.title, {
                body: payload.notification.body,
                icon: './assets/boss707.png"',
                tag: 'notification-' + Date.now()
            });

            // Handle notification click
            notification.onclick = (event) => {
                event.preventDefault();
                window.focus();
                notification.close();
            };
        }

        // Call the original callback
        callback(payload);
    });
};
export const cleanupNotifications = async () => {
    try {
      // Clear existing notifications through service worker
      if ('serviceWorker' in navigator) {
        const registrations = await navigator.serviceWorker.getRegistrations();
        for (const registration of registrations) {
          const notifications = await registration.getNotifications();
          notifications.forEach(notification => notification.close());
        }
      }
    } catch (error) {
      console.error('Failed to cleanup notifications:', error);
    }
  };