import axios from 'axios';
import { sendNotfication } from '../Helper';

export const launchGame = async (gameUid, userId, currencyCode,amount) => {
  
try {

  const coins = localStorage.getItem('coin') || 'USDT';
  if (coins !== 'USDT'&&coins !== 'INR') {
      sendNotfication("Please Swap Into USDT To Play", "error");
    this.setState({ loading: false });
    return;
  }

    const payload = {
      game_uid: gameUid,
      user_id: userId,
      credit_amount: amount,
      currency_code: currencyCode,
      language:'en',
    };
   
     // Make the API call to launch the game
          const token = localStorage.getItem('token');
          const response = await fetch('https://api.boss707.com/jsGamesv2/launch', {
            method: 'POST',
            headers: {
              'Authorization': `Bearer ${token}`,
              'Content-Type': 'application/json',
            },
            body: JSON.stringify(payload),
          });
    
          // Check if the response is successful
          if (!response.ok) {
            // throw new Error("Network response was not ok");
            sendNotfication("Error Launching Game","error")
          }    
    
          // Parse the response
          const result = await response.json();
    
          // Check if game launch was successful
          if (result.success && result.data.game_launch_url) {
          
            return result.data.game_launch_url
          }

  } catch (error) {
    console.error('Error launching game:', error);

    return null;
  }
};
 