import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const affiliateService = {
  // Get referral info
  getReferralInfo: async (id) => {
    const token = getAuthToken();
    return await apiService.get(`/affiliate/referral-info/${id}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get team info
  getTeamInfo: async (referralCode) => {
    const token = getAuthToken();
    return await apiService.get(`/affiliate/team/${referralCode}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get rewards info
  getRewardsInfo: async (referralCode) => {
    const token = getAuthToken();
    return await apiService.get(`/affiliate/rewards/${referralCode}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default affiliateService; 