import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const swapService = {
  // Internal swap
  internalSwap: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/internalswap/swap', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get base rate
  getBaseRate: async (url) => {
    const token = getAuthToken();
    return await apiService.get(url, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get swap rate
  getSwapRate: async (url) => {
    const token = getAuthToken();
    return await apiService.get(url, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default swapService; 