'use strict'

const mssql = require('./')

const sqlConfig = {
  password: 'P@ssw0rd',
  database: 'StockDB',
  stream: false,
  options: {
    trustServerCertificate: true,
    enableArithAbort: true,
    encrypt: true,
    abortTransactionOnError: false,
  },
  pool: {
    max: 1,
    min: 0,
  },
  port: 1433,
  user: 'sa',
  server: 'localhost',
}

const client = new mssql.ConnectionPool(sqlConfig)

async function run () {
  try {
    console.time('connect')
    const pool = await client.connect()
    console.timeEnd('connect')
    const request = pool.request()
    console.time('query')
    await request.query('select 1')
    console.timeEnd('query')
    console.time('query')
    await request.query('select 1')
    console.timeEnd('query')
  } finally {
    await client.close()
  }
}

run()
