import { useEffect, useRef } from "react";

function Loader() {
  const videoRef = useRef(null);

  useEffect(() => {
    // Ensure the video plays automatically when the component is mounted
    if (videoRef.current) {
      videoRef.current.play();
    }
  }, []);

  return (

    <div className="w-full h-[calc(100vh-60px)] flex justify-center items-center bg-transparent">
      <img
        className="w-auto h-auto  p-4"
        src="/loader.gif"
        alt="Loading..."
      />
    </div>

    // <div className="w-full h-[calc(100vh-60px)] flex justify-center items-center">
    //   <video
    //     ref={videoRef}
    //     src="/loader.gif"
    //     autoPlay
    //     loop
    //     muted
    //     className="w-32 h-32 "
    //   ></video>
    // </div>
  );
}

export default Loader;
