import { useEffect, useState } from "react";
import { userTurnover } from "../../redux/_reducers/_reducers";
import { useDispatch, useSelector } from "react-redux";
import { RxCross2 } from "react-icons/rx";
import moment from "moment/moment";

function Turnover({ handleClose }) {
    const dispatch = useDispatch();
    const [activeTab, setActiveTab] = useState("active");

    const { userTurnoverData } = useSelector((state) => state.authentication);
    // console.log(userTurnoverData, "222");

    useEffect(() => {
        let reqData = {
            from_date: moment().startOf("day").unix(),
            to_date: moment().unix(),
            // from_date: "1751221800",
            // to_date: "1751849356",
        };
        dispatch(userTurnover(reqData))
    }, [dispatch]);

    const handleDataFunc = (tab) => {
        setActiveTab(tab);
    };

    return (
        <>
            <div className="bg-white w-lg mx-auto overflow-y-auto">
                <div className='flex justify-between text-white text-[19px] md:rounded-tr-md md:rounded-tl-md w-full items-center bg-[var(--primary)] py-[10px] px-2'>
                    <div></div>
                    Turnover
                    <RxCross2 className='text-white cursor-pointer'
                        onClick={() => handleClose()}
                    />
                </div>
                <div className="bg-[var(--primary)] overflow-hidden border-[1px] border-slate-300">
                    <div className="w-full flex justify-between items-center text-white font-bold text-[14px]">
                        <div
                            onClick={() => handleDataFunc("active")}
                            className={`w-full p-2 text-center cursor-pointer transition-all duration-300 ${activeTab === "active" ? "text-[#ffe800] bg-[var(--primary)] border-b-2 border-[#ffe800]" : ""
                                }`}
                        >
                            Active
                        </div>
                        <div
                            onClick={() => handleDataFunc("completed")}
                            className={`w-full p-2 text-center cursor-pointer transition-all duration-300 ${activeTab === "completed" ? "text-[#ffe800] bg-[var(--primary)] border-b-2 border-[#ffe800]" : ""
                                }`}
                        >
                            Completed
                        </div>
                    </div>
                </div>
                <div className="text-sm font-medium text-center">
                    {activeTab === "active" ? (
                        <div className="overflow-x-auto p-1">
                            <table className="w-full border-collapse border border-gray-200 text-sm text-center">
                                <thead className="">
                                    <tr className="bg-[var(--light-header)] text-white">
                                        {/* <th className="p-2 whitespace-nowrap border">User Name</th>
                                        <th className="p-2 whitespace-nowrap border">Name</th> */}
                                        <th className="p-2 whitespace-nowrap border">Turnover Amount</th>
                                        <th className="p-2 whitespace-nowrap border">Amount</th>
                                        <th className="p-2 whitespace-nowrap border">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {userTurnoverData && userTurnoverData?.length > 0 ? (
                                        userTurnoverData?.filter((item) => item.is_trunover_complete === "N")?.map((element, index) => (
                                            <tr key={index} className="text-center">
                                                {/* <td className="p-2 border">{element?.name}</td>
                                                <td className="p-2 border whitespace-nowrap">{element?.user_name}</td> */}
                                                <td className="p-2 border">{element?.is_trunover_amount ?? 0}</td>
                                                <td className="p-2 border">{element?.amount}</td>
                                                <td className="p-2 border">{element?.is_trunover_complete}</td>
                                            </tr>
                                        ))
                                    ) : (
                                        <tr>
                                            <td colSpan="5" className="p-4 text-center">No data available!!</td>
                                        </tr>
                                    )}
                                </tbody>
                            </table>
                        </div>
                    ) : (
                        <div className="overflow-x-auto p-1">
                            <table className="w-full border-collapse border border-gray-200 text-sm text-center">
                                <thead className="">
                                    <tr className="bg-[var(--light-header)] text-white">
                                        {/* <th className="p-2 whitespace-nowrap border">User Name</th>
                                        <th className="p-2 whitespace-nowrap border">Name</th> */}
                                        <th className="p-2 whitespace-nowrap border">Turnover Amount</th>
                                        <th className="p-2 whitespace-nowrap border">Amount</th>
                                        <th className="p-2 whitespace-nowrap border">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {userTurnoverData && userTurnoverData?.length > 0 ? (
                                        userTurnoverData?.filter((item) => item.is_trunover_complete === "Y")?.map((element, index) => (
                                            <tr key={index} className="text-center">
                                                {/* <td className="p-2 border">{element?.name}</td>
                                                <td className="p-2 border whitespace-nowrap">{element?.user_name}</td> */}
                                                <td className="p-2 border">{element?.is_trunover_amount ?? 0}</td>
                                                <td className="p-2 border">{element?.amount}</td>
                                                <td className="p-2 border">{element?.is_trunover_complete}</td>
                                            </tr>
                                        ))
                                    ) : (
                                        <tr>
                                            <td colSpan="5" className="p-4 text-center">No data available!!</td>
                                        </tr>
                                    )}
                                </tbody>
                            </table>
                        </div>
                    )}
                </div>
            </div>
        </>
    )
}

export default Turnover;