import { useState, useEffect } from "react";
import { FaTimes } from "react-icons/fa";
import { useSelector } from "react-redux";
import settings from "../../domainConfig";


function DashboardModal({ setShowModal }) {
    const { defaultSettingData } = useSelector(state => state.authentication);



    const closeModal = () => {
        setShowModal(false);
        localStorage.setItem("dashboardModalOpen", false);
    };

    useEffect(() => {
        document.body.classList.add("overflow-hidden");
        return () => {
            document.body.classList.remove("overflow-hidden");
        };
    }, []);

    const dashboardPopup = defaultSettingData?.find((data) => data?.key === "site.welcome_popup");



    return (
        <>
            {/* {dashboardPopup && dashboardPopup?.length > 0 ? ( */}
                dashboardPopup && (
                    <div
                        className="fixed top-0 left-0 w-full h-full flex justify-center items-center px-2"
                        style={{ zIndex: 999999 }}>
                        <div className="bg-white rounded-lg animate-slideInFromBottom transition-transform duration-700 linear">

                            <div className="relative md:w-[400px] w-[350px] bg-white flex flex-col justify-center items-center rounded-lg shadow-lg">
                                <button
                                    className="absolute top-0 right-0 bg-[var(--secondary)] p-3 text-white rounded-tr-lg"
                                    onClick={closeModal}>
                                    <FaTimes size={18} />
                                </button>

                                <img
                                    className=" object-cover rounded-lg"
                                    src={`${settings.IMAGE_URL}${dashboardPopup?.value}`}
                                />

                            </div>

                            {/* <div className="border-t flex justify-end items-center w-full pt-2 border-gray-300 bg-white">
                            <button className=" top-0 right-0 mr-4 px-2 py-1.5 text-sm rounded text-white bg-[#6C757D]" onClick={closeModal}>
                                Close
                            </button>
                        </div> */}
                        </div>
                    </div>
                )
            {/* )  */}
            {/* : null} */}
        </>
    );
}

export default DashboardModal;