import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { toast } from "react-toastify";
import { defaultSetting, ourPages } from "../../redux/_reducers/_reducers";
import Privacy from "../dashboard/privacy";
import settings from "../../domainConfig";

const Footer = () => {
    const [isPrivacy, setIsPrivacy] = useState(false);
    const [activeSection, setActiveSection] = useState(1);

    const privacyClick = (sectionId) => {
        setActiveSection(sectionId);
        setIsPrivacy(true);
    };

    const dispatch = useDispatch()
    const { defaultSettingData, ourPagesData } = useSelector(state => state.authentication);
    const SiteTitle = defaultSettingData?.find((item) => item.key === "site.TITLE")?.value;
    const LogoImg = defaultSettingData?.find((item) => item.key === "site.LOGO")?.value;

    useEffect(() => {
        dispatch(defaultSetting())
    }, [])
    useEffect(() => {
        dispatch(ourPages())
    }, [])
    const aboutUs = ourPagesData?.find((item) => item.slug === "about-us");
    const privacyPolicy = ourPagesData?.find((item) => item.slug === "privacy-policy");
    const termsCondition = ourPagesData?.find((item) => item.slug == "terms-and-conditions");
    const refundPolicy = ourPagesData?.find((item) => item.slug == "refund-policy");
    const kyc = ourPagesData?.find((item) => item.slug == "kyc-and-aml");
    return (
        <footer className="my-4 lg:ml-0 ml-2">
            {isPrivacy && (
                <Privacy
                    activeSection={activeSection}
                    privacyClick={() => setIsPrivacy(false)}
                />
            )}
            <div className="space-y-5 ">

                <div className="">
                    <h3 className="text-[14px] font-[600] text-gray-600 mb-1">Payment Methods</h3>
                    <div className="sm:flex justify-start grid grid-cols-5 items-center sm:gap-4 gap-3 py-2">
                        {paymentMethods?.map((method, index) => (
                            <a key={index} href={method.link} target="_blank" className="">
                                <img src={method.image} className="w-[50px] h-[15px]" alt={method.name} />
                            </a>
                        ))}
                    </div>
                </div>


                {defaultSettingData?.some(data =>
                    ["site.facebook", "site.instagram", "site.twitter", "site.telegram", "site.pinterest", "site.youtube"]
                        .includes(data?.key) && data?.value
                ) && (
                        <div className="">
                            <h3 className="text-sm font-[600] text-[#555] mb-4">Social Networks</h3>
                            <div className="flex justify-start md:space-x-3 space-x-2">
                                {defaultSettingData?.find((data) => data?.key === "site.facebook")?.value && (
                                    <div
                                        onClick={() => {
                                            const telegramLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.facebook"
                                            )?.value;

                                            if (telegramLink) {
                                                window.open(telegramLink, "_blank");
                                            } else {
                                                toast.error("Telegram link not found");
                                            }
                                        }}
                                        className="text-blue-500 hover:text-blue-400">
                                        <img className="w-[24px] h-[24px]" src='/assets/dashboard/facebook.png' alt='' />
                                    </div>)}
                                {defaultSettingData?.find((data) => data?.key === "site.instagram")?.value && (
                                    <div
                                        onClick={() => {
                                            const telegramLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.instagram"
                                            )?.value;
                                            if (telegramLink) {
                                                window.open(telegramLink, "_blank");
                                            } else {
                                                toast.error("Telegram link not found");
                                            }
                                        }}
                                        target="_blank" className="text-pink-500 hover:text-pink-400">
                                        <img className="w-[24px] h-[24px]" src='/assets/dashboard/instagram.png' alt='' />
                                    </div>)}
                                {defaultSettingData?.find((data) => data?.key === "site.twitter")?.value && (
                                    <div
                                        onClick={() => {
                                            const twitterLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.twitter"
                                            )?.value;
                                            if (twitterLink) {
                                                window.open(twitterLink, "_blank");
                                            } else {
                                                toast.error("Twitter link not found");
                                            }
                                        }}
                                        target="_blank" className="text-blue-400 hover:text-blue-300">
                                        <img
                                            className="w-[24px] h-[24px]" src='/assets/dashboard/twitter.png' alt='' />
                                    </div>)}
                                {defaultSettingData?.find((data) => data?.key === "site.telegram")?.value && (
                                    <div
                                        onClick={() => {
                                            const telegramLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.telegram"
                                            )?.value;
                                            if (telegramLink) {
                                                window.open(telegramLink, "_blank");
                                            } else {
                                                toast.error("Telegram link not found");
                                            }
                                        }}
                                        target="_blank" className="text-blue-400 hover:text-blue-300">
                                        <img
                                            className="w-[24px] h-[24px]" src='/assets/dashboard/telegram-channel.png' alt='' />
                                    </div>)}
                                {defaultSettingData?.find((data) => data?.key === "site.pinterest")?.value && (
                                    <div
                                        onClick={() => {
                                            const twitterLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.pinterest"
                                            )?.value;
                                            if (twitterLink) {
                                                window.open(twitterLink, "_blank");
                                            } else {
                                                toast.error("Pinterest Link not found");
                                            }
                                        }}
                                        target="_blank" className="text-blue-400 hover:text-blue-300">
                                        <img className="w-[24px] h-[24px]" src='/assets/dashboard/pinterest.png' alt='' />
                                    </div>)}
                                {defaultSettingData?.find((data) => data?.key === "site.youtube")?.value && (
                                    <div
                                        onClick={() => {
                                            const twitterLink = defaultSettingData?.find(
                                                (data) => data?.key === "site.youtube"
                                            )?.value;
                                            if (twitterLink) {
                                                window.open(twitterLink, "_blank");
                                            } else {
                                                toast.error("YouTube Link not found");
                                            }
                                        }}
                                        target="_blank" className="text-blue-400 hover:text-blue-300">
                                        <img className="w-[24px] h-[24px]" src='/assets/dashboard/youtube.png' alt='' />
                                    </div>)}
                            </div>
                        </div>)}

            </div>

            <div className="px-1 py-5 border-t-2 border-gray-200 mt-6">
                <div className="overflow-hidden capitalize whitespace-nowrap flex justify-start items-center flex-wrap  md:gap-2 gap-3 font-[600] text-[var(--primary)] text-left text-[13px]">
                    <div onClick={() => privacyClick(aboutUs?.slug)} className="cursor-pointer">| {aboutUs?.slug || "about-us"} </div>
                    <div onClick={() => privacyClick(privacyPolicy?.slug)} className="cursor-pointer">| {privacyPolicy?.slug || "privacy-policy"} </div>
                    <div onClick={() => privacyClick(termsCondition?.slug)} className="cursor-pointer">| {termsCondition?.slug || "terms-condition"}</div>
                </div>
                {/* <div onClick={() => privacyClick(refundPolicy?.slug)}  className="">| {refundPolicy?.slug || "refund-policy"}</div>
                    <div onClick={() => privacyClick(kyc?.slug)}  className="">| {kyc?.slug || "KYC"}</div> */}
            </div>

            {/* <div className="mt-4 mx-auto text-left md:text-xs text-[10px] font-bold text-black flex gap-4 justify-start items-center">
                <a
                    target="_blank" className="flex justify-center items-center">
                    <img src={`${settings.IMAGE_URL}${LogoImg}`} className="h-[45px]" alt='Footer Logo' />
                </a>
                <div>
                    <p className="text-[var(--primary)]"> Best Quality Platform </p>
                    <p className="text-[#999]">© 2025 {`${SiteTitle}`} Copyrights. All Rights Reserved.</p>
                </div>
            </div> */}
        </footer>
    )
}

export default Footer;

export const paymentMethods = [
    { name: "Bank", image: "/assets/dashboard/pay16.png", link: "#" },
    { name: "Rupee", image: "/assets/dashboard/pay17.png", link: "#" },
    { name: "UPI", image: "/assets/dashboard/pay18.png", link: "#" },
    { name: "PhonePe", image: "/assets/dashboard/pay19.png", link: "#" },
    { name: "Paytm", image: "/assets/dashboard/pay20.png", link: "#" },
    { name: "IMPS", image: "/assets/dashboard/pay21.png", link: "#" },
    { name: "iPay", image: "/assets/dashboard/pay46.png", link: "#" }
];

