import React from "react";
import { FaTimes } from "react-icons/fa";
import { RxCross2 } from "react-icons/rx";

const currencies = [
    {
        flag: "/footer_images/IN.png",
        label: "₹ INR",
        languages: ["English", "हिंदी"],
    },
    {
        flag: "/footer_images/BD.png",
        label: "৳ BDT",
        languages: ["বাংলা", "English"],
    },
    {
        flag: "/footer_images/PK.png",
        label: "Rs PKR",
        languages: ["English"],
    },
    {
        flag: "/footer_images/US.png",
        label: "USDT",
        languages: ["English"],
    },
    {
        flag: "/footer_images/NP.png",
        label: "Rs NPR",
        languages: ["नेपाली", "English"],
    },
    {
        flag: "/footer_images/LK.png",
        label: "Rs LKR",
        languages: ["English"],
    },
    {
        flag: "/footer_images/AE.png",
        label: "AED AED",
        languages: ["English"],
    },
];

const LanguageModal = ({ handleLanguage }) => {
    return (
        <div className="fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 ">
            <div className="bg-white w-11/12 max-w-md shadow-lg animate-slideInFromBottom">
                <div className="bg-[var(--primary)] text-white px-4 py-4 flex justify-between items-center ">
                    <h2 className="text-lg font-semibold">Currency and Language</h2>
                    <button onClick={() => handleLanguage()} className="text-white text-xl">
                        <RxCross2 />
                    </button>
                </div>

                <div className="p-4 space-y-4">
                    {currencies?.map((item, index) => (
                        <div key={index} className="flex items-center gap-4 pb-2.5 border-b border-[#dddddd]">
                            <img src={item?.flag} className="w-[34px] h-[34px]"/>
                            <span className="w-20 text-[#5559]">{item.label}</span>
                            <div className="flex gap-2">
                                {item?.languages.map((element, i) => (
                                    <button
                                        key={i}
                                        className="border border-gray-300 px-5 w-full py-2 text-sm hover:bg-gray-100"
                                    >
                                        {element}
                                    </button>
                                ))}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </div>
    );
};

export default LanguageModal;